/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.HashMap;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropFuncBlock;
import mod.lucky.drop.func.DropFuncCommand;
import mod.lucky.drop.func.DropFuncDifficulty;
import mod.lucky.drop.func.DropFuncEffect;
import mod.lucky.drop.func.DropFuncEntity;
import mod.lucky.drop.func.DropFuncExplosion;
import mod.lucky.drop.func.DropFuncFill;
import mod.lucky.drop.func.DropFuncItem;
import mod.lucky.drop.func.DropFuncMessage;
import mod.lucky.drop.func.DropFuncNothing;
import mod.lucky.drop.func.DropFuncParticle;
import mod.lucky.drop.func.DropFuncSound;
import mod.lucky.drop.func.DropFuncStructure;
import mod.lucky.drop.func.DropFuncTime;
import mod.lucky.drop.func.DropProcessData;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DropFunc {
    private static HashMap<String, DropFunc> dropFunctions = new HashMap();

    public abstract void process(DropProcessData var1);

    public abstract String getType();

    public void registerProperties() {
    }

    public static void registerGlobalProperties() {
        DropSingle.setDefaultProperty("all", "type", String.class, "item");
        DropSingle.setDefaultProperty("all", "ID", String.class, "");
        DropSingle.setDefaultProperty("all", "damage", Integer.class, 0);
        DropSingle.setDefaultProperty("all", "amount", Integer.class, 1);
        DropSingle.setDefaultProperty("all", "reinitialize", Boolean.class, false);
        DropSingle.setDefaultProperty("all", "postDelayInit", Boolean.class, true);
        DropSingle.setDefaultProperty("all", "delay", Float.class, 0);
        DropSingle.setDefaultProperty("all", "posX", Float.class, 0);
        DropSingle.setDefaultProperty("all", "posY", Float.class, 0);
        DropSingle.setDefaultProperty("all", "posZ", Float.class, 0);
        DropSingle.setDefaultProperty("all", "pos", String.class, "(0,0,0)");
        DropSingle.setDefaultProperty("all", "pos2X", Float.class, 0);
        DropSingle.setDefaultProperty("all", "pos2Y", Float.class, 0);
        DropSingle.setDefaultProperty("all", "pos2Z", Float.class, 0);
        DropSingle.setDefaultProperty("all", "pos2", String.class, "(0,0,0)");
        DropSingle.setDefaultProperty("all", "posOffsetX", Float.class, 0);
        DropSingle.setDefaultProperty("all", "posOffsetY", Float.class, 0);
        DropSingle.setDefaultProperty("all", "posOffsetZ", Float.class, 0);
        DropSingle.setDefaultProperty("all", "posOffset", String.class, "(0,0,0)");
        DropSingle.setDefaultProperty("all", "centerX", Integer.class, 0);
        DropSingle.setDefaultProperty("all", "centerY", Integer.class, 0);
        DropSingle.setDefaultProperty("all", "centerZ", Integer.class, 0);
        DropSingle.setDefaultProperty("all", "rotation", Integer.class, 0);
        DropSingle.setDefaultProperty("all", "doUpdate", Boolean.class, false);
        DropSingle.setDefaultProperty("all", "applyBlockMode", String.class, "replace");
        DropSingle.setDefaultProperty("all", "displayCommandOutput", Boolean.class, false);
        DropSingle.setDefaultProperty("all", "commandSender", String.class, "@");
        DropSingle.setDefaultProperty("all", "duration", Integer.class, 200);
        DropSingle.setDefaultProperty("all", "NBTTag", NBTTagCompound.class, null);
    }

    public static void registerFunctions() {
        DropFunc.registerDropFunction(new DropFuncBlock());
        DropFunc.registerDropFunction(new DropFuncCommand());
        DropFunc.registerDropFunction(new DropFuncDifficulty());
        DropFunc.registerDropFunction(new DropFuncEffect());
        DropFunc.registerDropFunction(new DropFuncEntity());
        DropFunc.registerDropFunction(new DropFuncExplosion());
        DropFunc.registerDropFunction(new DropFuncFill());
        DropFunc.registerDropFunction(new DropFuncItem());
        DropFunc.registerDropFunction(new DropFuncMessage());
        DropFunc.registerDropFunction(new DropFuncParticle());
        DropFunc.registerDropFunction(new DropFuncSound());
        DropFunc.registerDropFunction(new DropFuncStructure());
        DropFunc.registerDropFunction(new DropFuncTime());
        DropFunc.registerDropFunction(new DropFuncNothing());
        DropFunc.registerGlobalProperties();
    }

    public static DropFunc getDropFunction(DropSingle dropSingle) {
        return DropFunc.getDropFunction(dropSingle.getPropertyString("type"));
    }

    public static DropFunc getDropFunction(String type) {
        return dropFunctions.get(type);
    }

    public static void registerDropFunction(DropFunc dropFunction) {
        dropFunctions.put(dropFunction.getType(), dropFunction);
        dropFunction.registerProperties();
    }
}

