/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.UUID;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropFunc;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.entity.EntityLuckyProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;

public class DropFuncEntity
extends DropFunc {
    @Override
    public void process(DropProcessData processData) {
        DropSingle drop = processData.getDropSingle();
        float posX = drop.getPropertyFloat("posX").floatValue();
        float posY = drop.getPropertyFloat("posY").floatValue();
        float posZ = drop.getPropertyFloat("posZ").floatValue();
        if (posY <= -1.0f) {
            return;
        }
        NBTTagCompound nbtTagCompound = drop.getPropertyNBT("NBTTag") == null ? new NBTTagCompound() : drop.getPropertyNBT("NBTTag");
        String id = drop.getPropertyString("ID");
        if (id.equals("lightning_bolt") || id.equals("LightningBolt")) {
            processData.getWorld().func_72942_c((Entity)new EntityLightningBolt(processData.getWorld(), (double)posX, (double)posY, (double)posZ, false));
            return;
        }
        nbtTagCompound.func_74778_a("id", id);
        DropFuncEntity.spawnEntity(processData, nbtTagCompound, processData.getWorld(), posX, posY, posZ);
    }

    private static Entity spawnEntity(DropProcessData processData, NBTTagCompound tag, World world, double posX, double posY, double posZ) {
        Entity entity;
        for (int y = 0; y < 10; ++y) {
            if (!processData.getWorld().func_175623_d(new BlockPos(posX, posY + (double)y, posZ))) continue;
            posY += (double)y;
            break;
        }
        if (tag.func_74764_b("Pos")) {
            NBTTagList posList = tag.func_150295_c("Pos", 6);
            posX = posList.func_150309_d(0);
            posY = posList.func_150309_d(1);
            posZ = posList.func_150309_d(2);
        }
        if ((entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)tag, (World)world, (double)posX, (double)posY, (double)posZ, (boolean)true)) == null) {
            return null;
        }
        UUID playerUUID = processData.getPlayer().func_110124_au();
        if (entity instanceof EntityFallingBlock && !tag.func_74764_b("Time")) {
            ((EntityFallingBlock)entity).field_145812_b = 1;
        } else if (entity instanceof EntityLuckyProjectile) {
            ((EntityLuckyProjectile)entity).field_70250_c = playerUUID;
        } else if (entity instanceof EntityArrow) {
            ((EntityArrow)entity).field_70250_c = playerUUID;
        }
        if (entity instanceof EntityLiving && processData.getProcessType() != DropProcessData.EnumProcessType.LUCKY_STRUCT && !tag.func_74764_b("Passengers")) {
            ((EntityLiving)entity).func_204210_a(world.func_175649_E(new BlockPos(entity)), null, null);
            ((EntityLiving)entity).func_70037_a(tag);
        }
        return entity;
    }

    @Override
    public void registerProperties() {
        DropSingle.setDefaultProperty(this.getType(), "NBTTag", NBTTagCompound.class, null);
        DropSingle.setDefaultProperty(this.getType(), "posX", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posY", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posZ", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posOffsetX", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posOffsetY", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posOffsetZ", Float.class, Float.valueOf(0.0f));
    }

    @Override
    public String getType() {
        return "entity";
    }
}

