/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import mod.lucky.Lucky;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropFunc;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.ValueParser;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldServer;

public class DropFuncParticle
extends DropFunc {
    @Override
    public void process(DropProcessData processData) {
        DropSingle drop = processData.getDropSingle();
        String particleIdFull = drop.getPropertyString("ID");
        String particleId = particleIdFull.split("\\.")[0];
        boolean isEvent = false;
        int eventId = 0;
        ResourceLocation particleResLoc = new ResourceLocation(particleId);
        ParticleType particleType = null;
        if (IRegistry.field_212632_u.func_212607_c(particleResLoc)) {
            particleType = (ParticleType)IRegistry.field_212632_u.func_212608_b(particleResLoc);
        }
        if (particleType == null) {
            if (ValueParser.getString(particleId, processData).equals("splashpotion")) {
                isEvent = true;
                eventId = 2002;
            } else {
                try {
                    eventId = ValueParser.getInteger(particleId, processData);
                    isEvent = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (particleType == null && !isEvent) {
            Lucky.error(null, "Invalid particle: " + particleId);
            return;
        }
        if (processData.getWorld() instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)processData.getWorld();
            if (!isEvent) {
                IParticleData particleData;
                String particleArgs = "";
                String[] splitArgs = particleIdFull.split("\\.");
                for (int i = 1; i < splitArgs.length; ++i) {
                    particleArgs = particleArgs + " " + splitArgs[i];
                }
                try {
                    StringReader argReader = new StringReader(particleArgs);
                    argReader.setCursor(0);
                    particleData = particleType.func_197571_g().func_197544_b(particleType, argReader);
                }
                catch (CommandSyntaxException e) {
                    Lucky.error((Exception)((Object)e), "Failed to process particle: " + particleId);
                    return;
                }
                float posX = drop.getPropertyFloat("posX").floatValue();
                float posY = drop.getPropertyFloat("posY").floatValue();
                float posZ = drop.getPropertyFloat("posZ").floatValue();
                int particleAmount = drop.getPropertyInt("particleAmount");
                float length = drop.getPropertyFloat("length").floatValue();
                float height = drop.getPropertyFloat("height").floatValue();
                float width = drop.getPropertyFloat("width").floatValue();
                worldServer.func_195598_a(particleData, (double)posX, (double)posY, (double)posZ, particleAmount, (double)length, (double)height, (double)width, 0.0);
            } else {
                int damage = 0;
                if (eventId == 2002) {
                    if (drop.hasProperty("potion")) {
                        ArrayList effectList = Lists.newArrayList();
                        PotionType potionType = PotionType.func_185168_a((String)drop.getPropertyString("potion"));
                        effectList.addAll(potionType.func_185170_a());
                        damage = PotionUtils.func_185181_a((Collection)effectList);
                    } else {
                        damage = drop.getPropertyInt("damage");
                    }
                }
                worldServer.func_175718_b(eventId, drop.getBlockPos(), damage);
            }
        }
    }

    @Override
    public void registerProperties() {
        DropSingle.setDefaultProperty(this.getType(), "length", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "height", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "width", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "size", String.class, "(0.0,0.0,0.0)");
        DropSingle.setDefaultProperty(this.getType(), "particleAmount", Integer.class, 1);
        DropSingle.setDefaultProperty(this.getType(), "potion", String.class, "poison");
    }

    @Override
    public String getType() {
        return "particle";
    }
}

