/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.CustomNBTTags;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.HashVariables;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringEscapeUtils;

public class ValueParser {
    public static HashBiMap<String, Class> classTypeToString = HashBiMap.create();
    private static ArrayList<String> DROP_TAGS;

    public static Object getObject(String string, Class objectType, DropProcessData processData) throws Exception {
        if (objectType == String.class) {
            return ValueParser.getString(string, processData);
        }
        if (objectType == Integer.class) {
            return ValueParser.getInteger(string, processData);
        }
        if (objectType == Boolean.class) {
            return ValueParser.getBoolean(string, processData);
        }
        if (objectType == Float.class) {
            return ValueParser.getFloat(string, processData);
        }
        if (objectType == Double.class) {
            return ValueParser.getDouble(string, processData);
        }
        if (objectType == Short.class) {
            return ValueParser.getShort(string, processData);
        }
        if (objectType == Byte.class) {
            return ValueParser.getByte(string, processData);
        }
        if (objectType == NBTTagCompound.class) {
            return ValueParser.getNBTTag(string, processData);
        }
        return null;
    }

    public static INBTBase getNBTBaseFromValue(Object value) {
        if (value.getClass() == String.class) {
            return new NBTTagString((String)value);
        }
        if (value.getClass() == Integer.class) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value.getClass() == Boolean.class) {
            return new NBTTagByte((byte)((Boolean)value == true ? 1 : 0));
        }
        if (value.getClass() == Float.class) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
        if (value instanceof INBTBase) {
            return (INBTBase)value;
        }
        return null;
    }

    public static Object getValueFromNBTBase(INBTBase nbtBase) {
        if (nbtBase.getClass() == NBTTagString.class) {
            return ((NBTTagString)nbtBase).func_150285_a_();
        }
        if (nbtBase.getClass() == NBTTagInt.class) {
            return ((NBTTagInt)nbtBase).func_150287_d();
        }
        if (nbtBase.getClass() == NBTTagByte.class) {
            return ((NBTTagByte)nbtBase).func_150290_f() == 1;
        }
        if (nbtBase.getClass() == NBTTagFloat.class) {
            return Float.valueOf(((NBTTagFloat)nbtBase).func_150288_h());
        }
        return nbtBase;
    }

    public static String getString(String string) throws NumberFormatException {
        return ValueParser.getString(string, null);
    }

    public static String getString(String string, DropProcessData processData) {
        string = HashVariables.processString(string, processData);
        if ((string = StringEscapeUtils.unescapeJava((String)string)).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static Double calculateNum(String string) throws NumberFormatException {
        int operator;
        string = DropStringUtils.removeNumSuffix(string);
        string = string.trim();
        double result = 0.0;
        String prefixSign = "";
        if (string.startsWith("-") || string.startsWith("+")) {
            prefixSign = string.substring(0, 1);
            string = string.substring(1, string.length());
        }
        int n = string.contains("+") ? 43 : (string.contains("-") ? 45 : (string.contains("*") ? 42 : (operator = string.contains("/") ? 47 : 0)));
        if (operator != 0) {
            String[] splitString = DropStringUtils.splitBracketString(string, (char)operator);
            if (splitString.length >= 2) {
                double num1 = Double.valueOf(prefixSign + splitString[0]);
                double num2 = Double.valueOf(splitString[1]);
                switch (operator) {
                    case 43: {
                        result = num1 + num2;
                        break;
                    }
                    case 45: {
                        result = num1 - num2;
                        break;
                    }
                    case 42: {
                        result = num1 * num2;
                        break;
                    }
                    case 47: {
                        result = num1 / num2;
                    }
                }
            }
        } else {
            result = Double.valueOf(prefixSign + string);
        }
        return result;
    }

    public static Integer getInteger(String string) throws NumberFormatException {
        return ValueParser.getInteger(string, null);
    }

    public static Integer getInteger(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string).intValue();
    }

    public static Double getDouble(String string) throws NumberFormatException {
        return ValueParser.getDouble(string, null);
    }

    public static Double getDouble(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string);
    }

    public static Float getFloat(String string) throws NumberFormatException {
        return ValueParser.getFloat(string, null);
    }

    public static Float getFloat(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return Float.valueOf(ValueParser.calculateNum(string).floatValue());
    }

    public static Boolean getBoolean(String string) throws NumberFormatException {
        return ValueParser.getBoolean(string, null);
    }

    public static Boolean getBoolean(String string, DropProcessData processData) throws NumberFormatException {
        if (!(string = HashVariables.processString(string, processData)).equals("true") && !string.equals("false")) {
            throw new NumberFormatException("Unknown boolean format: " + string);
        }
        return Boolean.valueOf(string);
    }

    public static Short getShort(String string) {
        return ValueParser.getShort(string, null);
    }

    public static Short getShort(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string).shortValue();
    }

    public static Byte getByte(String string) throws NumberFormatException {
        return ValueParser.getByte(string, null);
    }

    public static Byte getByte(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string).byteValue();
    }

    public static NBTTagCompound getNBTTag(String string) throws Exception {
        return ValueParser.getNBTTag(string, null);
    }

    public static NBTTagCompound getNBTTag(String string, DropProcessData processData) throws Exception {
        Object tagBase = ValueParser.getNBTTagValue(string, processData);
        if (tagBase instanceof NBTTagCompound) {
            return (NBTTagCompound)tagBase;
        }
        throw new Exception("Not a valid compound NBT tag: " + string);
    }

    public static Object getNBTTagValue(String string, DropProcessData processData) throws Exception {
        return ValueParser.getNBTTagValue(string, processData, null, null);
    }

    public static INBTBase getNBTBase(String string, DropProcessData processData) throws Exception {
        return ValueParser.getNBTBaseFromValue(ValueParser.getNBTTagValue(string, processData, null, null));
    }

    public static Object getNBTTagValue(String string, DropProcessData processData, INBTBase parentTag, String parentTagName) throws Exception {
        INBTBase tagBase22;
        if (string.startsWith("(") && string.endsWith(")")) {
            String[] tagContents = DropStringUtils.splitBracketString(string.substring(1, string.length() - 1), ',');
            NBTTagCompound tagCompound = new NBTTagCompound();
            for (String tag : tagContents) {
                if (tag == null || tag.equals("")) continue;
                String tagName = tag.substring(0, tag.indexOf("="));
                String tagValue = tag.substring(tag.indexOf("=") + 1);
                ValueParser.setNBTTagValue((INBTBase)tagCompound, tagName, ValueParser.getNBTTagValue(tagValue, processData, (INBTBase)tagCompound, tagName));
            }
            return tagCompound;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            String[] tagContents = DropStringUtils.splitBracketString(string.substring(1, string.length() - 1), ',');
            NBTTagList tagList = new NBTTagList();
            for (String tag : tagContents) {
                if (tag == null || tag.equals("")) continue;
                ValueParser.setNBTTagValue((INBTBase)tagList, null, ValueParser.getNBTTagValue(tag, processData, (INBTBase)tagList, parentTagName));
            }
            return tagList;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            if (parentTag != null && parentTag instanceof NBTTagList && parentTagName != null && DROP_TAGS.contains(parentTagName.toLowerCase())) {
                string = HashVariables.autoCancelHash(string);
            }
            return ValueParser.getString(string, processData);
        }
        if (string.startsWith("#") && (tagBase22 = CustomNBTTags.getNBTTagFromString(string, processData)) != null) {
            return tagBase22;
        }
        string = ValueParser.getString(string, processData);
        try {
            if (string.endsWith("f") || string.endsWith("F")) {
                return ValueParser.getFloat(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.endsWith("d") || string.endsWith("D") || DropStringUtils.hasDecimalPoint(string)) {
                return ValueParser.getDouble(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.endsWith("s") || string.endsWith("S")) {
                return ValueParser.getShort(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.endsWith("b") || string.endsWith("B")) {
                return ValueParser.getByte(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.equals("true") || string.equals("false")) {
                return ValueParser.getBoolean(DropStringUtils.removeNumSuffix(string), processData);
            }
            return ValueParser.getInteger(DropStringUtils.removeNumSuffix(string), processData);
        }
        catch (Exception tagBase22) {
            try {
                String[] valuesString = string.split(":");
                if (valuesString.length >= 1) {
                    boolean type = false;
                    if (valuesString[0].endsWith("b") || valuesString[0].endsWith("B")) {
                        type = true;
                    }
                    int[] valuesInt = new int[valuesString.length];
                    byte[] valuesByte = new byte[valuesString.length];
                    for (int b = 0; b < valuesString.length; ++b) {
                        if (!type) {
                            valuesInt[b] = ValueParser.getInteger(valuesString[b], processData);
                            continue;
                        }
                        valuesString[b] = DropStringUtils.removeNumSuffix(valuesString[b]);
                        valuesByte[b] = ValueParser.getByte(valuesString[b], processData);
                    }
                    if (!type && valuesInt.length > 0) {
                        return valuesInt;
                    }
                    if (type && valuesByte.length > 0) {
                        return valuesByte;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
    }

    public static void setNBTTagValue(INBTBase curTag, String tagName, Object tagValue) {
        if (curTag instanceof NBTTagCompound) {
            NBTTagCompound tagCompound = (NBTTagCompound)curTag;
            if (tagValue instanceof String) {
                tagCompound.func_74778_a(tagName, (String)tagValue);
            }
            if (tagValue instanceof Boolean) {
                tagCompound.func_74757_a(tagName, ((Boolean)tagValue).booleanValue());
            }
            if (tagValue instanceof Integer) {
                tagCompound.func_74768_a(tagName, ((Integer)tagValue).intValue());
            }
            if (tagValue instanceof Float) {
                tagCompound.func_74776_a(tagName, ((Float)tagValue).floatValue());
            }
            if (tagValue instanceof Double) {
                tagCompound.func_74780_a(tagName, ((Double)tagValue).doubleValue());
            }
            if (tagValue instanceof Short) {
                tagCompound.func_74777_a(tagName, ((Short)tagValue).shortValue());
            }
            if (tagValue instanceof Byte) {
                tagCompound.func_74774_a(tagName, ((Byte)tagValue).byteValue());
            }
            if (tagValue instanceof int[]) {
                tagCompound.func_74783_a(tagName, (int[])tagValue);
            }
            if (tagValue instanceof byte[]) {
                tagCompound.func_74773_a(tagName, (byte[])tagValue);
            }
            if (tagValue instanceof NBTTagCompound) {
                tagCompound.func_74782_a(tagName, (INBTBase)((NBTTagCompound)tagValue));
            }
            if (tagValue instanceof NBTTagList) {
                tagCompound.func_74782_a(tagName, (INBTBase)((NBTTagList)tagValue));
            }
        }
        if (curTag instanceof NBTTagList) {
            NBTTagList tagList = (NBTTagList)curTag;
            if (tagValue instanceof String) {
                tagList.add((INBTBase)new NBTTagString((String)tagValue));
            }
            if (tagValue instanceof Integer) {
                tagList.add((INBTBase)new NBTTagInt(((Integer)tagValue).intValue()));
            }
            if (tagValue instanceof Float) {
                tagList.add((INBTBase)new NBTTagFloat(((Float)tagValue).floatValue()));
            }
            if (tagValue instanceof Double) {
                tagList.add((INBTBase)new NBTTagDouble(((Double)tagValue).doubleValue()));
            }
            if (tagValue instanceof Short) {
                tagList.add((INBTBase)new NBTTagShort(((Short)tagValue).shortValue()));
            }
            if (tagValue instanceof Byte) {
                tagList.add((INBTBase)new NBTTagByte(((Byte)tagValue).byteValue()));
            }
            if (tagValue instanceof int[]) {
                tagList.add((INBTBase)new NBTTagIntArray((int[])tagValue));
            }
            if (tagValue instanceof byte[]) {
                tagList.add((INBTBase)new NBTTagByteArray((byte[])tagValue));
            }
            if (tagValue instanceof NBTTagCompound) {
                tagList.add((INBTBase)((NBTTagCompound)tagValue));
            }
            if (tagValue instanceof NBTTagList) {
                tagList.add((INBTBase)((NBTTagList)tagValue));
            }
        }
    }

    public static JsonElement nbtToJson(INBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            JsonObject json = new JsonObject();
            ((NBTTagCompound)nbt).func_150296_c().forEach(k -> json.add(k, ValueParser.nbtToJson(((NBTTagCompound)nbt).func_74781_a(k))));
            return json;
        }
        if (nbt instanceof NBTTagCollection) {
            JsonArray json = new JsonArray();
            ((NBTTagCollection)nbt).forEach(v -> json.add(ValueParser.nbtToJson(v)));
            return json;
        }
        if (nbt instanceof NBTTagByte && ((NBTTagByte)nbt).func_150290_f() < 2) {
            return new JsonPrimitive(new Boolean(((NBTTagByte)nbt).func_150290_f() == 1));
        }
        return new JsonPrimitive(nbt.func_150285_a_());
    }

    public static Item getItem(String name, DropProcessData processData) {
        String fullName = ValueParser.getString(name, processData);
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(fullName));
    }

    public static Block getBlock(String name, DropProcessData processData) {
        String fullName = ValueParser.getString(name, processData);
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(fullName));
    }

    public static ItemStack getItemStack(String name, DropProcessData processData) {
        String[] splitName = name.split("\\*");
        Item item = ValueParser.getItem(splitName[0], null);
        int count = splitName.length > 1 ? ValueParser.getInteger(splitName[1], processData) : 1;
        return new ItemStack((IItemProvider)item, count);
    }

    static {
        classTypeToString.put((Object)"string", String.class);
        classTypeToString.put((Object)"int", Integer.class);
        classTypeToString.put((Object)"boolean", Boolean.class);
        classTypeToString.put((Object)"float", Float.class);
        classTypeToString.put((Object)"nbt", NBTTagCompound.class);
        DROP_TAGS = new ArrayList<String>(Arrays.asList("drops", "impact"));
    }
}

