/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.init.SetupCommon;
import mod.lucky.item.ItemLuckyPotion;
import mod.lucky.util.LuckyUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityLuckyPotion
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM_STACK = EntityDataManager.func_187226_a(EntityLuckyPotion.class, (DataSerializer)DataSerializers.field_187196_f);
    private DropProcessor impactDropProcessor;
    private int luck = 0;
    private String[] customDrops = null;

    public void init(ItemLuckyPotion itemLuckyPotion, DropProcessor impactDropProcessor, int luck, String[] customDrops) {
        this.setItemStack(new ItemStack((IItemProvider)itemLuckyPotion, 1));
        this.impactDropProcessor = impactDropProcessor;
        this.luck = luck;
        this.customDrops = customDrops;
    }

    public EntityLuckyPotion(World world) {
        super(SetupCommon.ENTITY_LUCKY_POTION, world);
        this.init(Lucky.luckyPotion, new DropProcessor(), 0, null);
    }

    public EntityLuckyPotion(World world, EntityLivingBase thrower, ItemLuckyPotion itemLuckyPotion, DropProcessor impactDropProcessor, int luck, String[] customDrops) {
        super(SetupCommon.ENTITY_LUCKY_POTION, thrower, world);
        this.init(itemLuckyPotion, impactDropProcessor, luck, customDrops);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM_STACK, (Object)ItemStack.field_190927_a);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM_STACK);
    }

    private void setItemStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM_STACK, (Object)stack);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    private void luckyImpact(@Nullable Entity hitEntity) {
        try {
            if (this.impactDropProcessor != null && this.impactDropProcessor.getDrops().size() > 0) {
                Vec3d impactPos = hitEntity == null ? this.func_174791_d() : hitEntity.func_174791_d();
                DropProcessData dropData = new DropProcessData((IWorld)this.func_130014_f_(), (Entity)this.func_85052_h(), impactPos);
                if (hitEntity != null) {
                    dropData.setHitEntity(hitEntity);
                }
                if (this.customDrops != null && this.customDrops.length != 0) {
                    this.impactDropProcessor.processRandomDrop(LuckyUtils.dropsFromStrArray(this.customDrops), dropData, this.luck);
                } else {
                    this.impactDropProcessor.processRandomDrop(dropData, this.luck);
                }
            }
        }
        catch (Exception e) {
            Lucky.error(e, DropProcessor.errorMessage());
        }
    }

    protected void func_70184_a(RayTraceResult rayTraceResult) {
        if (!this.field_70170_p.field_72995_K) {
            this.luckyImpact(rayTraceResult.field_72308_g);
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        NBTTagList drops = new NBTTagList();
        for (int i = 0; i < this.impactDropProcessor.getDrops().size(); ++i) {
            String dropString = this.impactDropProcessor.getDrops().get(i).toString();
            drops.add((INBTBase)new NBTTagString(dropString));
        }
        tagCompound.func_74782_a("impact", (INBTBase)drops);
        tagCompound.func_74782_a("itemLuckyPotion", (INBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagList drops = tag.func_150295_c("impact", (int)new NBTTagString().func_74732_a());
        for (int i = 0; i < drops.size(); ++i) {
            DropFull drop = new DropFull();
            drop.readFromString(drops.func_150307_f(i));
            this.impactDropProcessor.registerDrop(drop);
        }
        if (tag.func_74764_b("itemLuckyPotion")) {
            this.setItemStack(ItemStack.func_199557_a((NBTTagCompound)tag.func_74775_l("itemLuckyPotion")));
        }
    }
}

