/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.init.SetupCommon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityLuckyProjectile
extends EntityArrow {
    private static final DataParameter<ItemStack> ITEM_STACK = EntityDataManager.func_187226_a(EntityLuckyProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private EntityItem entityItem;
    private boolean hasTrail = false;
    private float trailFrequency = 1.0f;
    private boolean hasImpact = false;
    private DropProcessor dropProcessorTrail;
    private DropProcessor dropProcessorImpact;

    public EntityLuckyProjectile(World world) {
        super(SetupCommon.ENTITY_LUCKY_PROJECTILE, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM_STACK, (Object)ItemStack.field_190927_a);
        this.dropProcessorTrail = new DropProcessor();
        this.dropProcessorImpact = new DropProcessor();
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM_STACK);
    }

    private void setItemStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM_STACK, (Object)stack);
    }

    @Nullable
    private Entity getShooter() {
        return this.field_70250_c != null && this.field_70170_p instanceof WorldServer ? ((WorldServer)this.field_70170_p).func_175733_a(this.field_70250_c) : null;
    }

    private void luckyTick() {
        try {
            if (this.entityItem == null && this.func_130014_f_().field_72995_K) {
                this.entityItem = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, (ItemStack)this.field_70180_af.func_187225_a(ITEM_STACK));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entityItem != null) {
            this.entityItem.func_70071_h_();
        }
        if (!this.func_130014_f_().field_72995_K && this.hasTrail && this.field_70173_aa >= 2) {
            try {
                if ((double)this.trailFrequency < 1.0 && this.trailFrequency > 0.0f) {
                    int amount = (int)(1.0 / (double)this.trailFrequency);
                    for (int i = 0; i < amount; ++i) {
                        this.dropProcessorTrail.processRandomDrop(new DropProcessData((IWorld)this.func_130014_f_(), this.getShooter(), new Vec3d(this.field_70165_t + this.field_70159_w * (double)i / (double)amount, this.field_70163_u + this.field_70181_x * (double)i / (double)amount, this.field_70161_v + this.field_70179_y * (double)i / (double)amount)), 0, false);
                    }
                } else if ((this.field_70173_aa - 2) % (int)this.trailFrequency == 0) {
                    this.dropProcessorTrail.processRandomDrop(new DropProcessData((IWorld)this.func_130014_f_(), this.getShooter(), this.func_174791_d()), 0, false);
                }
            }
            catch (Exception e) {
                Lucky.error(e, DropProcessor.errorMessage());
            }
        }
    }

    private void luckyHit(@Nullable Entity hitEntity) {
        try {
            if (this.hasImpact) {
                DropProcessData dropData = new DropProcessData((IWorld)this.func_130014_f_(), this.getShooter(), hitEntity != null ? hitEntity.func_174791_d() : this.func_174791_d());
                if (hitEntity != null) {
                    dropData.setHitEntity(hitEntity);
                }
                this.dropProcessorImpact.processRandomDrop(dropData, 0);
            }
        }
        catch (Exception e) {
            Lucky.error(e, DropProcessor.errorMessage());
        }
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.luckyTick();
    }

    protected void func_184549_a(RayTraceResult rayTraceResult) {
        super.func_184549_a(rayTraceResult);
        this.luckyHit(rayTraceResult.field_72308_g);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.entityItem != null) {
            tag.func_74782_a("item", (INBTBase)this.entityItem.func_92059_d().func_77955_b(new NBTTagCompound()));
        }
        if (this.hasTrail) {
            NBTTagCompound trailTag = new NBTTagCompound();
            trailTag.func_74776_a("frequency", this.trailFrequency);
            NBTTagList drops = new NBTTagList();
            for (int i = 0; i < this.dropProcessorTrail.getDrops().size(); ++i) {
                String dropString = this.dropProcessorTrail.getDrops().get(i).toString();
                drops.add((INBTBase)new NBTTagString(dropString));
            }
            trailTag.func_74782_a("drops", (INBTBase)drops);
            tag.func_74782_a("trail", (INBTBase)trailTag);
        }
        if (this.hasImpact) {
            NBTTagList drops = new NBTTagList();
            for (int i = 0; i < this.dropProcessorImpact.getDrops().size(); ++i) {
                String dropString = this.dropProcessorImpact.getDrops().get(i).toString();
                drops.add((INBTBase)new NBTTagString(dropString));
            }
            tag.func_74782_a("impact", (INBTBase)drops);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        ItemStack stack = null;
        stack = tag.func_74764_b("item") ? ItemStack.func_199557_a((NBTTagCompound)tag.func_74775_l("item")) : new ItemStack((IItemProvider)Items.field_151055_y);
        stack.func_190920_e(1);
        this.entityItem = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.func_184212_Q().func_187227_b(ITEM_STACK, (Object)stack);
        if (tag.func_74764_b("trail")) {
            NBTTagCompound trailTag = tag.func_74775_l("trail");
            if (trailTag.func_74764_b("frequency")) {
                this.trailFrequency = trailTag.func_74760_g("frequency");
            }
            if (trailTag.func_74764_b("drops")) {
                NBTTagList drops = trailTag.func_150295_c("drops", (int)new NBTTagString().func_74732_a());
                for (int i = 0; i < drops.size(); ++i) {
                    DropFull drop = new DropFull();
                    drop.readFromString(drops.func_150307_f(i));
                    this.dropProcessorTrail.registerDrop(drop);
                }
            }
            this.hasTrail = true;
        }
        if (tag.func_74764_b("impact")) {
            NBTTagList drops = tag.func_150295_c("impact", (int)new NBTTagString().func_74732_a());
            for (int i = 0; i < drops.size(); ++i) {
                DropFull drop = new DropFull();
                drop.readFromString(drops.func_150307_f(i));
                this.dropProcessorImpact.registerDrop(drop);
            }
            this.hasImpact = true;
        }
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public EntityItem getEntityItem() {
        return this.entityItem;
    }
}

