/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.init;

import java.util.Map;
import mod.lucky.Lucky;
import mod.lucky.entity.EntityLuckyPotion;
import mod.lucky.entity.EntityLuckyProjectile;
import mod.lucky.render.RenderLuckyPotion;
import mod.lucky.render.RenderLuckyProjectile;
import mod.lucky.resources.loader.PluginLoader;
import mod.lucky.resources.loader.ResourceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class SetupClient {
    public static void registerAddonResources() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            ResourceManager resourceLoader = new ResourceManager(mc.field_71412_D);
            ResourcePackList packList = null;
            packList = mc.func_71401_C() != null ? mc.func_71401_C().func_195561_aH() : mc.func_195548_H();
            for (final PluginLoader pluginLoader : resourceLoader.getPluginLoaders()) {
                final IResourcePack pack = pluginLoader.getResourcePack();
                final String name = "mod:lucky:" + pluginLoader.getPluginName();
                IPackFinder packFinder = new IPackFinder(){

                    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> nameToPackMap, ResourcePackInfo.IFactory<T> packInfoFactory) {
                        ResourcePackInfo packInfo = packInfoFactory.create(name, true, () -> pack, pack, new PackMetadataSection((ITextComponent)new TextComponentString(pluginLoader.getPluginName()), 4), ResourcePackInfo.Priority.BOTTOM);
                        ObfuscationReflectionHelper.setPrivateValue(ResourcePackInfo.class, (Object)packInfo, (Object)true, (String)"hidden");
                        try {
                            nameToPackMap.put(name, packInfo);
                        }
                        catch (Exception e) {
                            Lucky.error(e, "Error loading resource pack for add-on: " + pluginLoader.getPluginName());
                        }
                    }
                };
                packList.func_198982_a(packFinder);
            }
            packList.func_198983_a();
        }
        catch (Exception e) {
            Lucky.error(e, "Error registering add-on resources");
        }
    }

    private static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityLuckyProjectile.class, RenderLuckyProjectile::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLuckyPotion.class, RenderLuckyPotion::new);
    }

    public static void setup() {
        SetupClient.registerEntityRenderers();
        SetupClient.registerAddonResources();
    }
}

