/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ILuckyItemContainer;
import mod.lucky.item.LuckyItem;
import mod.lucky.util.LuckyUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemLuckyBow
extends ItemBow
implements ILuckyItemContainer {
    private LuckyItem luckyItem = new LuckyItem((Item)this);

    public ItemLuckyBow() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1000).func_200916_a(ItemGroup.field_78037_j));
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() instanceof ItemLuckyBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public LuckyItem getLuckyItem() {
        return this.luckyItem;
    }

    private ItemStack getInventoryArrows(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean unlimitedArrows = player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack arrowStack = this.getInventoryArrows(player);
            int initPower = this.func_77626_a(stack) - timeLeft;
            if ((initPower = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)initPower, (arrowStack != null || unlimitedArrows ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (unlimitedArrows || arrowStack != null) {
                float power = ItemLuckyBow.func_185059_b((int)initPower);
                if (!((double)power >= 0.1)) {
                    return;
                }
                if (!world.field_72995_K) {
                    try {
                        int luck = LuckyItem.getLuck(stack);
                        String[] drops = LuckyItem.getRawDrops(stack);
                        EntityTippedArrow entityArrow = new EntityTippedArrow(world, (EntityLivingBase)player);
                        DropProcessData dropData = new DropProcessData((IWorld)world, (Entity)player, entityArrow.func_174791_d()).setBowPower(power * 3.0f);
                        if (drops != null && drops.length != 0) {
                            this.getLuckyItem().getDropProcessor().processRandomDrop(LuckyUtils.dropsFromStrArray(drops), dropData, luck);
                        } else {
                            this.getLuckyItem().getDropProcessor().processRandomDrop(dropData, luck);
                        }
                    }
                    catch (Exception e) {
                        Lucky.error(e, DropProcessor.errorMessage());
                    }
                }
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                if (!unlimitedArrows) {
                    arrowStack.func_190920_e(arrowStack.func_190916_E() - 1);
                    if (arrowStack.func_190916_E() == 0) {
                        player.field_71071_by.func_184437_d(arrowStack);
                    }
                }
            }
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.luckyItem.addLuckyTooltip(stack, worldIn, tooltip, flagIn);
    }
}

