/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.util.LuckyUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LuckyItem {
    private Item containerItem;
    private DropProcessor dropProcessor;

    public LuckyItem(Item containerItem) {
        this.containerItem = containerItem;
        this.dropProcessor = new DropProcessor();
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    public boolean hasLuckVariantsInGroup() {
        return false;
    }

    public TextComponentBase getVeryLuckyName() {
        return null;
    }

    public TextComponentBase getUnluckyName() {
        return null;
    }

    private boolean isOriginalItem() {
        return this.containerItem == Lucky.luckyBlock.func_199767_j() || this.containerItem == Lucky.luckySword || this.containerItem == Lucky.luckyBow || this.containerItem == Lucky.luckyPotion;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addLuckyTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int luck = LuckyItem.getLuck(stack);
        ITextComponent luckComponent = luck == 0 ? new TextComponentString("" + luck).func_211708_a(TextFormatting.GOLD) : (luck < 0 ? new TextComponentString("" + luck).func_211708_a(TextFormatting.RED) : new TextComponentString("+" + luck).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TextComponentTranslation("item.lucky.lucky_block.luck", new Object[0]).func_150258_a(": ").func_150257_a(luckComponent));
        String[] drops = LuckyItem.getRawDrops(stack);
        if (drops != null && drops.length != 0) {
            tooltip.add(new TextComponentTranslation("item.lucky.lucky_block.customDrop", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }

    public void addLuckySubItems(NonNullList<ItemStack> items) {
        ItemStack normalItemStack = new ItemStack((IItemProvider)this.getContainerItem(), 1);
        items.add((Object)normalItemStack);
        if (this.hasLuckVariantsInGroup() && this.isOriginalItem()) {
            NBTTagCompound luckyTag = new NBTTagCompound();
            luckyTag.func_74768_a("Luck", 80);
            NBTTagCompound unluckyTag = new NBTTagCompound();
            unluckyTag.func_74768_a("Luck", -80);
            ItemStack luckyItemStack = new ItemStack((IItemProvider)this.getContainerItem(), 1);
            luckyItemStack.func_77982_d(luckyTag);
            luckyItemStack.func_200302_a((ITextComponent)this.getVeryLuckyName());
            items.add((Object)luckyItemStack);
            ItemStack unluckyItemStack = new ItemStack((IItemProvider)this.getContainerItem(), 1);
            unluckyItemStack.func_77982_d(unluckyTag);
            unluckyItemStack.func_200302_a((ITextComponent)this.getUnluckyName());
            items.add((Object)unluckyItemStack);
        }
    }

    public static int getLuck(ItemStack stack) {
        try {
            return stack.func_77978_p().func_74762_e("Luck");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Nullable
    public static String[] getRawDrops(ItemStack stack) {
        try {
            return LuckyUtils.strArrayFromTagList((NBTTagList)stack.func_77978_p().func_74781_a("Drops"));
        }
        catch (Exception e) {
            return null;
        }
    }
}

