/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import java.io.DataInputStream;
import java.util.zip.GZIPInputStream;
import mod.lucky.Lucky;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.structure.BlockPlacer;
import mod.lucky.structure.Structure;
import mod.lucky.structure.StructureUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.feature.template.ITemplateProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class TemplateStructure
extends Structure {
    private Template template;

    private ITemplateProcessor createProcessor() {
        final Structure.BlockMode blockMode = this.blockMode;
        return new ITemplateProcessor(){

            public Template.BlockInfo func_189943_a(IBlockReader worldIn, BlockPos pos, Template.BlockInfo blockInfo) {
                IBlockState blockState = StructureUtils.applyBlockMode(blockMode, blockInfo.field_186243_b);
                if (blockState == null) {
                    blockState = worldIn.func_180495_p(pos);
                }
                return new Template.BlockInfo(blockInfo.field_186242_a, blockState, blockInfo.field_186244_c);
            }
        };
    }

    @Override
    public void process(DropProcessData processData) {
        DropSingle drop = processData.getDropSingle();
        BlockPlacer blockPlacer = new BlockPlacer(processData.getRawWorld());
        Rotation rotation = StructureUtils.parseRotation(drop.getPropertyInt("rotation"));
        PlacementSettings placementSettings = new PlacementSettings().func_186220_a(rotation).func_207665_a(new BlockPos(this.centerPos)).func_186222_a(false).func_186218_a(null).func_186225_a(null).func_186226_b(true);
        BlockPos adjustedPos = drop.getBlockPos().func_177973_b((Vec3i)new BlockPos(this.centerPos));
        ITemplateProcessor processor = this.createProcessor();
        this.template.func_186258_a(adjustedPos, placementSettings);
        this.template.func_189960_a(processData.getRawWorld(), adjustedPos, processor, placementSettings, 2);
        if (this.blockUpdate) {
            blockPlacer.update();
        }
        this.processOverlay(processData);
    }

    @Override
    public void readFromFile() {
        NBTTagCompound tag = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(this.openFileStream()));
            tag = CompressedStreamTools.func_74794_a((DataInputStream)dataInputStream);
            dataInputStream.close();
        }
        catch (Exception e) {
            Lucky.error(e, "Error loading structure '" + this.fileName + "'");
        }
        this.template = new Template();
        if (tag != null) {
            this.template.func_186256_b(tag);
        }
        this.size = this.template.func_186259_a();
        this.initCenterPos();
    }
}

