/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.List;
import mod.lucky.Lucky;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropFunc;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.ValueParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.registries.ForgeRegistries;

public class DropFuncEffect
extends DropFunc {
    @Override
    public void process(DropProcessData processData) {
        List list1;
        DropSingle drop = processData.getDropSingle();
        Entity target = null;
        AxisAlignedBB effectBox = new AxisAlignedBB(drop.getBlockPos(), drop.getBlockPos()).func_72321_a((double)(drop.getPropertyInt("range") * 2), (double)(drop.getPropertyInt("range") * 2), (double)(drop.getPropertyInt("range") * 2));
        if (drop.hasProperty("target") && !drop.hasProperty("range")) {
            Object object = drop.getPropertyString("target").equals("player") ? processData.getPlayer() : (target = drop.getPropertyString("target").equals("hitEntity") ? processData.getHitEntity() : null);
        }
        if (!drop.hasProperty("target") && !drop.hasProperty("range")) {
            target = processData.getPlayer();
        }
        if (drop.getPropertyString("target").equals("hitEntity") && processData.getHitEntity() == null) {
            return;
        }
        int potionEffectId = -1;
        String effectID = drop.getPropertyString("ID");
        if (!effectID.equals("special_fire") && !effectID.equals("special_knockback")) {
            try {
                potionEffectId = ValueParser.getInteger(effectID);
            }
            catch (Exception e) {
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectID));
                if (potion == null) {
                    Lucky.error(null, "Invalid potion effect: " + effectID);
                    return;
                }
                potionEffectId = Effect.func_188409_a((Effect)potion);
            }
        }
        if (target != null) {
            if (effectID.equals("special_fire")) {
                this.specialEffectFire(processData, target);
            } else if (effectID.equals("special_knockback")) {
                this.specialEffectKnockback(processData, target);
            } else {
                this.potionEffect(processData, target, potionEffectId);
            }
        } else if (effectBox != null && !(list1 = processData.getWorld().func_217357_a(LivingEntity.class, effectBox)).isEmpty()) {
            for (LivingEntity entity : list1) {
                double distance;
                if (processData.getDropSingle().getPropertyBoolean("excludePlayer").booleanValue() && entity == processData.getPlayer() || !((distance = processData.getDropSingle().getVecPos().func_72438_d(entity.func_174791_d())) <= (double)drop.getPropertyFloat("range").floatValue())) continue;
                if (effectID.equals("special_fire")) {
                    this.specialEffectFire(processData, (Entity)entity);
                    continue;
                }
                if (effectID.equals("special_knockback")) {
                    this.specialEffectKnockback(processData, (Entity)entity);
                    continue;
                }
                this.potionEffect(processData, (Entity)entity, potionEffectId);
            }
        }
    }

    private void potionEffect(DropProcessData processData, Entity entity, int potionEffectId) {
        Effect potion = Effect.func_188412_a((int)potionEffectId);
        int duration = (int)((double)processData.getDropSingle().getPropertyFloat("duration").floatValue() * 20.0);
        if (potion.func_76403_b()) {
            duration = 1;
        }
        EffectInstance potionEffect = new EffectInstance(potion, duration, processData.getDropSingle().getPropertyInt("amplifier").intValue());
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(potionEffect);
        }
    }

    private void specialEffectFire(DropProcessData processData, Entity entity) {
        entity.func_70015_d(processData.getDropSingle().getPropertyInt("duration").intValue());
    }

    private void specialEffectKnockback(DropProcessData processData, Entity entity) {
        Vec3d dropPos = processData.getDropSingle().getVecPos();
        float yawAngle = processData.getDropSingle().hasProperty("directionYaw") ? processData.getDropSingle().getPropertyFloat("directionYaw").floatValue() : (float)Math.toDegrees(Math.atan2((entity.field_70165_t - dropPos.field_72450_a) * -1.0, entity.field_70161_v - dropPos.field_72449_c));
        float pitchAngle = processData.getDropSingle().getPropertyFloat("directionPitch").floatValue();
        float power = processData.getDropSingle().getPropertyFloat("power").floatValue();
        if (!processData.getDropSingle().hasProperty("target") && dropPos.func_72438_d(entity.func_174791_d()) < 0.01) {
            pitchAngle = -90.0f;
            power = (float)((double)power * 0.5);
        }
        entity.func_213317_d(new Vec3d((double)(-MathHelper.func_76126_a((float)(yawAngle / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitchAngle / 180.0f * (float)Math.PI)) * power), (double)(-MathHelper.func_76126_a((float)(pitchAngle / 180.0f * (float)Math.PI)) * power), (double)(MathHelper.func_76134_b((float)(yawAngle / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitchAngle / 180.0f * (float)Math.PI)) * power)));
        entity.field_70133_I = true;
    }

    @Override
    public void registerProperties() {
        DropSingle.setDefaultProperty(this.getType(), "duration", Integer.class, 30);
        DropSingle.setDefaultProperty(this.getType(), "amplifier", Integer.class, 0);
        DropSingle.setDefaultProperty(this.getType(), "target", String.class, "player");
        DropSingle.setDefaultProperty(this.getType(), "excludePlayer", Boolean.class, false);
        DropSingle.setDefaultProperty(this.getType(), "range", Float.class, 4);
        DropSingle.setDefaultProperty(this.getType(), "power", Float.class, 1);
        DropSingle.setDefaultProperty(this.getType(), "directionYaw", Float.class, 0);
        DropSingle.setDefaultProperty(this.getType(), "directionPitch", Float.class, -30);
    }

    @Override
    public String getType() {
        return "effect";
    }
}

