/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.init.SetupCommon;
import mod.lucky.item.ItemLuckyPotion;
import mod.lucky.util.LuckyUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityLuckyPotion
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> ITEM_STACK = EntityDataManager.func_187226_a(EntityLuckyPotion.class, (IDataSerializer)DataSerializers.field_187196_f);
    private DropProcessor impactDropProcessor;
    private int luck = 0;
    private String[] customDrops = null;

    public void init(ItemLuckyPotion itemLuckyPotion, DropProcessor impactDropProcessor, int luck, String[] customDrops) {
        this.setItemStack(new ItemStack((IItemProvider)itemLuckyPotion, 1));
        this.impactDropProcessor = impactDropProcessor;
        this.luck = luck;
        this.customDrops = customDrops;
    }

    public EntityLuckyPotion(EntityType<? extends EntityLuckyPotion> entityType, World world) {
        super(entityType, world);
        this.init(Lucky.luckyPotion, new DropProcessor(), 0, null);
    }

    public EntityLuckyPotion(World world) {
        this(SetupCommon.ENTITY_LUCKY_POTION, world);
    }

    public EntityLuckyPotion(World world, LivingEntity thrower, ItemLuckyPotion itemLuckyPotion, DropProcessor impactDropProcessor, int luck, String[] customDrops) {
        super(SetupCommon.ENTITY_LUCKY_POTION, thrower, world);
        this.init(itemLuckyPotion, impactDropProcessor, luck, customDrops);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM_STACK, (Object)ItemStack.field_190927_a);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM_STACK);
    }

    private void setItemStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM_STACK, (Object)stack);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    private void luckyImpact(@Nullable Entity hitEntity) {
        try {
            if (this.impactDropProcessor != null && this.impactDropProcessor.getDrops().size() > 0) {
                Vec3d impactPos = hitEntity == null ? this.func_174791_d() : hitEntity.func_174791_d();
                DropProcessData dropData = new DropProcessData((IWorld)this.func_130014_f_(), (Entity)this.func_85052_h(), impactPos);
                if (hitEntity != null) {
                    dropData.setHitEntity(hitEntity);
                }
                if (this.customDrops != null && this.customDrops.length != 0) {
                    this.impactDropProcessor.processRandomDrop(LuckyUtils.dropsFromStrArray(this.customDrops), dropData, this.luck);
                } else {
                    this.impactDropProcessor.processRandomDrop(dropData, this.luck);
                }
            }
        }
        catch (Exception e) {
            Lucky.error(e, DropProcessor.errorMessage());
        }
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        if (!this.field_70170_p.field_72995_K) {
            Entity hitEntity = rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)rayTrace).func_216348_a() : null;
            this.luckyImpact(hitEntity);
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        super.func_213281_b(tagCompound);
        ListNBT drops = new ListNBT();
        for (int i = 0; i < this.impactDropProcessor.getDrops().size(); ++i) {
            String dropString = this.impactDropProcessor.getDrops().get(i).toString();
            drops.add((Object)new StringNBT(dropString));
        }
        tagCompound.func_218657_a("impact", (INBT)drops);
        tagCompound.func_218657_a("itemLuckyPotion", (INBT)this.getItemStack().func_77955_b(new CompoundNBT()));
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        ListNBT drops = tag.func_150295_c("impact", (int)new StringNBT().func_74732_a());
        for (int i = 0; i < drops.size(); ++i) {
            DropFull drop = new DropFull();
            drop.readFromString(drops.func_150307_f(i));
            this.impactDropProcessor.registerDrop(drop);
        }
        if (tag.func_74764_b("itemLuckyPotion")) {
            this.setItemStack(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("itemLuckyPotion")));
        }
    }

    public ItemStack func_184543_l() {
        return this.getItemStack();
    }
}

