/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import java.io.InputStream;
import java.util.HashMap;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropFunc;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.resources.ResourceStructureFile;
import mod.lucky.resources.loader.BaseLoader;
import mod.lucky.structure.LegacySchematicStructure;
import mod.lucky.structure.LuckyStructure;
import mod.lucky.structure.TemplateStructure;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class Structure {
    protected BlockPos size;
    protected String fileName;
    private BaseLoader loader;
    protected String overlayStruct;
    public String id;
    protected BlockMode blockMode;
    protected boolean blockUpdate = true;
    protected boolean[] explicitCenter = new boolean[]{false, false, false};
    public Vec3d centerPos = new Vec3d(0.0, 0.0, 0.0);

    public Structure() {
        this.blockMode = BlockMode.REPLACE;
    }

    public void readProperties(String properties, BaseLoader loader) {
        String[] splitProperties;
        this.loader = loader;
        double centerX = 0.0;
        double centerY = 0.0;
        double centerZ = 0.0;
        for (String property : splitProperties = properties.split(",")) {
            String[] splitProperty = property.split("=");
            String propertyName = splitProperty[0];
            String propertyValue = splitProperty[1];
            if (propertyName.equalsIgnoreCase("ID")) {
                this.id = ValueParser.getString(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("overlayStruct")) {
                this.overlayStruct = ValueParser.getString(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("file")) {
                this.fileName = ValueParser.getString(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("centerX")) {
                this.explicitCenter[0] = true;
                centerX = ValueParser.getFloat(propertyValue).floatValue();
                if (!DropStringUtils.isGenericFloat(propertyValue)) {
                    centerX += 0.5;
                }
            }
            if (propertyName.equalsIgnoreCase("centerY")) {
                this.explicitCenter[1] = true;
                centerY = ValueParser.getFloat(propertyValue).floatValue();
            }
            if (propertyName.equalsIgnoreCase("centerZ")) {
                this.explicitCenter[2] = true;
                centerZ = ValueParser.getFloat(propertyValue).floatValue();
                if (!DropStringUtils.isGenericFloat(propertyValue)) {
                    centerZ += 0.5;
                }
            }
            if (propertyName.equalsIgnoreCase("blockMode")) {
                this.blockMode = BlockMode.fromString(ValueParser.getString(propertyValue));
            }
            if (!propertyName.equalsIgnoreCase("blockUpdate")) continue;
            this.blockUpdate = ValueParser.getBoolean(propertyValue);
        }
        this.centerPos = new Vec3d(centerX, centerY, centerZ);
    }

    public Structure newTypeInstance() {
        if (this.fileName.endsWith(".luckystruct")) {
            return new LuckyStructure().copyProperties(this);
        }
        if (this.fileName.endsWith(".schematic")) {
            return new LegacySchematicStructure().copyProperties(this);
        }
        return new TemplateStructure().copyProperties(this);
    }

    public void readFromFile() {
    }

    public void process(DropProcessData processData) {
    }

    protected void processOverlay(DropProcessData processData) {
        if (this.overlayStruct != null) {
            DropSingle drop = processData.getDropSingle();
            String oldId = drop.getPropertyString("ID");
            String oldBlockMode = drop.getPropertyString("applyBlockMode");
            drop.setProperty("ID", this.overlayStruct);
            drop.setProperty("applyBlockMode", "overlay");
            DropFunc.getDropFunction(drop).process(processData);
            drop.setProperty("ID", oldId);
            drop.setProperty("applyBlockMode", oldBlockMode);
        }
    }

    protected void initCenterPos() {
        double centerX = !this.explicitCenter[0] ? (double)((int)((double)this.size.func_177958_n() / 2.0)) + 0.5 : this.centerPos.field_72450_a;
        double centerZ = !this.explicitCenter[2] ? (double)((int)((double)this.size.func_177952_p() / 2.0)) + 0.5 : this.centerPos.field_72449_c;
        double centerY = !this.explicitCenter[1] ? 0.0 : this.centerPos.field_72448_b;
        this.centerPos = new Vec3d(centerX, centerY, centerZ);
    }

    public InputStream openFileStream() {
        return this.loader.getResourceStream(new ResourceStructureFile(this.fileName));
    }

    public Structure copyProperties(Structure structure) {
        this.loader = structure.loader;
        this.fileName = structure.fileName;
        this.id = structure.id;
        this.overlayStruct = structure.overlayStruct;
        this.centerPos = structure.centerPos;
        this.explicitCenter = structure.explicitCenter;
        this.blockMode = structure.blockMode;
        this.blockUpdate = structure.blockUpdate;
        this.size = structure.size;
        return this;
    }

    public static enum BlockMode {
        REPLACE("replace"),
        OVERLAY("overlay"),
        AIR("air");

        private String name;
        private static HashMap<String, BlockMode> lookup;

        private BlockMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static BlockMode fromString(String s) {
            return lookup.get(s);
        }

        static {
            lookup = new HashMap();
            for (BlockMode mode : BlockMode.values()) {
                lookup.put(mode.toString(), mode);
            }
        }
    }
}

