/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.block;

import java.util.ArrayList;
import mod.lucky.Lucky;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.LuckyItem;
import mod.lucky.tileentity.TileEntityLuckyBlock;
import mod.lucky.util.LuckyUtils;
import mod.lucky.world.LuckyWorldFeature;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class BlockLuckyBlock
extends ContainerBlock {
    private DropProcessor dropProcessor = new DropProcessor();
    private LuckyWorldFeature worldGenerator;
    private boolean doCreativeDrops = false;

    public BlockLuckyBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151673_t).func_200947_a(SoundType.field_185851_d).func_200948_a(0.2f, 6000000.0f));
    }

    public boolean removeLuckyBlock(World world, PlayerEntity player, BlockPos harvestPos, boolean removedByRedstone) {
        try {
            int luck = 0;
            String[] customDropsRaw = null;
            ArrayList<DropFull> customDrops = null;
            TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_175625_s(harvestPos);
            if (tileEntityLuck != null) {
                luck = tileEntityLuck.getLuck();
                customDropsRaw = tileEntityLuck.getDrops();
                if (customDropsRaw != null && customDropsRaw.length != 0) {
                    customDrops = new ArrayList<DropFull>();
                    for (String rawDrop : customDropsRaw) {
                        DropFull dropFull = new DropFull();
                        dropFull.readFromString(rawDrop);
                        customDrops.add(dropFull);
                    }
                }
                world.func_175713_t(harvestPos);
            }
            world.func_217377_a(harvestPos, false);
            if (!world.field_72995_K) {
                if (removedByRedstone) {
                    player = LuckyUtils.getNearestPlayer((ServerWorld)world, LuckyUtils.toVector3d(harvestPos));
                }
                if (player.func_184812_l_() && !this.doCreativeDrops && !removedByRedstone) {
                    return true;
                }
                if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185306_r, (LivingEntity)player) > 0 && !removedByRedstone) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    CompoundNBT tag = new CompoundNBT();
                    if (luck != 0) {
                        tag.func_74768_a("Luck", luck);
                    }
                    if (customDrops != null) {
                        tag.func_218657_a("Drops", (INBT)LuckyUtils.tagListFromStrArray(customDropsRaw));
                    }
                    if (tag.func_74764_b("Luck") || customDrops != null) {
                        stack.func_77982_d(tag);
                    }
                    Block.func_180635_a((World)world, (BlockPos)harvestPos, (ItemStack)stack);
                    return true;
                }
                DropProcessData dropData = new DropProcessData((IWorld)world, (Entity)player, harvestPos);
                if (customDrops != null) {
                    this.getDropProcessor().processRandomDrop(customDrops, dropData, luck);
                } else {
                    this.getDropProcessor().processRandomDrop(dropData, luck);
                }
                return true;
            }
        }
        catch (Exception e) {
            Lucky.error(e, DropProcessor.errorMessage());
        }
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!world.field_72995_K && world.func_175640_z(pos)) {
            this.removeLuckyBlock(world, null, pos, true);
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos harvestPos, BlockState state, TileEntity tileEntity, ItemStack stack) {
        this.removeLuckyBlock(world, player, harvestPos, false);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluidState) {
        super.removedByPlayer(state, world, pos, player, willHarvest, fluidState);
        if (player.func_184812_l_() && this.doCreativeDrops) {
            this.removeLuckyBlock(world, player, pos, false);
        }
        return true;
    }

    private boolean canPlaceOnBlock(BlockState soil) {
        return soil.func_200132_m();
    }

    public boolean canPlaceAt(IWorld world, BlockPos pos) {
        BlockState curState = world.func_180495_p(pos);
        BlockState soilState = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        return curState.func_185904_a().func_76222_j() && !curState.func_185904_a().func_76224_d() && this.canPlaceOnBlock(soilState);
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityLuckyBlock();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity player, ItemStack itemStack) {
        TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_175625_s(pos);
        if (tileEntityLuck == null) {
            return;
        }
        int luck = LuckyItem.getLuck(itemStack);
        String[] drops = LuckyItem.getRawDrops(itemStack);
        tileEntityLuck.setLuck(luck);
        if (drops != null && drops.length != 0) {
            tileEntityLuck.setDrops(drops);
        }
        tileEntityLuck.func_70296_d();
        if (world.func_175640_z(pos) && !world.field_72995_K) {
            this.removeLuckyBlock(world, null, pos, true);
        }
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    public void setDoCreativeDrops(boolean doDrops) {
        this.doCreativeDrops = doDrops;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

