/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropFunc;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.entity.EntityLuckyPotion;
import mod.lucky.entity.EntityLuckyProjectile;
import mod.lucky.network.PacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DropFuncEntity
extends DropFunc {
    @Override
    public void process(DropProcessData processData) {
        DropSingle drop = processData.getDropSingle();
        float posX = drop.getPropertyFloat("posX").floatValue();
        float posY = drop.getPropertyFloat("posY").floatValue();
        float posZ = drop.getPropertyFloat("posZ").floatValue();
        if (posY <= -1.0f) {
            return;
        }
        CompoundNBT nbtTagCompound = drop.getPropertyNBT("NBTTag") == null ? new CompoundNBT() : drop.getPropertyNBT("NBTTag");
        String id = drop.getPropertyString("ID");
        if (!processData.getWorld().func_201670_d()) {
            if (id.equals("lightning_bolt") || id.equals("LightningBolt")) {
                LightningBoltEntity lightningBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(processData.getWorld());
                lightningBolt.func_225653_b_((double)posX, (double)posY, (double)posZ);
                processData.getWorld().func_217376_c((Entity)lightningBolt);
            } else {
                nbtTagCompound.func_74778_a("id", id);
                DropFuncEntity.spawnEntity(processData, nbtTagCompound, (ServerWorld)processData.getWorld(), posX, posY, posZ);
            }
        }
    }

    private static Entity spawnEntity(DropProcessData processData, CompoundNBT tag, ServerWorld world, double posX, double posY, double posZ) {
        Vector3d entityPos;
        Entity entity;
        for (int y = 0; y < 10; ++y) {
            if (!processData.getWorld().func_175623_d(new BlockPos(posX, posY + (double)y, posZ))) continue;
            posY += (double)y;
            break;
        }
        if (tag.func_74764_b("Pos")) {
            ListNBT posList = tag.func_150295_c("Pos", 6);
            posX = posList.func_150309_d(0);
            posY = posList.func_150309_d(1);
            posZ = posList.func_150309_d(2);
        }
        if ((entity = EntityType.func_220335_a((CompoundNBT)tag, (World)world, arg_0 -> DropFuncEntity.lambda$spawnEntity$0(entityPos = new Vector3d(posX, posY, posZ), world, arg_0))) == null) {
            return null;
        }
        if (entity instanceof FallingBlockEntity && !tag.func_74764_b("Time")) {
            ((FallingBlockEntity)entity).field_145812_b = 1;
        } else if (entity instanceof EntityLuckyProjectile) {
            ((EntityLuckyProjectile)entity).func_212361_a(processData.getPlayer());
        } else if (entity instanceof ArrowEntity) {
            ((ArrowEntity)entity).func_212361_a(processData.getPlayer());
        }
        if (entity instanceof MobEntity && processData.getProcessType() != DropProcessData.EnumProcessType.LUCKY_STRUCT && !tag.func_74764_b("Passengers")) {
            ((MobEntity)entity).func_213386_a((IServerWorld)world, world.func_175649_E(new BlockPos(entity.func_213303_ch())), SpawnReason.EVENT, null, null);
            ((MobEntity)entity).func_70037_a(tag);
        }
        if (entity instanceof EntityLuckyPotion || entity instanceof EntityLuckyProjectile) {
            PacketHandler.spawnEntity(entity);
        }
        return entity;
    }

    @Override
    public void registerProperties() {
        DropSingle.setDefaultProperty(this.getType(), "NBTTag", CompoundNBT.class, null);
        DropSingle.setDefaultProperty(this.getType(), "posX", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posY", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posZ", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posOffsetX", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posOffsetY", Float.class, Float.valueOf(0.0f));
        DropSingle.setDefaultProperty(this.getType(), "posOffsetZ", Float.class, Float.valueOf(0.0f));
    }

    @Override
    public String getType() {
        return "entity";
    }

    private static /* synthetic */ Entity lambda$spawnEntity$0(Vector3d entityPos, ServerWorld world, Entity e) {
        e.func_70012_b(entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c, e.field_70177_z, e.field_70125_A);
        return !world.func_217470_d(e) ? null : e;
    }
}

