/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.UUID;
import javax.annotation.Nullable;
import mod.lucky.drop.DropSingle;
import mod.lucky.util.LuckyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DropProcessData {
    private IWorld world;
    private Entity player;
    private Entity hitEntity;
    private float bowPower = 1.0f;
    private UUID playerUUID;
    private UUID hitEntityUUID;
    private Vector3d harvestPos;
    private DropSingle dropSingle;
    private EnumProcessType processType;

    public DropProcessData(IWorld world) {
        this.world = world;
    }

    public DropProcessData(IWorld world, Entity player, Vector3d harvestPos) {
        this(world, player, harvestPos, null);
    }

    public DropProcessData(IWorld world, Entity player, BlockPos harvestPos) {
        this(world, player, new Vector3d((double)harvestPos.func_177958_n() + 0.5, (double)harvestPos.func_177956_o(), (double)harvestPos.func_177952_p() + 0.5), null);
    }

    public DropProcessData(IWorld world, Entity player, Vector3d harvestPos, DropSingle dropSingle) {
        this(world, player, harvestPos, dropSingle, EnumProcessType.NORMAL);
    }

    public DropProcessData(IWorld world, Entity player, Vector3d harvestPos, DropSingle dropSingle, EnumProcessType processType) {
        this(world, player, harvestPos, dropSingle, processType, null);
    }

    public DropProcessData(IWorld world, Entity player, Vector3d harvestPos, DropSingle dropSingle, EnumProcessType processType, Entity hitEntity) {
        this.world = world;
        this.player = player;
        this.harvestPos = harvestPos;
        this.dropSingle = dropSingle;
        this.processType = processType;
        this.hitEntity = hitEntity;
    }

    @Nullable
    public World getWorld() {
        if (this.world instanceof World) {
            return (World)this.world;
        }
        return null;
    }

    public IWorld getRawWorld() {
        return this.world;
    }

    public Entity getPlayer() {
        if (this.player == null && this.world instanceof ServerWorld) {
            this.player = ((ServerWorld)this.world).func_217461_a(this.playerUUID);
        }
        if (this.player == null && this.world instanceof ServerWorld) {
            this.player = LuckyUtils.getNearestPlayer((ServerWorld)this.world, this.harvestPos);
        }
        return this.player;
    }

    public Entity getHitEntity() {
        if (this.hitEntity == null && this.world instanceof ServerWorld) {
            this.hitEntity = ((ServerWorld)this.world).func_217461_a(this.hitEntityUUID);
        }
        return this.hitEntity;
    }

    public float getBowPower() {
        return this.bowPower;
    }

    public DropProcessData setHitEntity(Entity hitEntity) {
        this.hitEntity = hitEntity;
        return this;
    }

    public DropProcessData setBowPower(float bowPower) {
        this.bowPower = bowPower;
        return this;
    }

    public Vector3d getHarvestPos() {
        return this.harvestPos;
    }

    public BlockPos getHarvestBlockPos() {
        return new BlockPos(this.harvestPos.field_72450_a, this.harvestPos.field_72448_b, this.harvestPos.field_72449_c);
    }

    public DropSingle getDropSingle() {
        return this.dropSingle;
    }

    public EnumProcessType getProcessType() {
        return this.processType;
    }

    public void setProcessType(EnumProcessType processType) {
        this.processType = processType;
    }

    public void setDrop(DropSingle properties) {
        this.dropSingle = properties;
    }

    public void setPlayer(Entity player) {
        this.player = player;
    }

    public void setHarvestPos(Vector3d harvestPos) {
        this.harvestPos = harvestPos;
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        this.dropSingle = new DropSingle();
        this.dropSingle.readFromNBT(tagCompound.func_74775_l("drop"));
        this.harvestPos = new Vector3d(tagCompound.func_74769_h("harvestPosX"), tagCompound.func_74769_h("harvestPosY"), tagCompound.func_74769_h("harvestPosZ"));
        this.bowPower = tagCompound.func_74760_g("bowPower");
        if (tagCompound.func_74764_b("playerUUID")) {
            this.playerUUID = UUID.fromString(tagCompound.func_74779_i("playerUUID"));
        }
        if (tagCompound.func_74764_b("hitEntityUUID")) {
            this.hitEntityUUID = UUID.fromString(tagCompound.func_74779_i("hitEntityUUID"));
        }
        ResourceLocation dimension = new ResourceLocation(tagCompound.func_74764_b("world") ? tagCompound.func_74779_i("world") : "overworld");
        this.world = Minecraft.func_71410_x().func_71401_C().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension));
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT mainTag = new CompoundNBT();
        mainTag.func_218657_a("drop", (INBT)this.dropSingle.writeToNBT());
        mainTag.func_74780_a("harvestPosX", this.harvestPos.field_72450_a);
        mainTag.func_74780_a("harvestPosY", this.harvestPos.field_72448_b);
        mainTag.func_74780_a("harvestPosZ", this.harvestPos.field_72449_c);
        mainTag.func_74776_a("bowPower", this.bowPower);
        if (this.player != null || this.playerUUID != null) {
            mainTag.func_74778_a("playerUUID", this.player == null ? this.playerUUID.toString() : this.player.func_110124_au().toString());
        }
        if (this.hitEntity != null || this.hitEntityUUID != null) {
            mainTag.func_74778_a("hitEntityUUID", this.hitEntity == null ? this.hitEntityUUID.toString() : this.hitEntity.func_110124_au().toString());
        }
        ResourceLocation dimension = ((World)this.world).func_234923_W_().func_240901_a_();
        mainTag.func_74778_a("world", dimension.toString());
        return mainTag;
    }

    public DropProcessData copy() {
        return new DropProcessData(this.world, this.player, this.harvestPos, this.dropSingle, this.processType, this.hitEntity).setBowPower(this.bowPower);
    }

    public static enum EnumProcessType {
        NORMAL,
        LUCKY_STRUCT;

    }
}

