/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.HashVariables;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.util.LuckyUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTHashVariables {
    public static String[] NBT_HASH_VARIABLES = new String[]{"#luckySwordEnchantments", "#luckyAxeEnchantments", "#luckyToolEnchantments", "#luckyHelmetEnchantments", "#luckyLeggingsEnchantments", "#luckyBootsEnchantments", "#luckyBowEnchantments", "#luckyFishingRodEnchantments", "#luckyTridentEnchantments", "#luckyCrossbowEnchantments", "#randEnchantment", "#luckyPotionEffects", "#unluckyPotionEffects", "#randFireworksRocket", "#randLaunchMotion", "#motionFromDirection", "#bowMotion", "#chestLootTable"};
    private static final CompoundNBT protection = NBTHashVariables.getEnchantment(Enchantments.field_180310_c, 4);
    private static final CompoundNBT fireProtection = NBTHashVariables.getEnchantment(Enchantments.field_77329_d, 4);
    private static final CompoundNBT featherFalling = NBTHashVariables.getEnchantment(Enchantments.field_180309_e, 4);
    private static final CompoundNBT blastProtection = NBTHashVariables.getEnchantment(Enchantments.field_185297_d, 4);
    private static final CompoundNBT projectileProtection = NBTHashVariables.getEnchantment(Enchantments.field_180308_g, 4);
    private static final CompoundNBT respiration = NBTHashVariables.getEnchantment(Enchantments.field_185298_f, 3);
    private static final CompoundNBT aquaAffinity = NBTHashVariables.getEnchantment(Enchantments.field_185299_g, 1);
    private static final CompoundNBT thorns = NBTHashVariables.getEnchantment(Enchantments.field_92091_k, 3);
    private static final CompoundNBT sharpness = NBTHashVariables.getEnchantment(Enchantments.field_185302_k, 5);
    private static final CompoundNBT smite = NBTHashVariables.getEnchantment(Enchantments.field_185303_l, 5);
    private static final CompoundNBT baneOfArthroponds = NBTHashVariables.getEnchantment(Enchantments.field_180312_n, 5);
    private static final CompoundNBT knockBack = NBTHashVariables.getEnchantment(Enchantments.field_180313_o, 2);
    private static final CompoundNBT fireAspect = NBTHashVariables.getEnchantment(Enchantments.field_77334_n, 2);
    private static final CompoundNBT looting = NBTHashVariables.getEnchantment(Enchantments.field_185304_p, 3);
    private static final CompoundNBT efficiency = NBTHashVariables.getEnchantment(Enchantments.field_185305_q, 5);
    private static final CompoundNBT silkTouch = NBTHashVariables.getEnchantment(Enchantments.field_185306_r, 1);
    private static final CompoundNBT unbreaking = NBTHashVariables.getEnchantment(Enchantments.field_185307_s, 3);
    private static final CompoundNBT fortune = NBTHashVariables.getEnchantment(Enchantments.field_185308_t, 3);
    private static final CompoundNBT power = NBTHashVariables.getEnchantment(Enchantments.field_185309_u, 5);
    private static final CompoundNBT punch = NBTHashVariables.getEnchantment(Enchantments.field_185310_v, 2);
    private static final CompoundNBT flame = NBTHashVariables.getEnchantment(Enchantments.field_185311_w, 1);
    private static final CompoundNBT infinity = NBTHashVariables.getEnchantment(Enchantments.field_185312_x, 1);
    private static final CompoundNBT luckOfTheSea = NBTHashVariables.getEnchantment(Enchantments.field_151370_z, 3);
    private static final CompoundNBT lure = NBTHashVariables.getEnchantment(Enchantments.field_151369_A, 3);
    private static final CompoundNBT loyalty = NBTHashVariables.getEnchantment(Enchantments.field_203193_C, 3);
    private static final CompoundNBT channeling = NBTHashVariables.getEnchantment(Enchantments.field_203196_F, 1);
    private static final CompoundNBT riptide = NBTHashVariables.getEnchantment(Enchantments.field_203195_E, 3);
    private static final CompoundNBT impaling = NBTHashVariables.getEnchantment(Enchantments.field_203194_D, 5);
    private static final CompoundNBT quickCharge = NBTHashVariables.getEnchantment(Enchantments.field_222193_H, 3);
    private static final CompoundNBT multishot = NBTHashVariables.getEnchantment(Enchantments.field_222192_G, 1);
    private static final CompoundNBT piercing = NBTHashVariables.getEnchantment(Enchantments.field_222194_I, 4);
    private static final CompoundNBT speed = NBTHashVariables.getEffectInstance(Effects.field_76424_c, 3, 9600);
    private static final CompoundNBT slowness = NBTHashVariables.getEffectInstance(Effects.field_76421_d, 3, 9600);
    private static final CompoundNBT haste = NBTHashVariables.getEffectInstance(Effects.field_76422_e, 3, 9600);
    private static final CompoundNBT miningFatigue = NBTHashVariables.getEffectInstance(Effects.field_76419_f, 3, 9600);
    private static final CompoundNBT strength = NBTHashVariables.getEffectInstance(Effects.field_76420_g, 3, 9600);
    private static final CompoundNBT instantHealth = NBTHashVariables.getEffectInstance(Effects.field_76432_h, 3, 0);
    private static final CompoundNBT instantDamage = NBTHashVariables.getEffectInstance(Effects.field_76433_i, 3, 0);
    private static final CompoundNBT jumpBoost = NBTHashVariables.getEffectInstance(Effects.field_76430_j, 3, 9600);
    private static final CompoundNBT nausea = NBTHashVariables.getEffectInstance(Effects.field_76431_k, 0, 9600);
    private static final CompoundNBT regeneration = NBTHashVariables.getEffectInstance(Effects.field_76428_l, 3, 9600);
    private static final CompoundNBT resistance = NBTHashVariables.getEffectInstance(Effects.field_76429_m, 3, 9600);
    private static final CompoundNBT fireResistance = NBTHashVariables.getEffectInstance(Effects.field_76426_n, 0, 9600);
    private static final CompoundNBT waterBreathing = NBTHashVariables.getEffectInstance(Effects.field_76427_o, 0, 9600);
    private static final CompoundNBT invisibility = NBTHashVariables.getEffectInstance(Effects.field_76441_p, 0, 9600);
    private static final CompoundNBT blindness = NBTHashVariables.getEffectInstance(Effects.field_76440_q, 0, 9600);
    private static final CompoundNBT nightVision = NBTHashVariables.getEffectInstance(Effects.field_76439_r, 0, 9600);
    private static final CompoundNBT hunger = NBTHashVariables.getEffectInstance(Effects.field_76438_s, 3, 9600);
    private static final CompoundNBT weakness = NBTHashVariables.getEffectInstance(Effects.field_76437_t, 3, 9600);
    private static final CompoundNBT poison = NBTHashVariables.getEffectInstance(Effects.field_76436_u, 3, 9600);
    private static final CompoundNBT wither = NBTHashVariables.getEffectInstance(Effects.field_82731_v, 3, 9600);
    private static final CompoundNBT healthBoost = NBTHashVariables.getEffectInstance(Effects.field_180152_w, 3, 9600);
    private static final CompoundNBT absorbtion = NBTHashVariables.getEffectInstance(Effects.field_76444_x, 3, 9600);
    private static final CompoundNBT saturation = NBTHashVariables.getEffectInstance(Effects.field_76443_y, 3, 9600);
    private static Random random = new Random();

    private static CompoundNBT getEnchantment(Enchantment enchantment, int maxLevel) {
        CompoundNBT nbttag = new CompoundNBT();
        nbttag.func_74778_a("id", ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)enchantment).toString());
        nbttag.func_74777_a("lvl", (short)maxLevel);
        return nbttag;
    }

    private static CompoundNBT getEffectInstance(Effect potion, int amplifier, int duration) {
        CompoundNBT nbttag = new CompoundNBT();
        EffectInstance effect = new EffectInstance(potion, duration, amplifier);
        return effect.func_82719_a(nbttag);
    }

    private static ArrayList<CompoundNBT> getRandomList(int minAmount, int maxAmount, CompoundNBT ... elements) {
        int amountToRemove = elements.length - (random.nextInt(maxAmount + 1 - minAmount) + minAmount);
        ArrayList<CompoundNBT> chosenElementList = new ArrayList<CompoundNBT>(elements.length);
        for (CompoundNBT element : elements) {
            chosenElementList.add(element.func_74737_b());
        }
        for (int a = 0; a < amountToRemove; ++a) {
            int index = random.nextInt(chosenElementList.size());
            chosenElementList.remove(index);
        }
        return chosenElementList;
    }

    private static ListNBT getRandomEnchantmentList(int minAmount, int maxAmount, CompoundNBT ... enchantments) {
        ArrayList<CompoundNBT> chosenEnchantments = NBTHashVariables.getRandomList(minAmount, maxAmount, enchantments);
        ListNBT nbttaglist = new ListNBT();
        for (CompoundNBT enchantment : chosenEnchantments) {
            enchantment.func_74777_a("lvl", (short)(random.nextInt(enchantment.func_74765_d("lvl")) + 1));
            nbttaglist.add((Object)enchantment);
        }
        return nbttaglist;
    }

    private static ListNBT getRandomEffectInstanceList(int minAmount, int maxAmount, CompoundNBT ... potionEffects) {
        ArrayList<CompoundNBT> chosenEffectInstances = NBTHashVariables.getRandomList(minAmount, maxAmount, potionEffects);
        ListNBT nbttaglist = new ListNBT();
        for (CompoundNBT potionEffect : chosenEffectInstances) {
            potionEffect.func_74774_a("Amplifier", (byte)random.nextInt(potionEffect.func_74771_c("Amplifier") + 1));
            int minDuration = (int)((float)potionEffect.func_74762_e("Duration") / 3.0f);
            potionEffect.func_74768_a("Duration", random.nextInt(potionEffect.func_74762_e("Duration") + 1 - minDuration) + minDuration);
            nbttaglist.add((Object)potionEffect);
        }
        return nbttaglist;
    }

    public static INBT getNBTTagFromString(String name, DropProcessData processData) {
        if (name.equals("#luckySwordEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, unbreaking);
        }
        if (name.equals("#luckyAxeEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyToolEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(2, 3, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyHelmetEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, respiration, aquaAffinity, unbreaking);
        }
        if (name.equals("#luckyChestplateEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyLeggingsEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBootsEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(4, 6, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBowEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(3, 5, unbreaking, power, punch, flame, infinity);
        }
        if (name.equals("#luckyFishingRodEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(2, 3, unbreaking, luckOfTheSea, lure);
        }
        if (name.equals("#luckyTridentEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(3, 5, loyalty, channeling, riptide, impaling, unbreaking);
        }
        if (name.equals("#luckyCrossbowEnchantments")) {
            return NBTHashVariables.getRandomEnchantmentList(2, 4, quickCharge, multishot, piercing, unbreaking);
        }
        if (name.equals("#randEnchantment")) {
            return NBTHashVariables.getRandomEnchantmentList(1, 1, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, efficiency, silkTouch, unbreaking, fortune, power, punch, flame, infinity, luckOfTheSea, lure, loyalty, channeling, riptide, impaling, quickCharge, multishot, piercing);
        }
        if (name.equals("#luckyPotionEffects")) {
            return NBTHashVariables.getRandomEffectInstanceList(7, 10, speed, haste, strength, instantHealth, jumpBoost, regeneration, resistance, fireResistance, waterBreathing, invisibility, nightVision, healthBoost, absorbtion, saturation);
        }
        if (name.equals("#unluckyPotionEffects")) {
            return NBTHashVariables.getRandomEffectInstanceList(5, 7, slowness, miningFatigue, instantDamage, nausea, blindness, hunger, weakness, poison, wither);
        }
        if (name.equals("#randFireworksRocket")) {
            return LuckyUtils.getRandomFireworksRocket();
        }
        if (name.startsWith("#randLaunchMotion")) {
            try {
                float launchPower = 0.9f;
                int launchAngle = 15;
                if (name.startsWith("#randLaunchMotion(")) {
                    String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                    String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                    splitValue[0] = DropStringUtils.removeNumSuffix(splitValue[0]);
                    launchPower = ValueParser.getFloat(splitValue[0], processData).floatValue();
                    launchAngle = ValueParser.getInteger(splitValue[1], processData);
                }
                float launchYaw = MathHelper.func_76142_g((float)(random.nextFloat() * 360.0f));
                float launchPitch = -90.0f + (float)(random.nextInt(launchAngle * 2) - launchAngle);
                float launchMotionX = -MathHelper.func_76126_a((float)(launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionZ = MathHelper.func_76134_b((float)(launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionY = -MathHelper.func_76126_a((float)(launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                ListNBT motionList = new ListNBT();
                motionList.add((Object)DoubleNBT.func_229684_a_((double)launchMotionX));
                motionList.add((Object)DoubleNBT.func_229684_a_((double)launchMotionY));
                motionList.add((Object)DoubleNBT.func_229684_a_((double)launchMotionZ));
                return motionList;
            }
            catch (Exception launchPower) {
                // empty catch block
            }
        }
        if (name.startsWith("#motionFromDirection(")) {
            try {
                String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                splitValue[2] = DropStringUtils.removeNumSuffix(splitValue[2]);
                int launchYaw = ValueParser.getInteger(splitValue[0], processData);
                int launchPitch = ValueParser.getInteger(splitValue[1], processData);
                float launchPower = ValueParser.getFloat(splitValue[2], processData).floatValue();
                float launchMotionX = -MathHelper.func_76126_a((float)((float)launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionZ = MathHelper.func_76134_b((float)((float)launchYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                float launchMotionY = -MathHelper.func_76126_a((float)((float)launchPitch / 180.0f * (float)Math.PI)) * launchPower;
                ListNBT motionList = new ListNBT();
                motionList.add((Object)DoubleNBT.func_229684_a_((double)launchMotionX));
                motionList.add((Object)DoubleNBT.func_229684_a_((double)launchMotionY));
                motionList.add((Object)DoubleNBT.func_229684_a_((double)launchMotionZ));
                return motionList;
            }
            catch (Exception contents) {
                // empty catch block
            }
        }
        if (name.startsWith("#bowMotion")) {
            try {
                float bowPowerMod = 1.0f;
                float randAngle = 0.0f;
                if (name.startsWith("#bowMotion(")) {
                    String contents = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
                    String[] splitValue = DropStringUtils.splitBracketString(contents, ',');
                    splitValue[0] = DropStringUtils.removeNumSuffix(splitValue[0]);
                    if (splitValue.length > 1) {
                        splitValue[1] = DropStringUtils.removeNumSuffix(splitValue[1]);
                    }
                    bowPowerMod = ValueParser.getFloat(splitValue[0], processData).floatValue();
                    if (splitValue.length > 1) {
                        randAngle = ValueParser.getFloat(splitValue[1], processData).floatValue();
                    }
                }
                Entity player = processData.getPlayer();
                Vector3d playerPos = player.func_213303_ch();
                ArrowEntity arrowEntity = processData.getPlayer() instanceof LivingEntity ? new ArrowEntity(processData.getWorld(), (LivingEntity)player) : new ArrowEntity(processData.getWorld(), playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c);
                arrowEntity.func_234612_a_(player, player.field_70125_A + HashVariables.randomFloatClamp(processData.getWorld().field_73012_v, -randAngle, randAngle), player.field_70177_z + HashVariables.randomFloatClamp(processData.getWorld().field_73012_v, -randAngle, randAngle), 0.0f, processData.getBowPower() * 3.0f * bowPowerMod, 1.0f);
                ListNBT motionList = new ListNBT();
                Vector3d arrowMotion = arrowEntity.func_213322_ci();
                motionList.add((Object)DoubleNBT.func_229684_a_((double)arrowMotion.field_72450_a));
                motionList.add((Object)DoubleNBT.func_229684_a_((double)arrowMotion.field_72448_b));
                motionList.add((Object)DoubleNBT.func_229684_a_((double)arrowMotion.field_72449_c));
                return motionList;
            }
            catch (Exception bowPowerMod) {
                // empty catch block
            }
        }
        name = name.replace("#chestVillageArmorer", "#chestLootTable(" + LootTables.field_215816_g.func_110623_a() + ")");
        name = name.replace("#chestBonusChest", "#chestLootTable(" + LootTables.field_186420_b.func_110623_a() + ")");
        if ((name = name.replace("#chestDungeonChest", "#chestLootTable(" + LootTables.field_186422_d.func_110623_a() + ")")).startsWith("#chestLootTable(")) {
            ChestTileEntity tileEntityChest = new ChestTileEntity();
            String lootId = ValueParser.getString(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)));
            tileEntityChest.func_189404_a(new ResourceLocation("minecraft", lootId), random.nextLong());
            if (processData.getWorld() != null) {
                tileEntityChest.func_226984_a_(processData.getWorld(), processData.getHarvestBlockPos());
            }
            tileEntityChest.func_184281_d(null);
            CompoundNBT tagCompound = new CompoundNBT();
            tileEntityChest.func_189515_b(tagCompound);
            return tagCompound.func_150295_c("Items", 10);
        }
        return null;
    }
}

