/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.value;

import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.HashVariables;
import mod.lucky.drop.value.NBTHashVariables;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringEscapeUtils;

public class ValueParser {
    public static HashBiMap<String, Class> classTypeToString = HashBiMap.create();
    private static ArrayList<String> DROP_TAGS;

    public static Object getObject(String string, Class objectType, DropProcessData processData) throws Exception {
        if (objectType == String.class) {
            return ValueParser.getString(string, processData);
        }
        if (objectType == Boolean.class) {
            return ValueParser.getBoolean(string, processData);
        }
        if (objectType == Byte.class) {
            return ValueParser.getByte(string, processData);
        }
        if (objectType == Short.class) {
            return ValueParser.getShort(string, processData);
        }
        if (objectType == Integer.class) {
            return ValueParser.getInteger(string, processData);
        }
        if (objectType == Float.class) {
            return ValueParser.getFloat(string, processData);
        }
        if (objectType == Double.class) {
            return ValueParser.getDouble(string, processData);
        }
        if (objectType == CompoundNBT.class) {
            return ValueParser.getNBTTag(string, processData);
        }
        return null;
    }

    public static INBT getNBTFromValue(Object value) {
        if (value.getClass() == String.class) {
            return StringNBT.func_229705_a_((String)((String)value));
        }
        if (value.getClass() == Boolean.class) {
            return ByteNBT.func_229671_a_((byte)((byte)((Boolean)value != false ? 1 : 0)));
        }
        if (value.getClass() == Byte.class) {
            return ByteNBT.func_229671_a_((byte)((Byte)value));
        }
        if (value.getClass() == Short.class) {
            return ShortNBT.func_229701_a_((short)((Short)value));
        }
        if (value.getClass() == Integer.class) {
            return IntNBT.func_229692_a_((int)((Integer)value));
        }
        if (value.getClass() == Float.class) {
            return FloatNBT.func_229689_a_((float)((Float)value).floatValue());
        }
        if (value.getClass() == Double.class) {
            return DoubleNBT.func_229684_a_((double)((Double)value));
        }
        if (value instanceof int[]) {
            new IntArrayNBT((int[])value);
        }
        if (value instanceof byte[]) {
            new ByteArrayNBT((byte[])value);
        }
        if (value instanceof INBT) {
            return (INBT)value;
        }
        return null;
    }

    public static Object getValueFromNBT(INBT nbt) {
        if (nbt.getClass() == StringNBT.class) {
            return ((StringNBT)nbt).func_150285_a_();
        }
        if (nbt.getClass() == ByteNBT.class) {
            return ((ByteNBT)nbt).func_150290_f() == 1;
        }
        if (nbt.getClass() == ShortNBT.class) {
            return ((ShortNBT)nbt).func_150289_e();
        }
        if (nbt.getClass() == IntNBT.class) {
            return ((IntNBT)nbt).func_150287_d();
        }
        if (nbt.getClass() == FloatNBT.class) {
            return Float.valueOf(((FloatNBT)nbt).func_150288_h());
        }
        if (nbt.getClass() == DoubleNBT.class) {
            return ((DoubleNBT)nbt).func_150286_g();
        }
        if (nbt instanceof IntArrayNBT) {
            ((IntArrayNBT)nbt).func_150302_c();
        }
        if (nbt instanceof ByteArrayNBT) {
            ((ByteArrayNBT)nbt).func_150292_c();
        }
        return nbt;
    }

    public static String getString(String string) throws NumberFormatException {
        return ValueParser.getString(string, null);
    }

    public static String getString(String string, DropProcessData processData) {
        string = HashVariables.processString(string, processData);
        if ((string = StringEscapeUtils.unescapeJava((String)string)).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static Double calculateNum(String string) throws NumberFormatException {
        int operator;
        string = DropStringUtils.removeNumSuffix(string);
        string = string.trim();
        double result = 0.0;
        String prefixSign = "";
        if (string.startsWith("-") || string.startsWith("+")) {
            prefixSign = string.substring(0, 1);
            string = string.substring(1);
        }
        int n = string.contains("+") ? 43 : (string.contains("-") ? 45 : (string.contains("*") ? 42 : (operator = string.contains("/") ? 47 : 0)));
        if (operator != 0) {
            String[] splitString = DropStringUtils.splitBracketString(string, (char)operator);
            if (splitString.length >= 2) {
                double num1 = Double.valueOf(prefixSign + splitString[0]);
                double num2 = Double.valueOf(splitString[1]);
                switch (operator) {
                    case 43: {
                        result = num1 + num2;
                        break;
                    }
                    case 45: {
                        result = num1 - num2;
                        break;
                    }
                    case 42: {
                        result = num1 * num2;
                        break;
                    }
                    case 47: {
                        result = num1 / num2;
                    }
                }
            }
        } else {
            result = Double.valueOf(prefixSign + string);
        }
        return result;
    }

    public static Integer getInteger(String string) throws NumberFormatException {
        return ValueParser.getInteger(string, null);
    }

    public static Integer getInteger(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string).intValue();
    }

    public static Double getDouble(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string);
    }

    public static Float getFloat(String string) throws NumberFormatException {
        return ValueParser.getFloat(string, null);
    }

    public static Float getFloat(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return Float.valueOf(ValueParser.calculateNum(string).floatValue());
    }

    public static Boolean getBoolean(String string) throws NumberFormatException {
        return ValueParser.getBoolean(string, null);
    }

    public static Boolean getBoolean(String string, DropProcessData processData) throws NumberFormatException {
        if (!(string = HashVariables.processString(string, processData)).equals("true") && !string.equals("false")) {
            throw new NumberFormatException("Unknown boolean format: " + string);
        }
        return Boolean.valueOf(string);
    }

    public static Short getShort(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string).shortValue();
    }

    public static Byte getByte(String string, DropProcessData processData) throws NumberFormatException {
        string = HashVariables.processString(string, processData);
        return ValueParser.calculateNum(string).byteValue();
    }

    public static CompoundNBT getNBTTag(String string, DropProcessData processData) throws Exception {
        Object tagBase = ValueParser.getNBTTagValue(string, processData);
        if (tagBase instanceof CompoundNBT) {
            return (CompoundNBT)tagBase;
        }
        throw new Exception("Not a valid compound NBT tag: " + string);
    }

    public static Object getNBTTagValue(String string, DropProcessData processData) throws Exception {
        return ValueParser.getNBTTagValue(string, processData, null, null);
    }

    public static INBT getNBTBase(String string, DropProcessData processData) throws Exception {
        return ValueParser.getNBTFromValue(ValueParser.getNBTTagValue(string, processData, null, null));
    }

    public static Object getNBTTagValue(String string, DropProcessData processData, INBT parentTag, String parentTagName) {
        INBT tagBase22;
        if (string.startsWith("(") && string.endsWith(")")) {
            String[] tagContents = DropStringUtils.splitBracketString(string.substring(1, string.length() - 1), ',');
            CompoundNBT tagCompound = new CompoundNBT();
            for (String tag : tagContents) {
                if (tag == null || tag.equals("")) continue;
                String tagName = tag.substring(0, tag.indexOf("="));
                String tagValue = tag.substring(tag.indexOf("=") + 1);
                ValueParser.setNBTTagValue((INBT)tagCompound, tagName, ValueParser.getNBTTagValue(tagValue, processData, (INBT)tagCompound, tagName));
            }
            return tagCompound;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            String[] tagContents = DropStringUtils.splitBracketString(string.substring(1, string.length() - 1), ',');
            ListNBT tagList = new ListNBT();
            for (String tag : tagContents) {
                if (tag == null || tag.equals("")) continue;
                ValueParser.setNBTTagValue((INBT)tagList, null, ValueParser.getNBTTagValue(tag, processData, (INBT)tagList, parentTagName));
            }
            return tagList;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            if (parentTag != null && parentTag instanceof ListNBT && parentTagName != null && DROP_TAGS.contains(parentTagName.toLowerCase())) {
                string = HashVariables.autoCancelHash(string);
            }
            return ValueParser.getString(string, processData);
        }
        if (string.startsWith("#") && (tagBase22 = NBTHashVariables.getNBTTagFromString(string, processData)) != null) {
            return tagBase22;
        }
        string = ValueParser.getString(string, processData);
        try {
            if (string.endsWith("f") || string.endsWith("F")) {
                return ValueParser.getFloat(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.endsWith("d") || string.endsWith("D") || DropStringUtils.hasDecimalPoint(string)) {
                return ValueParser.getDouble(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.endsWith("s") || string.endsWith("S")) {
                return ValueParser.getShort(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.endsWith("b") || string.endsWith("B")) {
                return ValueParser.getByte(DropStringUtils.removeNumSuffix(string), processData);
            }
            if (string.equals("true") || string.equals("false")) {
                return ValueParser.getBoolean(DropStringUtils.removeNumSuffix(string), processData);
            }
            return ValueParser.getInteger(DropStringUtils.removeNumSuffix(string), processData);
        }
        catch (Exception tagBase22) {
            try {
                String[] valuesString = string.split(":");
                if (valuesString.length >= 1) {
                    boolean type = false;
                    if (valuesString[0].endsWith("b") || valuesString[0].endsWith("B")) {
                        type = true;
                    }
                    int[] valuesInt = new int[valuesString.length];
                    byte[] valuesByte = new byte[valuesString.length];
                    for (int b = 0; b < valuesString.length; ++b) {
                        if (!type) {
                            valuesInt[b] = ValueParser.getInteger(valuesString[b], processData);
                            continue;
                        }
                        valuesString[b] = DropStringUtils.removeNumSuffix(valuesString[b]);
                        valuesByte[b] = ValueParser.getByte(valuesString[b], processData);
                    }
                    if (!type && valuesInt.length > 0) {
                        return valuesInt;
                    }
                    if (type && valuesByte.length > 0) {
                        return valuesByte;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
    }

    public static void setNBTTagValue(INBT curTag, String tagName, Object tagValue) {
        if (curTag instanceof CompoundNBT) {
            ((CompoundNBT)curTag).func_218657_a(tagName, ValueParser.getNBTFromValue(tagValue));
        } else if (curTag instanceof ListNBT) {
            ((ListNBT)curTag).add((Object)ValueParser.getNBTFromValue(tagValue));
        }
    }

    public static JsonElement nbtToJson(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            JsonObject json = new JsonObject();
            ((CompoundNBT)nbt).func_150296_c().forEach(k -> json.add(k, ValueParser.nbtToJson(((CompoundNBT)nbt).func_74781_a(k))));
            return json;
        }
        if (nbt instanceof CollectionNBT) {
            JsonArray json = new JsonArray();
            ((CollectionNBT)nbt).forEach(v -> json.add(ValueParser.nbtToJson(v)));
            return json;
        }
        if (nbt instanceof ByteNBT && ((ByteNBT)nbt).func_150290_f() < 2) {
            return new JsonPrimitive(new Boolean(((ByteNBT)nbt).func_150290_f() == 1));
        }
        return new JsonPrimitive(nbt.func_150285_a_());
    }

    public static Item getItem(String name, DropProcessData processData) {
        String fullName = ValueParser.getString(name, processData);
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(fullName));
    }

    public static Block getBlock(String name, DropProcessData processData) {
        String fullName = ValueParser.getString(name, processData);
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(fullName));
    }

    public static ItemStack getItemStack(String name, DropProcessData processData) {
        String[] splitName = name.split("\\*");
        Item item = ValueParser.getItem(splitName[0], null);
        int count = splitName.length > 1 ? ValueParser.getInteger(splitName[1], processData) : 1;
        return new ItemStack((IItemProvider)item, count);
    }

    static {
        classTypeToString.put((Object)"string", String.class);
        classTypeToString.put((Object)"int", Integer.class);
        classTypeToString.put((Object)"boolean", Boolean.class);
        classTypeToString.put((Object)"float", Float.class);
        classTypeToString.put((Object)"nbt", CompoundNBT.class);
        DROP_TAGS = new ArrayList<String>(Arrays.asList("drops", "impact"));
    }
}

