/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ILuckyItemContainer;
import mod.lucky.item.LuckyItem;
import mod.lucky.util.LuckyUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DistExecutor;

public class ItemLuckyBow
extends BowItem
implements ILuckyItemContainer {
    private LuckyItem luckyItem = new LuckyItem((Item)this);

    public ItemLuckyBow() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1000).func_200916_a(ItemGroup.field_78037_j));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.registerItemModels());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemModels() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
                if (entity == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entity.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() instanceof ItemLuckyBow ? (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
    }

    @Override
    public LuckyItem getLuckyItem() {
        return this.luckyItem;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack arrowStack = player.func_213356_f(stack);
            boolean unlimitedArrows = player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0 || arrowStack.func_77973_b() instanceof ArrowItem && ((ArrowItem)arrowStack.func_77973_b()).isInfinite(arrowStack, stack, player);
            int initPower = this.func_77626_a(stack) - timeLeft;
            if ((initPower = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)player, (int)initPower, (!arrowStack.func_190926_b() || unlimitedArrows ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (unlimitedArrows || !arrowStack.func_190926_b()) {
                float power = ItemLuckyBow.func_185059_b((int)initPower);
                if (!((double)power >= 0.1)) {
                    return;
                }
                if (!world.field_72995_K) {
                    try {
                        int luck = LuckyItem.getLuck(stack);
                        String[] drops = LuckyItem.getRawDrops(stack);
                        ArrowItem arrowitem = (ArrowItem)(stack.func_77973_b() instanceof ArrowItem ? stack.func_77973_b() : Items.field_151032_g);
                        AbstractArrowEntity arrowEntity = arrowitem.func_200887_a(world, stack, (LivingEntity)player);
                        DropProcessData dropData = new DropProcessData((IWorld)world, (Entity)player, arrowEntity.func_213303_ch()).setBowPower(power * 3.0f);
                        if (drops != null && drops.length != 0) {
                            this.getLuckyItem().getDropProcessor().processRandomDrop(LuckyUtils.dropsFromStrArray(drops), dropData, luck);
                        } else {
                            this.getLuckyItem().getDropProcessor().processRandomDrop(dropData, luck);
                        }
                    }
                    catch (Exception e) {
                        Lucky.error(e, DropProcessor.errorMessage());
                    }
                }
                Vector3d playerPos = player.func_213303_ch();
                world.func_184148_a(null, playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                if (!unlimitedArrows && !player.field_71075_bZ.field_75098_d) {
                    arrowStack.func_190918_g(1);
                    if (arrowStack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(arrowStack);
                    }
                }
            }
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.luckyItem.addLuckyTooltip(stack, worldIn, tooltip, flagIn);
    }
}

