/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.util.LuckyUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LuckyItem {
    private Item containerItem;
    private DropProcessor dropProcessor;

    public LuckyItem(Item containerItem) {
        this.containerItem = containerItem;
        this.dropProcessor = new DropProcessor();
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    public boolean hasLuckVariantsInGroup() {
        return false;
    }

    public TextComponent getVeryLuckyName() {
        return null;
    }

    public TextComponent getUnluckyName() {
        return null;
    }

    private boolean isOriginalItem() {
        return this.containerItem == Lucky.luckyBlock.func_199767_j() || this.containerItem == Lucky.luckySword || this.containerItem == Lucky.luckyBow || this.containerItem == Lucky.luckyPotion;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addLuckyTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int luck = LuckyItem.getLuck(stack);
        IFormattableTextComponent luckComponent = luck == 0 ? new StringTextComponent("" + luck).func_240699_a_(TextFormatting.GOLD) : (luck < 0 ? new StringTextComponent("" + luck).func_240699_a_(TextFormatting.RED) : new StringTextComponent("+" + luck).func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.lucky.lucky_block.luck").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)luckComponent));
        String[] drops = LuckyItem.getRawDrops(stack);
        if (drops != null && drops.length != 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.lucky.lucky_block.customDrop").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }

    public void addLuckySubItems(NonNullList<ItemStack> items) {
        ItemStack normalItemStack = new ItemStack((IItemProvider)this.getContainerItem(), 1);
        items.add((Object)normalItemStack);
        if (this.hasLuckVariantsInGroup() && this.isOriginalItem()) {
            CompoundNBT luckyTag = new CompoundNBT();
            luckyTag.func_74768_a("Luck", 80);
            CompoundNBT unluckyTag = new CompoundNBT();
            unluckyTag.func_74768_a("Luck", -80);
            ItemStack luckyItemStack = new ItemStack((IItemProvider)this.getContainerItem(), 1);
            luckyItemStack.func_77982_d(luckyTag);
            luckyItemStack.func_200302_a((ITextComponent)this.getVeryLuckyName());
            items.add((Object)luckyItemStack);
            ItemStack unluckyItemStack = new ItemStack((IItemProvider)this.getContainerItem(), 1);
            unluckyItemStack.func_77982_d(unluckyTag);
            unluckyItemStack.func_200302_a((ITextComponent)this.getUnluckyName());
            items.add((Object)unluckyItemStack);
        }
    }

    public static int getLuck(ItemStack stack) {
        try {
            return stack.func_77978_p().func_74762_e("Luck");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Nullable
    public static String[] getRawDrops(ItemStack stack) {
        try {
            return LuckyUtils.strArrayFromTagList(stack.func_77978_p().func_150295_c("Drops", 8));
        }
        catch (Exception e) {
            return null;
        }
    }
}

