/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import javax.annotation.Nullable;
import mod.lucky.drop.func.DropFuncBlock;
import mod.lucky.structure.BlockPlacer;
import mod.lucky.structure.Structure;
import mod.lucky.util.LuckyUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructureUtils {
    private static int normalizeRotation(int rotation) {
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        return rotation;
    }

    public static Vector3d rotatePos(Vector3d pos, Vector3d centerPos, int rotation) {
        rotation = StructureUtils.normalizeRotation(rotation);
        double posX = pos.field_72450_a - centerPos.field_72450_a;
        double posY = pos.field_72448_b - centerPos.field_72448_b;
        double posZ = centerPos.field_72449_c - pos.field_72449_c;
        for (int i = 0; i < rotation; ++i) {
            double z;
            double x = posX;
            posX = z = posZ;
            posZ = -x;
        }
        return new Vector3d(posX + centerPos.field_72450_a, posY + centerPos.field_72448_b, centerPos.field_72449_c - posZ);
    }

    public static Rotation parseRotation(int rotation) {
        return Rotation.values()[rotation];
    }

    public static Vector3d getWorldPos(Vector3d structPos, Vector3d structCenter, Vector3d harvestPos, int rotation) {
        return StructureUtils.rotatePos(harvestPos.func_178787_e(structPos).func_178788_d(structCenter), harvestPos, rotation);
    }

    public static BlockPos getWorldPos(BlockPos posInStruct, Vector3d structCenter, Vector3d harvestPos, int rotation) {
        return new BlockPos(StructureUtils.getWorldPos(LuckyUtils.toVector3d(posInStruct), structCenter, harvestPos, rotation));
    }

    @Nullable
    public static BlockState applyBlockMode(Structure.BlockMode mode, BlockState state) {
        if (mode == Structure.BlockMode.AIR && state.func_177230_c() != Blocks.field_150350_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (mode == Structure.BlockMode.OVERLAY && state.func_177230_c() != Blocks.field_150350_a) {
            return state;
        }
        if (mode == Structure.BlockMode.REPLACE) {
            return state;
        }
        return null;
    }

    public static void setBlock(BlockPlacer blockPlacer, BlockState blockState, BlockPos posInStruct, Vector3d structCenter, Vector3d harvestPos, int rotation) {
        BlockPos pos = StructureUtils.getWorldPos(posInStruct, structCenter, harvestPos, rotation);
        BlockState newBlockState = blockState.rotate(blockPlacer.getWorld(), pos, StructureUtils.parseRotation(rotation));
        blockPlacer.add(newBlockState, pos);
    }

    public static void fillWithAir(BlockPlacer blockPlacer, BlockPos size, Vector3d centerPos, Vector3d harvestPos, int rotation) {
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    StructureUtils.setBlock(blockPlacer, Blocks.field_150350_a.func_176223_P(), new BlockPos(x, y, z), centerPos, harvestPos, rotation);
                }
            }
        }
    }

    public static void setTileEntity(IWorld world, CompoundNBT tileEntity, BlockPos structPos, Vector3d structCenter, Vector3d harvestPos, int rotation) {
        BlockPos pos = StructureUtils.getWorldPos(structPos, structCenter, harvestPos, rotation);
        DropFuncBlock.setTileEntity(world, world.func_180495_p(pos), pos, tileEntity);
    }

    public static void setEntity(World world, Entity entity, Vector3d structCenter, Vector3d harvestPos, int rotation) {
        if (!(world instanceof ServerWorld)) {
            return;
        }
        Vector3d pos = StructureUtils.getWorldPos(entity.func_213303_ch(), structCenter, harvestPos, rotation);
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entity.field_70177_z = entity.func_184229_a(StructureUtils.parseRotation(rotation));
        ((ServerWorld)world).func_217470_d(entity);
    }

    public static CompoundNBT rotateEntityNBT(CompoundNBT entityTag, Vector3d centerPos, int rotation) {
        CompoundNBT newTag = entityTag.func_74737_b();
        rotation = StructureUtils.normalizeRotation(rotation);
        if (entityTag.func_74764_b("Pos")) {
            ListNBT posList = entityTag.func_150295_c("Pos", 6);
            Vector3d entityPos = new Vector3d(posList.func_150309_d(0), posList.func_150309_d(1), posList.func_150309_d(2));
            entityPos = StructureUtils.rotatePos(entityPos, centerPos, rotation);
            posList = new ListNBT();
            posList.add((Object)DoubleNBT.func_229684_a_((double)entityPos.field_72450_a));
            posList.add((Object)DoubleNBT.func_229684_a_((double)entityPos.field_72448_b));
            posList.add((Object)DoubleNBT.func_229684_a_((double)entityPos.field_72449_c));
            newTag.func_218657_a("Pos", (INBT)posList);
        }
        if (entityTag.func_74764_b("Motion")) {
            ListNBT motionList = entityTag.func_150295_c("Motion", 6);
            Vector3d entityMotion = new Vector3d(motionList.func_150309_d(0), motionList.func_150309_d(1), motionList.func_150309_d(2));
            entityMotion = StructureUtils.rotatePos(entityMotion, new Vector3d(0.0, 0.0, 0.0), rotation);
            motionList = new ListNBT();
            motionList.add((Object)DoubleNBT.func_229684_a_((double)entityMotion.field_72450_a));
            motionList.add((Object)DoubleNBT.func_229684_a_((double)entityMotion.field_72448_b));
            motionList.add((Object)DoubleNBT.func_229684_a_((double)entityMotion.field_72449_c));
            newTag.func_218657_a("Motion", (INBT)motionList);
        }
        if (entityTag.func_74764_b("Rotation")) {
            ListNBT rotationList = entityTag.func_150295_c("Rotation", 5);
            float rotYaw = rotationList.func_150308_e(0);
            float rotPitch = rotationList.func_150308_e(1);
            rotYaw = (rotYaw + (float)rotation * 90.0f) % 360.0f;
            rotationList = new ListNBT();
            rotationList.add((Object)FloatNBT.func_229689_a_((float)rotYaw));
            rotationList.add((Object)FloatNBT.func_229689_a_((float)rotPitch));
            newTag.func_218657_a("Rotation", (INBT)rotationList);
        }
        return newTag;
    }
}

