/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.world;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import mod.lucky.Lucky;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.world.DelayLuckyDrop;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LuckyTickHandler {
    private ConcurrentHashMap<Integer, Object> delayDrops;
    private static boolean showUpdate = true;
    private static boolean didShowUpdate = false;
    private HashMap<String, Boolean> didShowUpdateCache = new HashMap();

    public LuckyTickHandler() {
        try {
            this.delayDrops = new ConcurrentHashMap();
            this.readDidShowUpdate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setShowUpdateMessage(boolean showUpdateMessage) {
        showUpdate = showUpdateMessage;
    }

    private static int getVersionNumber() {
        String[] mcv = Lucky.MC_VERSION.toString().split("\\.");
        int luckySubversion = Integer.parseInt(Lucky.VERSION.toString().split("-")[1]);
        return Integer.parseInt(mcv[0]) * 1000000 + Integer.parseInt(mcv[1]) * 10000 + Integer.parseInt(mcv[2]) * 100 + luckySubversion;
    }

    private void readDidShowUpdate() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(Lucky.resourceManager.getDefaultLoader().getFile(".showupdate.cache")));
            while ((line = br.readLine()) != null) {
                this.didShowUpdateCache.put(line, true);
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeDidShowUpdate(int version) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(Lucky.resourceManager.getDefaultLoader().getFile(".showupdate.cache"), true));
            bw.newLine();
            bw.append(String.valueOf(version));
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        block3: {
            try {
                String line;
                if (!showUpdate || Minecraft.func_71410_x().field_71439_g == null || didShowUpdate) break block3;
                didShowUpdate = true;
                int curVersionNumber = LuckyTickHandler.getVersionNumber();
                URL url = new URL("https://www.luckyblockmod.com/version-log");
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = reader.readLine()) != null) {
                    int logVersionNumber;
                    String[] split = line.split("\\|");
                    if (split.length < 3 || (logVersionNumber = Integer.parseInt(split[0])) > 0 && this.didShowUpdateCache.containsKey(String.valueOf(logVersionNumber)) || logVersionNumber <= curVersionNumber) continue;
                    String message = split[2];
                    IFormattableTextComponent textComponent = ITextComponent.Serializer.func_240643_a_((String)message);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)textComponent, Minecraft.func_71410_x().field_71439_g.func_110124_au());
                    LuckyTickHandler.writeDidShowUpdate(logVersionNumber);
                    break;
                }
            }
            catch (Exception e) {
                Lucky.error(e, "Error showing update message");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            for (int i = 0; i > -1; ++i) {
                if (this.delayDrops.containsKey(i) && this.delayDrops.get(i) instanceof DelayLuckyDrop) {
                    DelayLuckyDrop delayDrop = (DelayLuckyDrop)this.delayDrops.get(i);
                    delayDrop.update();
                    if (delayDrop.finished()) {
                        this.delayDrops.remove(i);
                        if (this.delayDrops.containsKey(i + 1)) {
                            this.delayDrops.put(i, 0);
                        }
                    }
                }
                if (this.delayDrops.containsKey(i)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Lucky.error(e, "Error processing delay drop");
            this.delayDrops.clear();
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        try {
            if (this.delayDrops.size() > 0) {
                boolean saved = false;
                ListNBT dropTags = new ListNBT();
                for (int i = 0; i > -1; ++i) {
                    if (this.delayDrops.containsKey(i) && this.delayDrops.get(i) instanceof DelayLuckyDrop) {
                        DelayLuckyDrop delayDrop = (DelayLuckyDrop)this.delayDrops.get(i);
                        BlockPos harvestPos = delayDrop.getProcessData().getHarvestBlockPos();
                        ChunkPos harvestChunkPos = event.getWorld().func_217349_x(harvestPos).func_76632_l();
                        if (harvestChunkPos == event.getChunk().func_76632_l()) {
                            dropTags.add((Object)delayDrop.writeToNBT());
                            saved = true;
                        }
                    }
                    if (!this.delayDrops.containsKey(i)) break;
                }
                if (saved) {
                    event.getData().func_218657_a("LuckyBlockDelayDrops", (INBT)dropTags);
                }
            }
        }
        catch (Exception e) {
            Lucky.error(e, "Error saving chunk properties");
            this.delayDrops.clear();
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        try {
            if (event.getData().func_74764_b("LuckyBlockDelayDrops")) {
                ListNBT delayDropTags = event.getData().func_150295_c("LuckyBlockDelayDrops", 10);
                for (int i = 0; i < delayDropTags.size(); ++i) {
                    DelayLuckyDrop delayDrop = new DelayLuckyDrop(Lucky.luckyBlock.getDropProcessor(), null, 0L);
                    delayDrop.readFromNBT(delayDropTags.func_150305_b(i), event.getChunk().getWorldForge());
                    this.addDelayDrop(delayDrop);
                }
            }
        }
        catch (Exception e) {
            Lucky.error(e, "Error loading chunk properties");
            this.delayDrops.clear();
        }
    }

    public void addDelayDrop(DelayLuckyDrop delayDrop) {
        for (int i = 0; i > -1; ++i) {
            if (this.delayDrops.containsKey(i) && this.delayDrops.get(i) instanceof DelayLuckyDrop) continue;
            this.delayDrops.put(i, delayDrop);
            break;
        }
    }

    public void addDelayDrop(DropProcessor dropProcessor, DropProcessData processData, float delay) {
        this.addDelayDrop(new DelayLuckyDrop(dropProcessor, processData, (long)(delay * 20.0f)));
    }
}

