/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.world;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.block.BlockLuckyBlock;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LuckyWorldFeature
extends Feature<NoFeatureConfig> {
    private BlockLuckyBlock block;
    private HashMap<String, ArrayList<DropFull>> dimensionDrops;

    public LuckyWorldFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public void init(BlockLuckyBlock block) {
        this.block = block;
        this.dimensionDrops = new HashMap();
    }

    private void generate(IWorld world, Random rand, BlockPos pos, ArrayList<DropFull> drops) {
        int initIndex = rand.nextInt(drops.size());
        for (int i = 0; i < drops.size(); ++i) {
            DropFull drop = drops.get((initIndex + i) % drops.size());
            if (rand.nextInt((int)drop.getChance()) != 0) continue;
            DropProcessData processData = new DropProcessData(world, null, pos);
            System.out.println("generating at: " + pos.toString());
            this.block.getDropProcessor().processRandomDrop(drops, processData, 0);
        }
    }

    private boolean generate(ISeedReader world, Random rand, BlockPos pos) {
        ResourceLocation dimension = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (this.dimensionDrops.containsKey(dimension.toString())) {
            ArrayList<DropFull> drops = this.dimensionDrops.get(dimension.toString());
            this.generate((IWorld)world, rand, pos, drops);
            return true;
        }
        return false;
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        try {
            pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos);
            while (pos.func_177956_o() > 0) {
                BlockState soilState = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
                if (soilState.func_177230_c() == Blocks.field_150357_h || !this.block.canPlaceAt((IWorld)world, pos)) {
                    pos = pos.func_177977_b();
                    continue;
                }
                return this.generate(world, random, pos);
            }
            return false;
        }
        catch (Exception e) {
            Lucky.error(e, "Error during natural generation");
            return false;
        }
    }

    private DropFull initDrop(ResourceLocation dimension, DropFull drop) {
        if (!drop.wasChanceSet()) {
            drop.setChance(300.0f);
        }
        return drop;
    }

    public void addDrop(ResourceLocation dimension, DropFull drop) {
        if (!this.dimensionDrops.containsKey(dimension.toString())) {
            this.dimensionDrops.put(dimension.toString(), new ArrayList());
        }
        this.dimensionDrops.get(dimension.toString()).add(this.initDrop(dimension, drop));
    }
}

