/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import mod.lucky.drop.DropBase;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.DropValue;
import mod.lucky.drop.value.ValueParser;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;

public class DropProperties
extends DropBase {
    private static String[] multiPosProperties = new String[]{"pos", "pos2", "posOffset"};
    private HashMap<String, DropValue> properties = new HashMap();
    private boolean needsInitialize = false;
    private static HashMap<String, HashMap<String, Class>> defaultValueTypes = new HashMap();
    private static HashMap<String, HashMap<String, Object>> defaultValues = new HashMap();
    private static HashMap<String, String> replaceProperties = new HashMap();

    public HashMap<String, DropValue> getProperties() {
        return this.properties;
    }

    public DropValue getRawProperty(String name) {
        name = DropProperties.processName(name);
        return this.properties.get(name);
    }

    public Object getProperty(String name) {
        DropValue property = this.properties.get(name = DropProperties.processName(name));
        if (property == null) {
            return this.getDefaultPropertyValue(name);
        }
        return property.getValue();
    }

    public Integer getPropertyInt(String name) {
        if (this.getProperty(name) instanceof Float) {
            return ((Float)this.getProperty(name)).intValue();
        }
        return (Integer)this.getProperty(name);
    }

    public String getPropertyString(String name) {
        return (String)this.getProperty(name);
    }

    public Boolean getPropertyBoolean(String name) {
        return (Boolean)this.getProperty(name);
    }

    public Float getPropertyFloat(String name) {
        if (this.getProperty(name) instanceof Integer) {
            return Float.valueOf(((Integer)this.getProperty(name)).floatValue());
        }
        return (Float)this.getProperty(name);
    }

    public NBTTagCompound getPropertyNBT(String name) {
        return (NBTTagCompound)this.getProperty(name);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.getVecPos());
    }

    public Vec3 getVecPos() {
        return new Vec3((double)this.getPropertyFloat("posX").floatValue(), (double)this.getPropertyFloat("posY").floatValue(), (double)this.getPropertyFloat("posZ").floatValue());
    }

    public void setBlockPos(BlockPos pos) {
        this.setProperty("posX", pos.func_177958_n());
        this.setProperty("posY", pos.func_177956_o());
        this.setProperty("posZ", pos.func_177952_p());
    }

    public void setVecPos(Vec3 pos) {
        this.setProperty("posX", pos.field_72450_a);
        this.setProperty("posY", pos.field_72448_b);
        this.setProperty("posZ", pos.field_72449_c);
    }

    public IBlockState getBlockState() {
        Block block;
        try {
            block = Block.func_149729_e((int)ValueParser.getInteger(this.getPropertyString("ID")));
        }
        catch (Exception e) {
            block = Block.func_149684_b((String)this.getPropertyString("ID"));
        }
        return block.func_176203_a(this.getPropertyInt("damage").intValue());
    }

    public void setProperty(String name, Object value) {
        name = DropProperties.processName(name);
        this.properties.put(name, new DropValue(value));
    }

    public void setOverrideProperty(String name, Object value) {
        if (!this.hasProperty(name)) {
            this.setProperty(name, value);
        }
    }

    public DropValue setRawProperty(String name, String value) {
        name = DropProperties.processName(name);
        try {
            DropValue property = new DropValue(value, this.getDefaultPropertyType(name));
            if (property.needsInitialize()) {
                this.needsInitialize = true;
            }
            this.properties.put(name, property);
            return property;
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error loading property: " + name + "=" + value);
            e.printStackTrace();
            return null;
        }
    }

    public void setOverrideRawProperty(String name, String value) {
        if (!this.hasProperty(name)) {
            this.setRawProperty(name, value);
        }
    }

    public boolean hasProperty(String name) {
        return this.properties.get(name = DropProperties.processName(name)) != null;
    }

    public Object defaultCast(String name, Object object) {
        name = DropProperties.processName(name);
        Class type = this.getDefaultPropertyType(name);
        if (object instanceof Integer && type == Float.class) {
            return Float.valueOf(((Integer)object).intValue());
        }
        if (object instanceof Float && type == Integer.class) {
            return (int)((Float)object).floatValue();
        }
        return type.cast(object);
    }

    public boolean needsInitialize() {
        return this.needsInitialize;
    }

    @Override
    public DropProperties initialize(DropProcessData processData) {
        DropProperties properties = this.copy();
        if (!properties.hasProperty("pos")) {
            properties.setOverrideProperty("posX", properties.defaultCast("posX", Float.valueOf((float)processData.getHarvestPos().field_72450_a)));
            properties.setOverrideProperty("posY", properties.defaultCast("posY", Float.valueOf((float)processData.getHarvestPos().field_72448_b)));
            properties.setOverrideProperty("posZ", properties.defaultCast("posZ", Float.valueOf((float)processData.getHarvestPos().field_72449_c)));
        }
        for (String posType : multiPosProperties) {
            if (!properties.hasProperty(posType)) continue;
            properties.getRawProperty(posType).initialize(processData);
            String[] pos = properties.getPropertyString(posType).substring(1, properties.getPropertyString(posType).length() - 1).split(",");
            properties.setOverrideRawProperty(posType + "X", pos[0]);
            properties.setOverrideRawProperty(posType + "Y", pos[1]);
            properties.setOverrideRawProperty(posType + "Z", pos[2]);
        }
        if (properties.hasProperty("size")) {
            properties.getRawProperty("size").initialize(processData);
            String[] size = properties.getPropertyString("size").substring(1, properties.getPropertyString("size").length() - 1).split(",");
            properties.setOverrideRawProperty("length", size[0]);
            properties.setOverrideRawProperty("height", size[1]);
            properties.setOverrideRawProperty("width", size[2]);
        }
        if (properties.needsInitialize) {
            Iterator<Map.Entry<String, DropValue>> iterator = properties.properties.entrySet().iterator();
            while (iterator.hasNext()) {
                iterator.next().getValue().initialize(processData);
            }
        }
        if (properties.hasProperty("posOffsetX")) {
            properties.getRawProperty("posX").setValue(properties.defaultCast("posX", Float.valueOf(properties.getPropertyFloat("posX").floatValue() + properties.getPropertyFloat("posOffsetX").floatValue())));
        }
        if (properties.hasProperty("posOffsetY")) {
            properties.getRawProperty("posY").setValue(properties.defaultCast("posY", Float.valueOf(properties.getPropertyFloat("posY").floatValue() + properties.getPropertyFloat("posOffsetY").floatValue())));
        }
        if (properties.hasProperty("posOffsetZ")) {
            properties.getRawProperty("posZ").setValue(properties.defaultCast("posZ", Float.valueOf(properties.getPropertyFloat("posZ").floatValue() + properties.getPropertyFloat("posOffsetZ").floatValue())));
        }
        for (String posType : multiPosProperties) {
            if (properties.hasProperty(posType) || !properties.hasProperty(posType + "X") && !properties.hasProperty(posType + "Y") && !properties.hasProperty(posType + "Z")) continue;
            properties.setProperty(posType, "(" + properties.getProperty(posType + "X").toString() + "," + properties.getProperty(posType + "Y").toString() + "," + properties.getProperty(posType + "Z").toString() + ")");
        }
        return properties;
    }

    @Override
    public void readFromString(String string) {
        String[] properties = DropStringUtils.splitBracketString(string, ',');
        for (int parse = 0; parse < 2; ++parse) {
            for (String property : properties) {
                String name = property.substring(0, property.indexOf("=")).trim().toLowerCase(Locale.ENGLISH);
                String value = property.substring(property.indexOf("=") + 1).trim();
                if (parse == 0 && name.toLowerCase(Locale.ENGLISH).equals("type")) {
                    this.setRawProperty(name, value);
                    continue;
                }
                if (parse != 1 || name.toLowerCase(Locale.ENGLISH).equals("type")) continue;
                this.setRawProperty(name, value);
            }
        }
        if (this.needsInitialize && !this.hasProperty("reinitialize")) {
            this.setProperty("reinitialize", true);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound propertiesTag = tagCompound.func_74775_l("properties");
        for (Object key : propertiesTag.func_150296_c()) {
            DropValue dropValue = new DropValue(null);
            dropValue.readFromNBT((NBTTagCompound)propertiesTag.func_74781_a((String)key));
            this.properties.put((String)key, dropValue);
        }
        this.needsInitialize = tagCompound.func_74767_n("needsInitialize");
    }

    @Override
    public String writeToString() {
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound mainTag = new NBTTagCompound();
        NBTTagCompound propertiesTag = new NBTTagCompound();
        for (String key : this.properties.keySet()) {
            propertiesTag.func_74782_a(key, (NBTBase)this.properties.get(key).writeToNBT());
        }
        mainTag.func_74782_a("properties", (NBTBase)propertiesTag);
        mainTag.func_74757_a("needsInitialize", this.needsInitialize);
        return mainTag;
    }

    private Class getDefaultPropertyType(String name) {
        String type;
        name = DropProperties.processName(name);
        if (this.hasProperty("type") && defaultValueTypes.get(type = this.getPropertyString("type")) != null && defaultValueTypes.get(type).containsKey(name)) {
            return defaultValueTypes.get(type).get(name);
        }
        return defaultValueTypes.get("all").get(name);
    }

    private Object getDefaultPropertyValue(String name) {
        String type;
        name = DropProperties.processName(name);
        if (this.hasProperty("type") && defaultValues.get(type = this.getPropertyString("type")) != null && defaultValues.get(type).containsKey(name)) {
            return defaultValues.get(type).get(name);
        }
        return defaultValues.get("all").get(name);
    }

    public DropProperties copy() {
        DropProperties dropProperties = new DropProperties();
        for (String key : this.properties.keySet()) {
            dropProperties.properties.put(key, this.properties.get(key).copy());
        }
        dropProperties.needsInitialize = this.needsInitialize;
        return dropProperties;
    }

    public static void setDefaultProperty(String type, String name, Class valueType, Object defaultValue) {
        name = DropProperties.processName(name);
        if (defaultValueTypes.get(type) == null) {
            defaultValueTypes.put(type, new HashMap());
        }
        defaultValueTypes.get(type).put(name, valueType);
        if (defaultValues.get(type) == null) {
            defaultValues.put(type, new HashMap());
        }
        defaultValues.get(type).put(name, defaultValue);
        if (!type.equals("all")) {
            DropProperties.setDefaultProperty("all", name, valueType, defaultValue);
        }
    }

    public static void setReplaceProperty(String original, String replace) {
        replaceProperties.put(original.toLowerCase(Locale.ENGLISH), replace.toLowerCase(Locale.ENGLISH));
    }

    private static String processName(String name) {
        if (replaceProperties.get(name = name.toLowerCase(Locale.ENGLISH)) != null) {
            name = replaceProperties.get(name);
        }
        return name;
    }

    public String toString() {
        String string = "";
        for (String key : this.properties.keySet()) {
            string = string + key + "=" + this.properties.get(key).toString() + ",";
        }
        return string.substring(0, string.length() - 1);
    }
}

