/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.List;
import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFunction;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.ValueParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class DropFuncEffect
extends DropFunction {
    @Override
    public void process(DropProcessData processData) {
        List list1;
        DropProperties drop = processData.getDropProperties();
        Entity target = null;
        AxisAlignedBB effectBox = new AxisAlignedBB(drop.getBlockPos(), drop.getBlockPos()).func_72314_b((double)(drop.getPropertyInt("range") * 2), (double)(drop.getPropertyInt("range") * 2), (double)(drop.getPropertyInt("range") * 2));
        if (drop.hasProperty("target") && !drop.hasProperty("range")) {
            Object object = drop.getPropertyString("target").equals("player") ? processData.getPlayer() : (target = drop.getPropertyString("target").equals("hitEntity") ? processData.getHitEntity() : null);
        }
        if (!drop.hasProperty("target") && !drop.hasProperty("range")) {
            target = processData.getPlayer();
        }
        if (drop.getPropertyString("target").equals("hitEntity") && processData.getHitEntity() == null) {
            return;
        }
        int potionEffectId = -1;
        String effectID = drop.getPropertyString("ID");
        if (!effectID.equals("special_fire") && !effectID.equals("special_knockback")) {
            try {
                potionEffectId = ValueParser.getInteger(effectID);
            }
            catch (Exception e) {
                Potion potion = Potion.func_180142_b((String)effectID);
                potionEffectId = potion.field_76415_H;
            }
        }
        if (target != null) {
            if (effectID.equals("special_fire")) {
                this.specialEffectFire(processData, target);
            } else if (effectID.equals("special_knockback")) {
                this.specialEffectKnockback(processData, target);
            } else {
                this.potionEffect(processData, target, potionEffectId);
            }
        } else if (effectBox != null && !(list1 = processData.getWorld().func_72872_a(EntityLivingBase.class, effectBox)).isEmpty()) {
            for (EntityLivingBase entityLivingBase : list1) {
                double distance;
                if (processData.getDropProperties().getPropertyBoolean("excludePlayer").booleanValue() && entityLivingBase == processData.getPlayer() || !((distance = processData.getDropProperties().getVecPos().func_72438_d(entityLivingBase.func_174791_d())) <= (double)drop.getPropertyFloat("range").floatValue())) continue;
                if (effectID.equals("special_fire")) {
                    this.specialEffectFire(processData, (Entity)entityLivingBase);
                    continue;
                }
                if (effectID.equals("special_knockback")) {
                    this.specialEffectKnockback(processData, (Entity)entityLivingBase);
                    continue;
                }
                this.potionEffect(processData, (Entity)entityLivingBase, potionEffectId);
            }
        }
    }

    private void potionEffect(DropProcessData processData, Entity entity, int potionEffectId) {
        Potion potion = Potion.field_76425_a[potionEffectId];
        int duration = (int)((double)processData.getDropProperties().getPropertyFloat("duration").floatValue() * 20.0);
        if (potion.func_76403_b()) {
            duration = 1;
        }
        PotionEffect potionEffect = new PotionEffect(potionEffectId, duration, processData.getDropProperties().getPropertyInt("amplifier").intValue());
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(potionEffect);
        }
    }

    private void specialEffectFire(DropProcessData processData, Entity entity) {
        entity.func_70015_d(processData.getDropProperties().getPropertyInt("duration").intValue());
    }

    private void specialEffectKnockback(DropProcessData processData, Entity entity) {
        Vec3 dropPos = processData.getDropProperties().getVecPos();
        float yawAngle = processData.getDropProperties().hasProperty("directionYaw") ? processData.getDropProperties().getPropertyFloat("directionYaw").floatValue() : (float)Math.toDegrees(Math.atan2((entity.field_70165_t - dropPos.field_72450_a) * -1.0, entity.field_70161_v - dropPos.field_72449_c));
        float pitchAngle = processData.getDropProperties().getPropertyFloat("directionPitch").floatValue();
        float power = processData.getDropProperties().getPropertyFloat("power").floatValue();
        if (!processData.getDropProperties().hasProperty("target") && dropPos.func_72438_d(entity.func_174791_d()) < 0.01) {
            pitchAngle = -90.0f;
            power = (float)((double)power * 0.5);
        }
        entity.field_70159_w = -MathHelper.func_76126_a((float)(yawAngle / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitchAngle / 180.0f * (float)Math.PI)) * power;
        entity.field_70179_y = MathHelper.func_76134_b((float)(yawAngle / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitchAngle / 180.0f * (float)Math.PI)) * power;
        entity.field_70181_x = -MathHelper.func_76126_a((float)(pitchAngle / 180.0f * (float)Math.PI)) * power;
        entity.field_70133_I = true;
    }

    @Override
    public void registerProperties() {
        DropProperties.setDefaultProperty(this.getType(), "duration", Integer.class, 30);
        DropProperties.setDefaultProperty(this.getType(), "amplifier", Integer.class, 0);
        DropProperties.setDefaultProperty(this.getType(), "target", String.class, "player");
        DropProperties.setDefaultProperty(this.getType(), "excludePlayer", Boolean.class, false);
        DropProperties.setDefaultProperty(this.getType(), "range", Float.class, 4);
        DropProperties.setDefaultProperty(this.getType(), "power", Float.class, 1);
        DropProperties.setDefaultProperty(this.getType(), "directionYaw", Float.class, 0);
        DropProperties.setDefaultProperty(this.getType(), "directionPitch", Float.class, -30);
    }

    @Override
    public String getType() {
        return "effect";
    }
}

