/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import mod.lucky.crafting.LuckyCrafting;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLuckySword
extends ItemSword {
    private DropProcessor dropProcessor;
    private LuckyCrafting crafting;

    public ItemLuckySword() {
        super(Item.ToolMaterial.IRON);
        this.func_77656_e(3124);
        this.dropProcessor = new DropProcessor();
        this.crafting = new LuckyCrafting((Item)this);
    }

    public int func_77626_a(ItemStack stack) {
        return 7200;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        try {
            int luck = ItemLuckyBlock.getLuck(itemStack);
            String[] drops = ItemLuckyBlock.getDrops(itemStack);
            if (drops != null && drops.length != 0) {
                this.getDropProcessor().processRandomDrop(LuckyFunction.getDropsFromStringArray(drops), new DropProcessData(attacker.func_130014_f_(), (Entity)attacker, target.func_174791_d()).setHitEntity((Entity)target), luck);
            } else {
                this.getDropProcessor().processRandomDrop(new DropProcessData(attacker.func_130014_f_(), (Entity)attacker, target.func_174791_d()).setHitEntity((Entity)target), luck);
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Sword encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
        return super.func_77644_a(itemStack, target, attacker);
    }

    public DropProcessor getDropProcessor() {
        return this.dropProcessor;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        list.add(StatCollector.func_74838_a((String)"item.luckyBlock.luck") + ": " + (luck == 0 ? EnumChatFormatting.GOLD : (luck < 0 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN + "+")) + String.valueOf(luck));
        if (drops != null && drops.length != 0) {
            list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.luckyBlock.customDrop"));
        }
    }

    public LuckyCrafting getCrafting() {
        return this.crafting;
    }
}

