/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.world;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import mod.lucky.Lucky;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.world.DelayLuckyDrop;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentProcessor;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LuckyTickHandler {
    private ConcurrentHashMap<Integer, Object> delayDrops;
    private boolean shownUpdateVersion = false;
    private DropProcessor dropProcessor;

    public LuckyTickHandler() {
        try {
            this.delayDrops = new ConcurrentHashMap();
            this.dropProcessor = new DropProcessor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        try {
            String line;
            URL url = new URL("http://www.minecraftascending.com/projects/lucky_block/download/version/version_log.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            int curLuckyVersion = Integer.valueOf(Lucky.VERSION.replace(".", ""));
            int curMinecraftVersion = Integer.valueOf(Lucky.MC_VERSION.replace(".", ""));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\|");
                int luckyVersion = Integer.valueOf(split[0].replace(".", ""));
                int minecraftVersion = Integer.valueOf(split[1].replace(".", ""));
                if (minecraftVersion < curMinecraftVersion || luckyVersion <= curLuckyVersion) continue;
                String message = split[2];
                IChatComponent ichatcomponent = IChatComponent.Serializer.func_150699_a((String)message);
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a(ChatComponentProcessor.func_179985_a(null, (IChatComponent)ichatcomponent, null));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            for (int i = 0; i > -1; ++i) {
                if (this.delayDrops.containsKey(i) && this.delayDrops.get(i) instanceof DelayLuckyDrop) {
                    DelayLuckyDrop delayDrop = (DelayLuckyDrop)this.delayDrops.get(i);
                    delayDrop.update();
                    if (delayDrop.finished()) {
                        this.delayDrops.remove(i);
                        if (this.delayDrops.containsKey(i + 1)) {
                            this.delayDrops.put(i, 0);
                        }
                    }
                }
                if (this.delayDrops.containsKey(i)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error processing delay drop");
            e.printStackTrace();
            this.delayDrops.clear();
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        try {
            if (this.delayDrops.size() > 0) {
                boolean saved = false;
                NBTTagList dropTags = new NBTTagList();
                for (int i = 0; i > -1; ++i) {
                    if (this.delayDrops.containsKey(i) && this.delayDrops.get(i) instanceof DelayLuckyDrop) {
                        DelayLuckyDrop delayDrop = (DelayLuckyDrop)this.delayDrops.get(i);
                        if (event.getChunk().func_177412_p().func_175726_f(delayDrop.getProcessData().getHarvestBlockPos()) == event.getChunk()) {
                            dropTags.func_74742_a((NBTBase)delayDrop.writeToNBT());
                            saved = true;
                        }
                    }
                    if (!this.delayDrops.containsKey(i)) break;
                }
                if (saved) {
                    event.getData().func_74782_a("LuckyBlockDelayDrops", (NBTBase)dropTags);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error saving chunk properties");
            e.printStackTrace();
            this.delayDrops.clear();
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        try {
            if (event.getData().func_74764_b("LuckyBlockDelayDrops")) {
                NBTTagList delayDropTags = event.getData().func_150295_c("LuckyBlockDelayDrops", 10);
                for (int i = 0; i < delayDropTags.func_74745_c(); ++i) {
                    DelayLuckyDrop delayDrop = new DelayLuckyDrop(Lucky.lucky_block.getDropProcessor(), null, 0L);
                    delayDrop.readFromNBT(delayDropTags.func_150305_b(i), event.getChunk().func_177412_p());
                    this.addDelayDrop(delayDrop);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error loading chunk properties");
            e.printStackTrace();
            this.delayDrops.clear();
        }
    }

    public void addDelayDrop(DropProcessor dropProcessor, DropProcessData processData, float delay) {
        this.addDelayDrop(new DelayLuckyDrop(dropProcessor, processData, (long)(delay * 20.0f)));
    }

    public void addDelayDrop(DelayLuckyDrop delayDrop) {
        for (int i = 0; i > -1; ++i) {
            if (this.delayDrops.containsKey(i) && this.delayDrops.get(i) instanceof DelayLuckyDrop) continue;
            this.delayDrops.put(i, delayDrop);
            break;
        }
    }
}

