/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.api;

import com.cout970.loader.api.model.IDynamicModel;
import com.cout970.loader.api.model.IStaticModel;
import com.cout970.loader.impl.CustomModelLoader;
import com.cout970.loader.impl.ObjTransformer;
import com.cout970.loader.impl.model.DynamicModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class ModelRegistry {
    private static final Set<String> registeredDomains = new HashSet<String>();
    public static final Map<ResourceLocation, IStaticModel> modelCache = new HashMap<ResourceLocation, IStaticModel>();

    public static void registerDomain(String domain) {
        registeredDomains.add(domain);
    }

    public static boolean isDomainRegistered(String domain) {
        return registeredDomains.contains(domain);
    }

    public static IStaticModel getStaticModel(ResourceLocation location) {
        return modelCache.get(location);
    }

    public static IDynamicModel getDynamicModel(ResourceLocation location) {
        IStaticModel model = modelCache.get(location);
        if (model == null) {
            return null;
        }
        return new DynamicModel(model.getModel());
    }

    public static IDynamicModel getDynamicObjModel(ResourceLocation location) {
        return ObjTransformer.INSTANCE.getModel(location);
    }

    static {
        CustomModelLoader.INSTANCE.init();
    }
}

