/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl;

import com.cout970.loader.api.ModelRegistry;
import com.cout970.loader.impl.bakery.UnbakedModel;
import com.cout970.loader.impl.storage.DefaultTransformationHandler;
import com.cout970.loader.impl.storage.MCMLoader;
import com.cout970.loader.impl.storage.TransformationHandler;
import com.cout970.loader.impl.texture.CustomTextureAtlasSprite;
import com.cout970.loader.impl.util.LoggerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/cout970/loader/impl/CustomModelLoader;", "Lnet/minecraftforge/client/model/ICustomModelLoader;", "()V", "MODEL_EXTENSION", "", "modelTextures", "", "Lnet/minecraft/util/ResourceLocation;", "getModelTextures", "()Ljava/util/List;", "resourceManager", "Lnet/minecraft/client/resources/IResourceManager;", "getResourceManager", "()Lnet/minecraft/client/resources/IResourceManager;", "setResourceManager", "(Lnet/minecraft/client/resources/IResourceManager;)V", "accepts", "", "modelLocation", "init", "", "loadModel", "Lnet/minecraftforge/client/model/IModel;", "onResourceManagerReload", "registerTextures", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "ModelLibrary-compileKotlin"})
public final class CustomModelLoader
implements ICustomModelLoader {
    @NotNull
    public static final String MODEL_EXTENSION = ".mcm";
    @NotNull
    public static IResourceManager resourceManager;
    @NotNull
    private static final List<ResourceLocation> modelTextures;
    public static final CustomModelLoader INSTANCE;

    @NotNull
    public final IResourceManager getResourceManager() {
        IResourceManager iResourceManager = resourceManager;
        if (iResourceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("resourceManager");
        }
        return iResourceManager;
    }

    public final void setResourceManager(@NotNull IResourceManager iResourceManager) {
        Intrinsics.checkParameterIsNotNull(iResourceManager, "<set-?>");
        resourceManager = iResourceManager;
    }

    @NotNull
    public final List<ResourceLocation> getModelTextures() {
        return modelTextures;
    }

    public final void init() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean accepts(@Nullable ResourceLocation modelLocation) {
        ResourceLocation resourceLocation = modelLocation;
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        return ModelRegistry.isDomainRegistered(resourceLocation.func_110624_b()) && StringsKt.endsWith$default(modelLocation.func_110623_a(), MODEL_EXTENSION, false, 2, null);
    }

    @Nullable
    public IModel loadModel(@NotNull ResourceLocation modelLocation) {
        TransformationHandler transformationHandler;
        ResourceLocation texture;
        Intrinsics.checkParameterIsNotNull(modelLocation, "modelLocation");
        IResourceManager iResourceManager = resourceManager;
        if (iResourceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("resourceManager");
        }
        IResource iResource = iResourceManager.func_110536_a(modelLocation);
        Intrinsics.checkExpressionValueIsNotNull(iResource, "resourceManager.getResource(modelLocation)");
        MCMLoader.ModelLoadResult model = MCMLoader.INSTANCE.load(iResource);
        if (model == null) {
            LoggerKt.error("Model " + modelLocation + " could not be loaded");
            return ModelLoaderRegistry.getMissingModel();
        }
        if (model.getHasTexture()) {
            modelTextures.add(modelLocation);
            texture = modelLocation;
        } else {
            texture = new ResourceLocation(modelLocation.func_110624_b(), StringsKt.replace$default(StringsKt.replace$default(modelLocation.func_110623_a(), MODEL_EXTENSION, ".png", false, 4, null), "models/", "textures/models", false, 4, null));
        }
        if ((transformationHandler = model.getTHandler()) == null) {
            transformationHandler = DefaultTransformationHandler.INSTANCE;
        }
        TransformationHandler transformationHandler2 = transformationHandler;
        return new UnbakedModel(modelLocation, model.getPart(), texture, transformationHandler2, model.getFilter());
    }

    @SubscribeEvent
    public final void registerTextures(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        for (ResourceLocation i : modelTextures) {
            TextureMap textureMap = event.getMap();
            String string = i.toString();
            String string2 = i.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "i.toString()");
            textureMap.setTextureEntry(string, (TextureAtlasSprite)new CustomTextureAtlasSprite(string2));
        }
    }

    public void func_110549_a(@Nullable IResourceManager resourceManager) {
        IResourceManager iResourceManager = resourceManager;
        if (iResourceManager == null) {
            Intrinsics.throwNpe();
        }
        CustomModelLoader.resourceManager = iResourceManager;
        modelTextures.clear();
        ModelRegistry.modelCache.clear();
    }

    private CustomModelLoader() {
        INSTANCE = this;
        modelTextures = CollectionsKt.mutableListOf(new ResourceLocation[0]);
    }

    static {
        new CustomModelLoader();
    }
}

