/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl;

import com.cout970.loader.api.model.IDynamicModel;
import com.cout970.loader.api.model.IModelPart;
import com.cout970.loader.impl.bakery.Quad;
import com.cout970.loader.impl.bakery.Vertex;
import com.cout970.loader.impl.model.DynamicModel;
import com.cout970.loader.impl.model.Group;
import com.cout970.loader.impl.model.ObjGroup;
import com.cout970.loader.impl.util.Vector2;
import com.cout970.loader.impl.util.Vector3;
import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\n\u0010\t\u001a\u00020\n*\u00020\u000bJ\n\u0010\f\u001a\u00020\r*\u00020\u000eJ\n\u0010\f\u001a\u00020\r*\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cout970/loader/impl/ObjTransformer;", "", "()V", "getModel", "Lcom/cout970/loader/api/model/IDynamicModel;", "res", "Lnet/minecraft/util/ResourceLocation;", "hasModel", "", "toVector2", "Lcom/cout970/loader/impl/util/Vector2;", "Lnet/minecraftforge/client/model/obj/OBJModel$TextureCoordinate;", "toVector3", "Lcom/cout970/loader/impl/util/Vector3;", "Ljavax/vecmath/Vector3f;", "Lnet/minecraftforge/client/model/obj/OBJModel$Normal;", "ModelLibrary-compileKotlin"})
public final class ObjTransformer {
    public static final ObjTransformer INSTANCE;

    public final boolean hasModel(@NotNull ResourceLocation res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return OBJLoader.INSTANCE.accepts(res);
    }

    @NotNull
    public final IDynamicModel getModel(@NotNull ResourceLocation res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        IModel iModel = OBJLoader.INSTANCE.loadModel(res);
        if (iModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.client.model.obj.OBJModel");
        }
        OBJModel model = (OBJModel)iModel;
        TRSRTransformation tRSRTransformation = TRSRTransformation.identity();
        Intrinsics.checkExpressionValueIsNotNull(tRSRTransformation, "TRSRTransformation.identity()");
        IModelState modelState = (IModelState)tRSRTransformation;
        Group root = new Group();
        Map map = model.getMatLib().getGroups();
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            String name = (String)entry2.getKey();
            Map.Entry entry3 = entry;
            OBJModel.Group g = (OBJModel.Group)entry3.getValue();
            Optional transform = modelState.apply(Optional.absent());
            List<Quad> quads = CollectionsKt.mutableListOf(new Quad[0]);
            for (OBJModel.Face f : g.applyTransform(transform)) {
                quads.add(new Quad(new Vertex(this.toVector3(f.getVertices()[0].getPos3()), this.toVector2(f.getVertices()[0].getTextureCoordinate()), this.toVector3(f.getVertices()[0].getNormal())), new Vertex(this.toVector3(f.getVertices()[1].getPos3()), this.toVector2(f.getVertices()[1].getTextureCoordinate()), this.toVector3(f.getVertices()[1].getNormal())), new Vertex(this.toVector3(f.getVertices()[2].getPos3()), this.toVector2(f.getVertices()[2].getTextureCoordinate()), this.toVector3(f.getVertices()[2].getNormal())), new Vertex(this.toVector3(f.getVertices()[3].getPos3()), this.toVector2(f.getVertices()[3].getTextureCoordinate()), this.toVector3(f.getVertices()[3].getNormal()))));
            }
            List<IModelPart> list = root.getSubParts();
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull(string, "name");
            list.add(new ObjGroup(string, quads));
        }
        return new DynamicModel(root);
    }

    @NotNull
    public final Vector3 toVector3(@NotNull Vector3f $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new Vector3(Float.valueOf($receiver.x), Float.valueOf($receiver.y), Float.valueOf($receiver.z));
    }

    @NotNull
    public final Vector3 toVector3(@NotNull OBJModel.Normal $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new Vector3(Float.valueOf($receiver.x), Float.valueOf($receiver.y), Float.valueOf($receiver.z));
    }

    @NotNull
    public final Vector2 toVector2(@NotNull OBJModel.TextureCoordinate $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new Vector2(Float.valueOf($receiver.u), Float.valueOf($receiver.v));
    }

    private ObjTransformer() {
        INSTANCE = this;
    }

    static {
        new ObjTransformer();
    }
}

