/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl.bakery;

import com.cout970.loader.impl.util.Vector2;
import com.cout970.loader.impl.util.Vector3;
import com.cout970.loader.impl.util.VectorsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020!J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020$H\u0002J\u0018\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020$H\u0002J.\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020!J\u0006\u00106\u001a\u00020\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000bR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 \u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000b\u00a8\u00067"}, d2={"Lcom/cout970/loader/impl/bakery/BakedQuadBuilder;", "", "side", "Lnet/minecraft/util/EnumFacing;", "texture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "(Lnet/minecraft/util/EnumFacing;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V", "FACE_BRIGHTNESS", "", "", "getFACE_BRIGHTNESS", "()Ljava/util/List;", "applyDiffuseLighting", "", "getApplyDiffuseLighting", "()Z", "setApplyDiffuseLighting", "(Z)V", "aux", "", "getAux", "()I", "setAux", "(I)V", "shade", "getShade", "setShade", "getSide", "()Lnet/minecraft/util/EnumFacing;", "getTexture", "()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "uv", "", "Lcom/cout970/loader/impl/util/Vector2;", "getUv", "vertex", "Lcom/cout970/loader/impl/util/Vector3;", "getVertex", "addVertex", "", "pos", "build", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "calculateNormal", "fillNormal", "data", "", "v1", "fillVertexData", "faceData", "storeIndex", "position", "Lnet/minecraft/util/math/Vec3d;", "shadeColor", "getFaceShadeColor", "ModelLibrary-compileKotlin"})
public final class BakedQuadBuilder {
    @NotNull
    private final List<Float> FACE_BRIGHTNESS;
    @NotNull
    private final List<Vector3> vertex;
    @NotNull
    private final List<Vector2> uv;
    private boolean shade;
    private boolean applyDiffuseLighting;
    private int aux;
    @NotNull
    private final EnumFacing side;
    @NotNull
    private final TextureAtlasSprite texture;

    @NotNull
    public final List<Float> getFACE_BRIGHTNESS() {
        return this.FACE_BRIGHTNESS;
    }

    @NotNull
    public final List<Vector3> getVertex() {
        return this.vertex;
    }

    @NotNull
    public final List<Vector2> getUv() {
        return this.uv;
    }

    public final boolean getShade() {
        return this.shade;
    }

    public final void setShade(boolean bl) {
        this.shade = bl;
    }

    public final boolean getApplyDiffuseLighting() {
        return this.applyDiffuseLighting;
    }

    public final void setApplyDiffuseLighting(boolean bl) {
        this.applyDiffuseLighting = bl;
    }

    public final int getAux() {
        return this.aux;
    }

    public final void setAux(int n) {
        this.aux = n;
    }

    public final void addVertex(@NotNull Vector3 pos, @NotNull Vector2 uv) {
        Intrinsics.checkParameterIsNotNull((Object)pos, "pos");
        Intrinsics.checkParameterIsNotNull(uv, "uv");
        if (this.aux >= 4) {
            throw (Throwable)new IllegalStateException("Unable to add more than 4 vertex to a BakedQuadBuilder");
        }
        this.vertex.add(pos);
        this.uv.add(uv);
        int n = this.aux;
        this.aux = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BakedQuad build() {
        int size$iv = 28;
        int[] result$iv22 = new int[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                int n3;
                void var6_6 = ++i$iv;
                void var10_8 = i$iv;
                int[] nArray = result$iv22;
                nArray[var10_8] = n3 = 0;
            } while (i$iv != n2);
        }
        int[] data = result$iv22;
        int color = !this.shade ? -1 : this.getFaceShadeColor();
        int result$iv22 = 0;
        n = 3;
        if (result$iv22 <= n) {
            while (true) {
                void i;
                this.fillVertexData(data, (int)i, this.vertex.get((int)i), color, this.uv.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
        this.fillNormal(data, this.calculateNormal());
        return new BakedQuad(data, -1, this.side, this.texture, this.applyDiffuseLighting, DefaultVertexFormats.field_176599_b);
    }

    private final Vector3 calculateNormal() {
        Vector3 line1 = this.vertex.get(1).minus(this.vertex.get(0));
        Vector3 line2 = this.vertex.get(2).minus(this.vertex.get(0));
        return VectorsKt.toVector3(line1.func_72431_c(line2).func_72432_b());
    }

    /*
     * WARNING - void declaration
     */
    private final void fillNormal(int[] data, Vector3 v1) {
        int x = (int)(v1.getX() * (double)127) & 0xFF;
        int y = (int)(v1.getY() * (double)127) & 0xFF;
        int z = (int)(v1.getZ() * (double)127) & 0xFF;
        int n = 0;
        int n2 = 3;
        if (n <= n2) {
            while (true) {
                void i;
                data[i * 7 + 6] = x | y << 8 | z << 16;
                if (i == n2) break;
                ++i;
            }
        }
    }

    public final void fillVertexData(@NotNull int[] faceData, int storeIndex, @NotNull Vec3d position, int shadeColor, @NotNull Vector2 uv) {
        Intrinsics.checkParameterIsNotNull(faceData, "faceData");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(uv, "uv");
        int l = storeIndex * 7;
        faceData[l + 0] = Float.floatToRawIntBits((float)position.field_72450_a);
        faceData[l + 1] = Float.floatToRawIntBits((float)position.field_72448_b);
        faceData[l + 2] = Float.floatToRawIntBits((float)position.field_72449_c);
        faceData[l + 3] = shadeColor;
        faceData[l + 4] = Float.floatToRawIntBits(uv.getXf());
        faceData[l + 5] = Float.floatToRawIntBits(uv.getYf());
    }

    public final int getFaceShadeColor() {
        float f = ((Number)this.FACE_BRIGHTNESS.get(this.side.func_176745_a())).floatValue();
        int i = MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
        int j = (int)0xFF000000L;
        return j | i << 16 | i << 8 | i;
    }

    @NotNull
    public final EnumFacing getSide() {
        return this.side;
    }

    @NotNull
    public final TextureAtlasSprite getTexture() {
        return this.texture;
    }

    public BakedQuadBuilder(@NotNull EnumFacing side, @NotNull TextureAtlasSprite texture) {
        Intrinsics.checkParameterIsNotNull(side, "side");
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        this.side = side;
        this.texture = texture;
        this.FACE_BRIGHTNESS = CollectionsKt.listOf(new Float[]{Float.valueOf(0.5f), Float.valueOf(1.0f), Float.valueOf(0.8f), Float.valueOf(0.8f), Float.valueOf(0.6f), Float.valueOf(0.6f)});
        this.vertex = CollectionsKt.mutableListOf(new Vector3[0]);
        this.uv = CollectionsKt.mutableListOf(new Vector2[0]);
        this.applyDiffuseLighting = true;
    }
}

