/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl.bakery;

import com.cout970.loader.api.model.IQuad;
import com.cout970.loader.impl.bakery.BakedQuadBuilder;
import com.cout970.loader.impl.bakery.Vertex;
import com.cout970.loader.impl.util.Vector2;
import com.cout970.loader.impl.util.VectorsKt;
import java.util.List;
import javax.vecmath.Matrix4f;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/cout970/loader/impl/bakery/Quad;", "Lcom/cout970/loader/api/model/IQuad;", "a", "Lcom/cout970/loader/impl/bakery/Vertex;", "b", "c", "d", "(Lcom/cout970/loader/impl/bakery/Vertex;Lcom/cout970/loader/impl/bakery/Vertex;Lcom/cout970/loader/impl/bakery/Vertex;Lcom/cout970/loader/impl/bakery/Vertex;)V", "getA", "()Lcom/cout970/loader/impl/bakery/Vertex;", "getB", "getC", "getD", "normal", "Lnet/minecraft/util/math/Vec3d;", "getNormal", "()Lnet/minecraft/util/math/Vec3d;", "vertex", "", "getVertex", "()Ljava/util/List;", "bake", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "sprite", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "flipUV", "rotate", "rp", "rot", "scale", "size", "transform", "matrix", "Ljavax/vecmath/Matrix4f;", "translate", "position", "ModelLibrary-compileKotlin"})
public final class Quad
implements IQuad {
    @NotNull
    private final Vertex a;
    @NotNull
    private final Vertex b;
    @NotNull
    private final Vertex c;
    @NotNull
    private final Vertex d;

    @Override
    @NotNull
    public BakedQuad bake(@NotNull TextureAtlasSprite sprite) {
        Intrinsics.checkParameterIsNotNull(sprite, "sprite");
        BakedQuadBuilder unbakedQuad = new BakedQuadBuilder(EnumFacing.UP, sprite);
        unbakedQuad.addVertex(this.a.getPos(), VectorsKt.map(this.a.getUv(), sprite));
        unbakedQuad.addVertex(this.b.getPos(), VectorsKt.map(this.b.getUv(), sprite));
        unbakedQuad.addVertex(this.c.getPos(), VectorsKt.map(this.c.getUv(), sprite));
        unbakedQuad.addVertex(this.d.getPos(), VectorsKt.map(this.d.getUv(), sprite));
        return unbakedQuad.build();
    }

    @NotNull
    public List<Vertex> getVertex() {
        return CollectionsKt.mutableListOf(this.a, this.b, this.c, this.d);
    }

    @Override
    @NotNull
    public Vec3d getNormal() {
        Vec3d vec1 = this.b.getPos().func_178788_d(this.a.getPos());
        Vec3d vec2 = this.c.getPos().func_178788_d(this.a.getPos());
        Vec3d normal = vec1.func_72431_c(vec2);
        Vec3d vec3d = normal.func_72432_b();
        Intrinsics.checkExpressionValueIsNotNull(vec3d, "normal.normalize()");
        return vec3d;
    }

    @Override
    @NotNull
    public Quad translate(@NotNull Vec3d position) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        return new Quad(this.a.translate(position), this.b.translate(position), this.c.translate(position), this.d.translate(position));
    }

    @Override
    @NotNull
    public Quad rotate(@NotNull Vec3d rp, @NotNull Vec3d rot) {
        Intrinsics.checkParameterIsNotNull(rp, "rp");
        Intrinsics.checkParameterIsNotNull(rot, "rot");
        return new Quad(this.a.rotate(rp, rot), this.b.rotate(rp, rot), this.c.rotate(rp, rot), this.d.rotate(rp, rot));
    }

    @Override
    @NotNull
    public Quad scale(@NotNull Vec3d size) {
        Intrinsics.checkParameterIsNotNull(size, "size");
        return new Quad(this.a.scale(size), this.b.scale(size), this.c.scale(size), this.d.scale(size));
    }

    @Override
    @NotNull
    public Quad flipUV() {
        return new Quad(new Vertex(this.a.getPos(), new Vector2(this.b.getUv().getX(), this.a.getUv().getY()), this.a.getNormal()), new Vertex(this.b.getPos(), new Vector2(this.a.getUv().getX(), this.b.getUv().getY()), this.b.getNormal()), new Vertex(this.c.getPos(), new Vector2(this.d.getUv().getX(), this.c.getUv().getY()), this.c.getNormal()), new Vertex(this.d.getPos(), new Vector2(this.c.getUv().getX(), this.d.getUv().getY()), this.d.getNormal()));
    }

    @Override
    @NotNull
    public Quad transform(@NotNull Matrix4f matrix) {
        Intrinsics.checkParameterIsNotNull(matrix, "matrix");
        return new Quad(this.a.transform(matrix), this.b.transform(matrix), this.c.transform(matrix), this.d.transform(matrix));
    }

    @NotNull
    public final Vertex getA() {
        return this.a;
    }

    @NotNull
    public final Vertex getB() {
        return this.b;
    }

    @NotNull
    public final Vertex getC() {
        return this.c;
    }

    @NotNull
    public final Vertex getD() {
        return this.d;
    }

    public Quad(@NotNull Vertex a, @NotNull Vertex b, @NotNull Vertex c, @NotNull Vertex d) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(d, "d");
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }
}

