/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl.bakery;

import com.cout970.loader.api.ModelRegistry;
import com.cout970.loader.api.model.IModelFilter;
import com.cout970.loader.api.model.IQuad;
import com.cout970.loader.impl.bakery.BakedModel;
import com.cout970.loader.impl.model.ModelPart;
import com.cout970.loader.impl.model.StaticModel;
import com.cout970.loader.impl.storage.TransformationHandler;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010 H\u0016J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010 H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/cout970/loader/impl/bakery/UnbakedModel;", "Lnet/minecraftforge/client/model/IModel;", "modelID", "Lnet/minecraft/util/ResourceLocation;", "model", "Lcom/cout970/loader/impl/model/ModelPart;", "texture", "tHandler", "Lcom/cout970/loader/impl/storage/TransformationHandler;", "filter", "Lcom/cout970/loader/api/model/IModelFilter;", "(Lnet/minecraft/util/ResourceLocation;Lcom/cout970/loader/impl/model/ModelPart;Lnet/minecraft/util/ResourceLocation;Lcom/cout970/loader/impl/storage/TransformationHandler;Lcom/cout970/loader/api/model/IModelFilter;)V", "getFilter", "()Lcom/cout970/loader/api/model/IModelFilter;", "getModel", "()Lcom/cout970/loader/impl/model/ModelPart;", "getModelID", "()Lnet/minecraft/util/ResourceLocation;", "getTHandler", "()Lcom/cout970/loader/impl/storage/TransformationHandler;", "getTexture", "bake", "Lnet/minecraft/client/renderer/block/model/IBakedModel;", "state", "Lnet/minecraftforge/common/model/IModelState;", "format", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "bakedTextureGetter", "Lcom/google/common/base/Function;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getDefaultState", "getDependencies", "", "getTextures", "ModelLibrary-compileKotlin"})
public final class UnbakedModel
implements IModel {
    @NotNull
    private final ResourceLocation modelID;
    @NotNull
    private final ModelPart model;
    @NotNull
    private final ResourceLocation texture;
    @NotNull
    private final TransformationHandler tHandler;
    @Nullable
    private final IModelFilter filter;

    @NotNull
    public IBakedModel bake(@NotNull IModelState state, @NotNull VertexFormat format, @NotNull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(format, "format");
        Intrinsics.checkParameterIsNotNull(bakedTextureGetter, "bakedTextureGetter");
        Object object = bakedTextureGetter.apply((Object)this.texture);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)object;
        List<BakedQuad> quads = CollectionsKt.mutableListOf(new BakedQuad[0]);
        TRSRTransformation transformation = (TRSRTransformation)state.apply(Optional.absent()).or((Object)TRSRTransformation.identity());
        for (IQuad i : this.filter != null ? this.model.getQuads(this.filter) : this.model.getQuads()) {
            Matrix4f matrix4f = transformation.getMatrix();
            Intrinsics.checkExpressionValueIsNotNull(matrix4f, "transformation.matrix");
            IQuad iQuad = i.transform(matrix4f);
            TextureAtlasSprite textureAtlasSprite = sprite;
            Intrinsics.checkExpressionValueIsNotNull(textureAtlasSprite, "sprite");
            quads.add(iQuad.bake(textureAtlasSprite));
        }
        TextureAtlasSprite textureAtlasSprite = sprite;
        Intrinsics.checkExpressionValueIsNotNull(textureAtlasSprite, "sprite");
        BakedModel baked = new BakedModel(quads, textureAtlasSprite, this.tHandler);
        ModelRegistry.modelCache.put(this.modelID, new StaticModel(this.model, (IBakedModel)baked));
        return (IBakedModel)baked;
    }

    @Nullable
    public Collection<ResourceLocation> getTextures() {
        return CollectionsKt.mutableListOf(new ResourceLocation[0]);
    }

    @NotNull
    public IModelState getDefaultState() {
        IModelState iModelState = (IModelState)TRSRTransformation.identity();
        Intrinsics.checkExpressionValueIsNotNull(iModelState, "TRSRTransformation.identity()");
        return iModelState;
    }

    @Nullable
    public Collection<ResourceLocation> getDependencies() {
        return CollectionsKt.mutableListOf(new ResourceLocation[0]);
    }

    @NotNull
    public final ResourceLocation getModelID() {
        return this.modelID;
    }

    @NotNull
    public final ModelPart getModel() {
        return this.model;
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    @NotNull
    public final TransformationHandler getTHandler() {
        return this.tHandler;
    }

    @Nullable
    public final IModelFilter getFilter() {
        return this.filter;
    }

    public UnbakedModel(@NotNull ResourceLocation modelID, @NotNull ModelPart model, @NotNull ResourceLocation texture, @NotNull TransformationHandler tHandler, @Nullable IModelFilter filter) {
        Intrinsics.checkParameterIsNotNull(modelID, "modelID");
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        Intrinsics.checkParameterIsNotNull(tHandler, "tHandler");
        this.modelID = modelID;
        this.model = model;
        this.texture = texture;
        this.tHandler = tHandler;
        this.filter = filter;
    }
}

