/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl.render;

import com.cout970.loader.api.model.ICachedModel;
import com.cout970.loader.api.model.IModelPart;
import com.cout970.loader.api.model.IQuad;
import com.cout970.loader.api.model.IVertex;
import com.cout970.loader.impl.render.CachedModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/cout970/loader/impl/render/ModelCacheFactory;", "", "()V", "createCachedModel", "Lcom/cout970/loader/api/model/ICachedModel;", "part", "Lcom/cout970/loader/api/model/IModelPart;", "textureSize", "", "renderToBuffer", "", "buffer", "Lnet/minecraft/client/renderer/VertexBuffer;", "renderUncached", "ModelLibrary-compileKotlin"})
public final class ModelCacheFactory {
    public static final ModelCacheFactory INSTANCE;

    @NotNull
    public final ICachedModel createCachedModel(@NotNull IModelPart part, int textureSize) {
        Intrinsics.checkParameterIsNotNull(part, "part");
        int id = GL11.glGenLists((int)1);
        GL11.glNewList((int)id, (int)4864);
        this.renderUncached(part, textureSize);
        GL11.glEndList();
        return new CachedModel(id);
    }

    private final void renderUncached(IModelPart part, int textureSize) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        VertexBuffer vertexBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull(vertexBuffer, "buffer");
        this.renderToBuffer(part, textureSize, vertexBuffer);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    /*
     * WARNING - void declaration
     */
    public final void renderToBuffer(@NotNull IModelPart part, int textureSize, @NotNull VertexBuffer buffer) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(part, "part");
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        Iterable iterable = part.getQuads();
        for (Object element$iv : $receiver$iv) {
            IQuad it = (IQuad)element$iv;
            for (IVertex i : it.getVertex()) {
                buffer.func_181662_b(i.getX(), i.getY(), i.getZ()).func_187315_a(i.getU() / (double)textureSize, i.getV() / (double)textureSize).func_181663_c((float)i.getNormalX(), (float)i.getNormalY(), (float)i.getNormalZ()).func_181675_d();
            }
        }
    }

    private ModelCacheFactory() {
        INSTANCE = this;
    }

    static {
        new ModelCacheFactory();
    }
}

