/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.loader.impl.storage;

import com.cout970.loader.api.model.IModelCube;
import com.cout970.loader.api.model.IModelFilter;
import com.cout970.loader.api.model.IModelGroup;
import com.cout970.loader.api.model.IModelPart;
import com.cout970.loader.impl.exception.ModelImportException;
import com.cout970.loader.impl.model.Cube;
import com.cout970.loader.impl.model.Group;
import com.cout970.loader.impl.model.ModelPart;
import com.cout970.loader.impl.storage.JsonModelFilter;
import com.cout970.loader.impl.storage.JsonTransformationHandler;
import com.cout970.loader.impl.storage.TransformationHandler;
import com.cout970.loader.impl.util.LoggerKt;
import com.cout970.loader.impl.util.MatrixHelperKt;
import com.cout970.loader.impl.util.Vector2;
import com.cout970.loader.impl.util.Vector3;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.resources.IResource;
import net.minecraftforge.common.model.TRSRTransformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u000f*\u00020\u0018H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/cout970/loader/impl/storage/MCMLoader;", "", "()V", "getFiltersFromJson", "Lcom/cout970/loader/api/model/IModelFilter;", "json", "Lcom/google/gson/JsonObject;", "getModelFromJson", "Lcom/cout970/loader/impl/model/ModelPart;", "Lcom/google/gson/JsonElement;", "getTHFromJson", "Lcom/cout970/loader/impl/storage/TransformationHandler;", "getTRSRTransformation", "Lnet/minecraftforge/common/model/TRSRTransformation;", "position", "Lcom/cout970/loader/impl/util/Vector3;", "rotation", "size", "load", "Lcom/cout970/loader/impl/storage/MCMLoader$ModelLoadResult;", "input", "Lnet/minecraft/client/resources/IResource;", "toVector2", "Lcom/cout970/loader/impl/util/Vector2;", "Lcom/google/gson/JsonArray;", "toVector3", "ModelLoadResult", "ModelLibrary-compileKotlin"})
public final class MCMLoader {
    public static final MCMLoader INSTANCE;

    @Nullable
    public final ModelLoadResult load(@NotNull IResource input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        try {
            ZipInputStream zip2 = new ZipInputStream(input.func_110527_b());
            ZipEntry entry = zip2.getNextEntry();
            ModelPart model = null;
            boolean texture = false;
            TransformationHandler THandler = null;
            IModelFilter filters = null;
            while (entry != null) {
                JsonElement json;
                JsonParser parser;
                InputStreamReader reader;
                if (Intrinsics.areEqual(entry.getName(), "model.json")) {
                    try {
                        reader = new InputStreamReader(zip2);
                        parser = new JsonParser();
                        json = parser.parse((Reader)reader);
                        JsonElement jsonElement = json.getAsJsonObject().get("Model");
                        Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json.asJsonObject.get(\"Model\")");
                        model = this.getModelFromJson(jsonElement);
                    }
                    catch (Exception e) {
                        LoggerKt.printStackTrace(e);
                    }
                } else if (Intrinsics.areEqual(entry.getName(), "texture.png")) {
                    texture = true;
                } else if (Intrinsics.areEqual(entry.getName(), "config.json")) {
                    try {
                        reader = new InputStreamReader(zip2);
                        parser = new JsonParser();
                        json = parser.parse((Reader)reader).getAsJsonObject();
                        if (json.has("Transformations")) {
                            JsonObject jsonObject = json.get("Transformations").getAsJsonObject();
                            Intrinsics.checkExpressionValueIsNotNull(jsonObject, "json[\"Transformations\"].asJsonObject");
                            THandler = this.getTHFromJson(jsonObject);
                        }
                        if (json.has("Filters")) {
                            JsonObject jsonObject = json.get("Filters").getAsJsonObject();
                            Intrinsics.checkExpressionValueIsNotNull(jsonObject, "json[\"Filters\"].asJsonObject");
                            filters = this.getFiltersFromJson(jsonObject);
                        }
                    }
                    catch (Exception e) {
                        LoggerKt.printStackTrace(e);
                    }
                } else {
                    LoggerKt.info("Skipping entry in model: " + input.func_177241_a() + ", entry name: " + entry.getName());
                }
                entry = zip2.getNextEntry();
            }
            zip2.close();
            if (model != null) {
                return new ModelLoadResult(model, texture, THandler, filters);
            }
        }
        catch (Exception e) {
            LoggerKt.info("Exception loading model: " + input.func_177241_a());
            LoggerKt.printStackTrace(e);
        }
        return null;
    }

    private final IModelFilter getFiltersFromJson(JsonObject json) {
        Predicate predicate2 = null;
        boolean inverted = false;
        if (json.has("NameContains")) {
            JsonArray array = json.get("NameContains").getAsJsonArray();
            List<String> list = CollectionsKt.mutableListOf(new String[0]);
            for (JsonElement i : array) {
                String string = i.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string, "i.asString");
                list.add(string);
            }
            predicate2 = (Predicate)new Predicate<IModelPart>(list){
                final /* synthetic */ List $list;

                /*
                 * WARNING - void declaration
                 */
                public final boolean apply(@Nullable IModelPart it) {
                    boolean bl;
                    if (it instanceof IModelCube || it instanceof IModelGroup) {
                        void var3_3;
                        String string;
                        if (it instanceof IModelCube) {
                            string = ((IModelCube)it).getName();
                        } else {
                            IModelPart iModelPart = it;
                            if (iModelPart == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.cout970.loader.api.model.IModelGroup");
                            }
                            string = ((IModelGroup)iModelPart).getName();
                        }
                        String name = string;
                        boolean contains = false;
                        for (String i : this.$list) {
                            if (!StringsKt.contains$default((CharSequence)name, i, false, 2, null)) continue;
                            contains = true;
                            break;
                        }
                        bl = var3_3;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$list = list;
                }
            };
        }
        if (json.has("Inverted")) {
            inverted = json.get("Inverted").getAsBoolean();
        }
        if (predicate2 != null) {
            if (inverted) {
                Predicate predicate3 = Predicates.not((Predicate)predicate2);
                Intrinsics.checkExpressionValueIsNotNull(predicate3, "Predicates.not(predicate)");
                return new JsonModelFilter((Predicate<IModelPart>)predicate3);
            }
            return new JsonModelFilter((Predicate<IModelPart>)predicate2);
        }
        return null;
    }

    private final TransformationHandler getTHFromJson(JsonObject json) {
        Vector3 size;
        Vector3 rotations;
        Vector3 pos;
        JsonObject obj;
        JsonTransformationHandler tHandler = new JsonTransformationHandler();
        if (json.has("NONE")) {
            obj = json.get("NONE").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setNONE(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("THIRD_PERSON_LEFT_HAND")) {
            obj = json.get("THIRD_PERSON_LEFT_HAND").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setTHIRD_PERSON_LEFT_HAND(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("THIRD_PERSON_RIGHT_HAND")) {
            obj = json.get("THIRD_PERSON_RIGHT_HAND").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setTHIRD_PERSON_RIGHT_HAND(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("FIRST_PERSON_LEFT_HAND")) {
            obj = json.get("FIRST_PERSON_LEFT_HAND").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setFIRST_PERSON_LEFT_HAND(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("FIRST_PERSON_RIGHT_HAND")) {
            obj = json.get("FIRST_PERSON_RIGHT_HAND").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setFIRST_PERSON_RIGHT_HAND(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("HEAD")) {
            obj = json.get("HEAD").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setHEAD(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("GUI")) {
            obj = json.get("GUI").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setGUI(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("GROUND")) {
            obj = json.get("GROUND").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setGROUND(this.getTRSRTransformation(pos, rotations, size));
        }
        if (json.has("FIXED")) {
            obj = json.get("FIXED").getAsJsonObject();
            pos = this.toVector3(obj.get("Position").getAsJsonArray());
            rotations = this.toVector3(obj.get("Rotation").getAsJsonArray()).toRadians();
            size = this.toVector3(obj.get("Size").getAsJsonArray());
            tHandler.setFIXED(this.getTRSRTransformation(pos, rotations, size));
        }
        return tHandler;
    }

    @NotNull
    public final TRSRTransformation getTRSRTransformation(@NotNull Vector3 position, @NotNull Vector3 rotation, @NotNull Vector3 size) {
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        Intrinsics.checkParameterIsNotNull((Object)rotation, "rotation");
        Intrinsics.checkParameterIsNotNull((Object)size, "size");
        Vector3 pos = position.times(MatrixHelperKt.PIXEL);
        Quat4f rot = new Quat4f();
        Quat4f aux = new Quat4f();
        AxisAngle4f xAxis = new AxisAngle4f(1.0f, 0.0f, 0.0f, rotation.getXf());
        AxisAngle4f yAxis = new AxisAngle4f(0.0f, 1.0f, 0.0f, rotation.getYf());
        AxisAngle4f zAxis = new AxisAngle4f(0.0f, 0.0f, 1.0f, rotation.getZf());
        rot.set(xAxis);
        aux.set(yAxis);
        rot.mul(aux);
        aux.set(zAxis);
        rot.mul(aux);
        return new TRSRTransformation(new Vector3f(pos.getXf(), pos.getYf(), pos.getZf()), rot, new Vector3f(size.getXf(), size.getYf(), size.getZf()), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
    }

    private final ModelPart getModelFromJson(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            JsonElement type = obj.get("Type");
            if (Intrinsics.areEqual(type.getAsString(), "Cube")) {
                Cube cube = new Cube();
                String string = obj.get("Name").getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string, "obj[\"Name\"].asString");
                cube.setName_(string);
                cube.setFlipUV_(obj.get("FlipUV").getAsBoolean());
                cube.setSize_(this.toVector3(obj.get("Size").getAsJsonArray()));
                cube.setPosition_(this.toVector3(obj.get("Position").getAsJsonArray()));
                cube.setRotationPoint_(this.toVector3(obj.get("RotationPoint").getAsJsonArray()));
                cube.setRotation_(this.toVector3(obj.get("Rotation").getAsJsonArray()));
                cube.setTextureOffset_(this.toVector2(obj.get("TextureOffset").getAsJsonArray()));
                return cube;
            }
            if (Intrinsics.areEqual(type.getAsString(), "Group")) {
                Group group = new Group();
                String string = obj.get("Name").getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string, "obj[\"Name\"].asString");
                group.setName_(string);
                group.setSize(this.toVector3(obj.get("Size").getAsJsonArray()));
                group.setPosition(this.toVector3(obj.get("Position").getAsJsonArray()));
                group.setRotation(this.toVector3(obj.get("Rotation").getAsJsonArray()));
                group.setRotationPoint(this.toVector3(obj.get("RotationPoint").getAsJsonArray()));
                JsonArray comps = obj.get("Components").getAsJsonArray();
                Iterator iterator2 = comps.iterator();
                while (iterator2.hasNext()) {
                    JsonElement i;
                    JsonElement jsonElement = i = (JsonElement)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement, "i");
                    ModelPart part = this.getModelFromJson(jsonElement);
                    group.getSubParts().add(part);
                    part.setParent(group);
                }
                return group;
            }
        }
        throw (Throwable)new ModelImportException("Invalid value at: " + json);
    }

    private final Vector3 toVector3(@NotNull JsonArray $receiver) {
        return new Vector3($receiver.get(0).getAsDouble(), $receiver.get(1).getAsDouble(), $receiver.get(2).getAsDouble());
    }

    private final Vector2 toVector2(@NotNull JsonArray $receiver) {
        return new Vector2($receiver.get(0).getAsDouble(), $receiver.get(1).getAsDouble());
    }

    private MCMLoader() {
        INSTANCE = this;
    }

    static {
        new MCMLoader();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cout970/loader/impl/storage/MCMLoader$ModelLoadResult;", "", "part", "Lcom/cout970/loader/impl/model/ModelPart;", "hasTexture", "", "tHandler", "Lcom/cout970/loader/impl/storage/TransformationHandler;", "filter", "Lcom/cout970/loader/api/model/IModelFilter;", "(Lcom/cout970/loader/impl/model/ModelPart;ZLcom/cout970/loader/impl/storage/TransformationHandler;Lcom/cout970/loader/api/model/IModelFilter;)V", "getFilter", "()Lcom/cout970/loader/api/model/IModelFilter;", "getHasTexture", "()Z", "getPart", "()Lcom/cout970/loader/impl/model/ModelPart;", "getTHandler", "()Lcom/cout970/loader/impl/storage/TransformationHandler;", "ModelLibrary-compileKotlin"})
    public static final class ModelLoadResult {
        @NotNull
        private final ModelPart part;
        private final boolean hasTexture;
        @Nullable
        private final TransformationHandler tHandler;
        @Nullable
        private final IModelFilter filter;

        @NotNull
        public final ModelPart getPart() {
            return this.part;
        }

        public final boolean getHasTexture() {
            return this.hasTexture;
        }

        @Nullable
        public final TransformationHandler getTHandler() {
            return this.tHandler;
        }

        @Nullable
        public final IModelFilter getFilter() {
            return this.filter;
        }

        public ModelLoadResult(@NotNull ModelPart part, boolean hasTexture, @Nullable TransformationHandler tHandler, @Nullable IModelFilter filter) {
            Intrinsics.checkParameterIsNotNull(part, "part");
            this.part = part;
            this.hasTexture = hasTexture;
            this.tHandler = tHandler;
            this.filter = filter;
        }
    }
}

