/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft;

import com.cout970.magneticraft.util.LoggerKt;
import com.cout970.magneticraft.util.MetadataKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.Timer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0013J\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/cout970/magneticraft/Debug;", "", "()V", "DEBUG", "", "getDEBUG", "()Z", "srcDir", "Ljava/io/File;", "getSrcDir", "()Ljava/io/File;", "setSrcDir", "(Ljava/io/File;)V", "createBlockModelJson", "", "name", "", "parent", "tex", "", "createItemJson", "texName", "preInit", "event", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "searchSourceDir", "configDir", "setTicksPerSecond", "tps", "", "magneticraft-compileKotlin"})
public final class Debug {
    private static final boolean DEBUG;
    @Nullable
    private static File srcDir;
    public static final Debug INSTANCE;

    public final boolean getDEBUG() {
        return DEBUG;
    }

    @Nullable
    public final File getSrcDir() {
        return srcDir;
    }

    public final void setSrcDir(@Nullable File file) {
        srcDir = file;
    }

    public final void preInit(@NotNull FMLPreInitializationEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        File file = event.getModConfigurationDirectory();
        Intrinsics.checkExpressionValueIsNotNull(file, "event.modConfigurationDirectory");
        srcDir = this.searchSourceDir(file);
        if (srcDir == null) {
            LoggerKt.error("Error trying to find the source directory", new Object[0]);
        }
    }

    @Nullable
    public final File searchSourceDir(@NotNull File configDir) {
        File temp;
        Intrinsics.checkParameterIsNotNull(configDir, "configDir");
        for (temp = configDir; temp != null && temp.isDirectory(); temp = temp.getParentFile()) {
            if (!new File(temp, "build.gradle").exists()) continue;
            return temp;
        }
        return temp;
    }

    public final void setTicksPerSecond(int tps) {
        Field timerField = Minecraft.class.getDeclaredField("timer");
        timerField.setAccessible(true);
        Object object = timerField.get(Minecraft.func_71410_x());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.util.Timer");
        }
        Timer timer = (Timer)object;
        Field tickField = Timer.class.getDeclaredField("ticksPerSecond");
        tickField.setAccessible(true);
        tickField.set(timer, Float.valueOf(tps));
    }

    public final void createItemJson(@NotNull String name, @NotNull String texName) {
        String path;
        File file;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(texName, "texName");
        StringBuilder stringBuilder = new StringBuilder();
        File file2 = srcDir;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        if ((file = new File(path = stringBuilder.append(file2.getAbsolutePath()).append("/src/main/resources/assets/" + MetadataKt.MODID + "/models/item/" + name + ".json").toString())).exists()) {
            return;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject json = new JsonObject();
        JsonObject textures = new JsonObject();
        json.addProperty("parent", "item/generated");
        textures.addProperty("layer0", "magneticraft:items/" + texName);
        json.add("textures", (JsonElement)textures);
        String string = gson.toJson((JsonElement)json);
        FileWriter writer = new FileWriter(file);
        writer.write(string);
        writer.close();
    }

    public final void createBlockModelJson(@NotNull String name, @NotNull String parent, @NotNull Map<String, String> tex) {
        String path;
        File file;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(parent, "parent");
        Intrinsics.checkParameterIsNotNull(tex, "tex");
        StringBuilder stringBuilder = new StringBuilder();
        File file2 = srcDir;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        if ((file = new File(path = stringBuilder.append(file2.getAbsolutePath()).append("/src/main/resources/assets/" + MetadataKt.MODID + "/models/block/" + name + ".json").toString())).exists()) {
            return;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject json = new JsonObject();
        JsonObject textures = new JsonObject();
        json.addProperty("parent", "block/" + parent);
        Map<String, String> map = tex;
        Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator2.next();
            String i = entry2.getKey();
            Map.Entry<String, String> entry3 = entry;
            String j = entry3.getValue();
            textures.addProperty(i, "magneticraft:blocks/" + j);
        }
        json.add("textures", (JsonElement)textures);
        String string = gson.toJson((JsonElement)json);
        FileWriter writer = new FileWriter(file);
        writer.write(string);
        writer.close();
    }

    private Debug() {
        INSTANCE = this;
        Object v = Launch.blackboard.get("fml.deobfuscatedEnvironment");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        DEBUG = (Boolean)v;
    }

    static {
        new Debug();
    }
}

