/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.energy;

import coffee.cypher.mcextlib.extensions.vectors.IntVectorsKt;
import com.cout970.magneticraft.api.energy.IElectricConnection;
import com.cout970.magneticraft.api.energy.IElectricNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cout970/magneticraft/api/internal/energy/ElectricConnection;", "Lcom/cout970/magneticraft/api/energy/IElectricConnection;", "firstNode", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "secondNode", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;Lcom/cout970/magneticraft/api/energy/IElectricNode;)V", "equals", "", "other", "", "getFirstNode", "getSecondNode", "getSeparationDistance", "", "hashCode", "", "iterate", "", "toString", "", "magneticraft-compileKotlin"})
public class ElectricConnection
implements IElectricConnection {
    private final IElectricNode firstNode;
    private final IElectricNode secondNode;

    @Override
    @NotNull
    public IElectricNode getFirstNode() {
        return this.firstNode;
    }

    @Override
    @NotNull
    public IElectricNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public double getSeparationDistance() {
        Vec3i vec3i = (Vec3i)this.firstNode.getPos();
        Vec3i vec3i2 = (Vec3i)this.secondNode.getPos();
        Intrinsics.checkExpressionValueIsNotNull(vec3i2, "secondNode.pos");
        return IntVectorsKt.getLength(IntVectorsKt.minus(vec3i, vec3i2));
    }

    @Override
    public void iterate() {
        if (this.firstNode.getWorld().field_72995_K) {
            return;
        }
        double R = (this.firstNode.getResistance() + this.secondNode.getResistance()) * this.getSeparationDistance();
        double C = 1.0 / (1.0 / this.firstNode.getCapacity() + 1.0 / this.secondNode.getCapacity());
        double V = (this.firstNode.getVoltage() * this.firstNode.getCapacity() + this.secondNode.getVoltage() * this.secondNode.getCapacity()) / (this.firstNode.getCapacity() + this.secondNode.getCapacity()) - this.secondNode.getVoltage();
        double I = (1.0 - Math.exp((double)-1 / (R * C))) * V * this.secondNode.getCapacity() / this.firstNode.getCapacity() * C * (double)2;
        this.firstNode.applyCurrent(-I);
        this.secondNode.applyCurrent(I);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof IElectricConnection) {
            return Intrinsics.areEqual(this.firstNode, ((IElectricConnection)other).getFirstNode()) && Intrinsics.areEqual(this.secondNode, ((IElectricConnection)other).getSecondNode());
        }
        return super.equals(other);
    }

    public int hashCode() {
        return (super.hashCode() * 31 + this.firstNode.hashCode()) * 31 + this.secondNode.hashCode();
    }

    @NotNull
    public String toString() {
        return "ElectricConnection(firstNode=" + this.firstNode + ", secondNode=" + this.secondNode + ")";
    }

    public ElectricConnection(@NotNull IElectricNode firstNode, @NotNull IElectricNode secondNode) {
        Intrinsics.checkParameterIsNotNull(firstNode, "firstNode");
        Intrinsics.checkParameterIsNotNull(secondNode, "secondNode");
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }
}

