/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.energy;

import com.cout970.magneticraft.api.energy.IElectricNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\bJ\u000e\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\bJ\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "worldGetter", "Lkotlin/Function0;", "Lnet/minecraft/world/World;", "posGetter", "Lnet/minecraft/util/math/BlockPos;", "resistance", "", "capacity", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;DD)V", "amperage", "amperageCount", "getAmperageCount", "()D", "setAmperageCount", "(D)V", "voltage", "applyCurrent", "", "current", "applyPower", "power", "simulated", "", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "equals", "other", "", "getAmperage", "getCapacity", "getPos", "getResistance", "getVoltage", "getWorld", "hashCode", "", "iterate", "serializeNBT", "setAmperage", "a", "setVoltage", "v", "toString", "", "magneticraft-compileKotlin"})
public class ElectricNode
implements IElectricNode {
    private double voltage;
    private double amperage;
    private double amperageCount;
    private final Function0<World> worldGetter;
    private final Function0<BlockPos> posGetter;
    private final double resistance;
    private final double capacity;

    public final double getAmperageCount() {
        return this.amperageCount;
    }

    public final void setAmperageCount(double d) {
        this.amperageCount = d;
    }

    @Override
    public double getAmperage() {
        return this.amperage;
    }

    public final void setAmperage(double a) {
        this.amperage = a;
    }

    @Override
    public double getVoltage() {
        return this.voltage;
    }

    public final void setVoltage(double v) {
        this.voltage = v;
    }

    @Override
    public double getResistance() {
        return this.resistance;
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.worldGetter.invoke();
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.posGetter.invoke();
    }

    @Override
    public void iterate() {
        this.amperage = this.amperageCount * 0.5;
        this.amperageCount = 0.0;
    }

    @Override
    public void applyCurrent(double current) {
        this.amperageCount += Math.abs(current);
        this.voltage += current / this.getCapacity();
    }

    @Override
    public double applyPower(double power, boolean simulated) {
        if (power > 0.0) {
            double squared = this.voltage * this.voltage + Math.abs(power) * (double)2;
            double diff = Math.sqrt(squared) - Math.abs(this.voltage);
            if (!simulated) {
                this.applyCurrent(diff);
            }
            return power;
        }
        double squared = this.voltage * this.voltage - Math.abs(power) * (double)2;
        double powerUsed = squared > 0.0 ? -power : this.voltage * this.voltage / (double)2;
        double diff = Math.sqrt(Math.max(squared, 0.0)) - Math.abs(this.voltage);
        if (!simulated) {
            this.applyCurrent(diff);
        }
        return powerUsed;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        this.voltage = nbt.func_74769_h("V");
        this.amperage = nbt.func_74769_h("A");
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound $receiver = nBTTagCompound;
        $receiver.func_74780_a("V", this.voltage);
        $receiver.func_74780_a("A", this.amperage);
        return nBTTagCompound;
    }

    @NotNull
    public String toString() {
        return "ElectricNode(world=" + this.worldGetter.invoke() + ", pos=" + this.posGetter.invoke() + ", resistance=" + this.resistance + ", capacity=" + this.capacity + ", voltage=" + this.voltage + ", amperage=" + this.amperage;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ElectricNode)) {
            return false;
        }
        if (Intrinsics.areEqual(this.worldGetter.invoke(), ((ElectricNode)other).worldGetter.invoke()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.posGetter.invoke(), ((ElectricNode)other).posGetter.invoke()) ^ true) {
            return false;
        }
        if (this.resistance != ((ElectricNode)other).resistance) {
            return false;
        }
        return this.capacity == ((ElectricNode)other).capacity;
    }

    public int hashCode() {
        int result = this.worldGetter.invoke().hashCode();
        result = 31 * result + this.posGetter.invoke().hashCode();
        result = 31 * result + ((Object)this.resistance).hashCode();
        result = 31 * result + ((Object)this.capacity).hashCode();
        return result;
    }

    public ElectricNode(@NotNull Function0<? extends World> worldGetter, @NotNull Function0<? extends BlockPos> posGetter, double resistance, double capacity) {
        Intrinsics.checkParameterIsNotNull(worldGetter, "worldGetter");
        Intrinsics.checkParameterIsNotNull(posGetter, "posGetter");
        this.worldGetter = worldGetter;
        this.posGetter = posGetter;
        this.resistance = resistance;
        this.capacity = capacity;
    }

    public /* synthetic */ ElectricNode(Function0 function0, Function0 function02, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 0.001;
        }
        if ((n & 8) != 0) {
            d2 = 1.0;
        }
        this(function0, function02, d, d2);
    }
}

