/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.registries.machines.tablesieve;

import com.cout970.magneticraft.api.internal.registries.machines.tablesieve.TableSieveRecipe;
import com.cout970.magneticraft.api.registries.machines.tablesieve.ITableSieveRecipe;
import com.cout970.magneticraft.api.registries.machines.tablesieve.ITableSieveRecipeManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/cout970/magneticraft/api/internal/registries/machines/tablesieve/TableSieveRecipeManager;", "Lcom/cout970/magneticraft/api/registries/machines/tablesieve/ITableSieveRecipeManager;", "()V", "recipes", "Ljava/util/LinkedList;", "Lcom/cout970/magneticraft/api/registries/machines/tablesieve/ITableSieveRecipe;", "createRecipe", "input", "Lnet/minecraft/item/ItemStack;", "primaryOutput", "secondaryOutput", "prob", "", "oreDict", "", "findRecipe", "stack", "getRecipes", "", "registerRecipe", "recipe", "magneticraft-compileKotlin"})
public final class TableSieveRecipeManager
implements ITableSieveRecipeManager {
    private static final LinkedList<ITableSieveRecipe> recipes;
    public static final TableSieveRecipeManager INSTANCE;

    @Override
    @Nullable
    public ITableSieveRecipe findRecipe(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        for (ITableSieveRecipe rec : recipes) {
            if (!rec.matches(stack)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public boolean registerRecipe(@NotNull ITableSieveRecipe recipe) {
        Intrinsics.checkParameterIsNotNull(recipe, "recipe");
        ItemStack itemStack = recipe.getInput();
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "recipe.input");
        if (this.findRecipe(itemStack) != null) {
            return false;
        }
        recipes.add(recipe);
        return true;
    }

    @Override
    @NotNull
    public List<ITableSieveRecipe> getRecipes() {
        List<ITableSieveRecipe> list = Collections.synchronizedList((List)recipes);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.synchronizedList(recipes)");
        return list;
    }

    @Override
    @NotNull
    public ITableSieveRecipe createRecipe(@NotNull ItemStack input, @NotNull ItemStack primaryOutput, @NotNull ItemStack secondaryOutput, float prob, boolean oreDict) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        Intrinsics.checkParameterIsNotNull(primaryOutput, "primaryOutput");
        Intrinsics.checkParameterIsNotNull(secondaryOutput, "secondaryOutput");
        return new TableSieveRecipe(input, primaryOutput, secondaryOutput, prob, oreDict);
    }

    private TableSieveRecipeManager() {
        INSTANCE = this;
        recipes = new LinkedList();
    }

    static {
        new TableSieveRecipeManager();
    }
}

