/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.config;

import com.cout970.magneticraft.config.ConfigValue;
import com.cout970.magneticraft.config.GaussOreConfig;
import com.cout970.magneticraft.config.OreConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001e\u0010\u0015\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001e\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001e\u0010!\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR\u001e\u0010$\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000f\"\u0004\b&\u0010\u0011R\u001e\u0010'\u001a\u00020(8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0006\"\u0004\b/\u0010\bR\u001e\u00100\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u000f\"\u0004\b2\u0010\u0011R\u001e\u00103\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0006\"\u0004\b5\u0010\b\u00a8\u00066"}, d2={"Lcom/cout970/magneticraft/config/Config;", "", "()V", "airlockAirCost", "", "getAirlockAirCost", "()D", "setAirlockAirCost", "(D)V", "airlockBubbleCost", "getAirlockBubbleCost", "setAirlockBubbleCost", "cobaltOre", "Lcom/cout970/magneticraft/config/OreConfig;", "getCobaltOre", "()Lcom/cout970/magneticraft/config/OreConfig;", "setCobaltOre", "(Lcom/cout970/magneticraft/config/OreConfig;)V", "copperOre", "getCopperOre", "setCopperOre", "electricFurnaceMaxConsumption", "getElectricFurnaceMaxConsumption", "setElectricFurnaceMaxConsumption", "heatUnitCelsius", "", "getHeatUnitCelsius", "()Z", "setHeatUnitCelsius", "(Z)V", "hydraulicPressConsumption", "getHydraulicPressConsumption", "setHydraulicPressConsumption", "incendiaryGeneratorMaxProduction", "getIncendiaryGeneratorMaxProduction", "setIncendiaryGeneratorMaxProduction", "leadOre", "getLeadOre", "setLeadOre", "limestone", "Lcom/cout970/magneticraft/config/GaussOreConfig;", "getLimestone", "()Lcom/cout970/magneticraft/config/GaussOreConfig;", "setLimestone", "(Lcom/cout970/magneticraft/config/GaussOreConfig;)V", "solarPanelMaxProduction", "getSolarPanelMaxProduction", "setSolarPanelMaxProduction", "tungstenOre", "getTungstenOre", "setTungstenOre", "wattsToTesla", "getWattsToTesla", "setWattsToTesla", "magneticraft-compileKotlin"})
public final class Config {
    @ConfigValue(category="general.ores", comment="Copper ore")
    @NotNull
    private static OreConfig copperOre;
    @ConfigValue(category="general.ores", comment="Lead ore")
    @NotNull
    private static OreConfig leadOre;
    @ConfigValue(category="general.ores", comment="Cobalt ore")
    @NotNull
    private static OreConfig cobaltOre;
    @ConfigValue(category="general.ores", comment="Tungsten ore")
    @NotNull
    private static OreConfig tungstenOre;
    @ConfigValue(category="general.ores", comment="Limestone")
    @NotNull
    private static GaussOreConfig limestone;
    @ConfigValue(category="general.energy", comment="Conversion ratio between Watts and Tesla, NOTE: all the values in the config about energy are in Watts")
    private static double wattsToTesla;
    @ConfigValue(category="general.energy", comment="Incendiary Generator Energy Production")
    private static double incendiaryGeneratorMaxProduction;
    @ConfigValue(category="general.energy", comment="Electric Furnace Max Consumption")
    private static double electricFurnaceMaxConsumption;
    @ConfigValue(category="general.energy", comment="Airlock: maintenance cost per Air Bubble every 40 ticks (2 sec)")
    private static double airlockBubbleCost;
    @ConfigValue(category="general.energy", comment="Airlock: cost of removing a water block")
    private static double airlockAirCost;
    @ConfigValue(category="general.energy", comment="Hydraulic Press Consumption")
    private static double hydraulicPressConsumption;
    @ConfigValue(category="general.energy", comment="Solar Panel Production")
    private static double solarPanelMaxProduction;
    @ConfigValue(category="general", comment="Unit of Heat, Celsius or Fahrenheit")
    private static boolean heatUnitCelsius;
    public static final Config INSTANCE;

    @NotNull
    public final OreConfig getCopperOre() {
        return copperOre;
    }

    public final void setCopperOre(@NotNull OreConfig oreConfig) {
        Intrinsics.checkParameterIsNotNull(oreConfig, "<set-?>");
        copperOre = oreConfig;
    }

    @NotNull
    public final OreConfig getLeadOre() {
        return leadOre;
    }

    public final void setLeadOre(@NotNull OreConfig oreConfig) {
        Intrinsics.checkParameterIsNotNull(oreConfig, "<set-?>");
        leadOre = oreConfig;
    }

    @NotNull
    public final OreConfig getCobaltOre() {
        return cobaltOre;
    }

    public final void setCobaltOre(@NotNull OreConfig oreConfig) {
        Intrinsics.checkParameterIsNotNull(oreConfig, "<set-?>");
        cobaltOre = oreConfig;
    }

    @NotNull
    public final OreConfig getTungstenOre() {
        return tungstenOre;
    }

    public final void setTungstenOre(@NotNull OreConfig oreConfig) {
        Intrinsics.checkParameterIsNotNull(oreConfig, "<set-?>");
        tungstenOre = oreConfig;
    }

    @NotNull
    public final GaussOreConfig getLimestone() {
        return limestone;
    }

    public final void setLimestone(@NotNull GaussOreConfig gaussOreConfig) {
        Intrinsics.checkParameterIsNotNull(gaussOreConfig, "<set-?>");
        limestone = gaussOreConfig;
    }

    public final double getWattsToTesla() {
        return wattsToTesla;
    }

    public final void setWattsToTesla(double d) {
        wattsToTesla = d;
    }

    public final double getIncendiaryGeneratorMaxProduction() {
        return incendiaryGeneratorMaxProduction;
    }

    public final void setIncendiaryGeneratorMaxProduction(double d) {
        incendiaryGeneratorMaxProduction = d;
    }

    public final double getElectricFurnaceMaxConsumption() {
        return electricFurnaceMaxConsumption;
    }

    public final void setElectricFurnaceMaxConsumption(double d) {
        electricFurnaceMaxConsumption = d;
    }

    public final double getAirlockBubbleCost() {
        return airlockBubbleCost;
    }

    public final void setAirlockBubbleCost(double d) {
        airlockBubbleCost = d;
    }

    public final double getAirlockAirCost() {
        return airlockAirCost;
    }

    public final void setAirlockAirCost(double d) {
        airlockAirCost = d;
    }

    public final double getHydraulicPressConsumption() {
        return hydraulicPressConsumption;
    }

    public final void setHydraulicPressConsumption(double d) {
        hydraulicPressConsumption = d;
    }

    public final double getSolarPanelMaxProduction() {
        return solarPanelMaxProduction;
    }

    public final void setSolarPanelMaxProduction(double d) {
        solarPanelMaxProduction = d;
    }

    public final boolean getHeatUnitCelsius() {
        return heatUnitCelsius;
    }

    public final void setHeatUnitCelsius(boolean bl) {
        heatUnitCelsius = bl;
    }

    private Config() {
        INSTANCE = this;
        copperOre = new OreConfig(10, 8, 80, 30, false, 16, null);
        leadOre = new OreConfig(9, 8, 80, 30, false, 16, null);
        cobaltOre = new OreConfig(8, 8, 80, 30, false, 16, null);
        tungstenOre = new OreConfig(7, 8, 80, 30, false, 16, null);
        limestone = new GaussOreConfig(0, 5, 0.9f, 3, 50, 64, 16, false, 128, null);
        wattsToTesla = 1.0;
        incendiaryGeneratorMaxProduction = 40.0;
        electricFurnaceMaxConsumption = 20.0;
        airlockBubbleCost = 1.0;
        airlockAirCost = 2.0;
        hydraulicPressConsumption = 40.0;
        solarPanelMaxProduction = 10.0;
        heatUnitCelsius = true;
    }

    static {
        new Config();
    }
}

