/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.config;

import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.config.Config;
import com.cout970.magneticraft.config.ConfigValue;
import com.cout970.magneticraft.config.ConfigValueType;
import com.cout970.magneticraft.config.ForgeConfiguration;
import com.cout970.magneticraft.config.GaussOreConfig;
import com.cout970.magneticraft.config.IConfig;
import com.cout970.magneticraft.config.OreConfig;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler;", "", "()V", "config", "Lcom/cout970/magneticraft/config/IConfig;", "getConfig", "()Lcom/cout970/magneticraft/config/IConfig;", "instance", "Lcom/cout970/magneticraft/config/Config;", "getInstance", "()Lcom/cout970/magneticraft/config/Config;", "wrappers", "", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "getWrappers", "()Ljava/util/List;", "load", "", "loadFields", "read", "save", "BooleanFieldWrapper", "DoubleFieldWrapper", "FieldWrapper", "FloatFieldWrapper", "GaussOreConfigFieldWrapper", "IntegerFieldWrapper", "OreConfigFieldWrapper", "StringFieldWrapper", "magneticraft-compileKotlin"})
public final class ConfigHandler {
    @NotNull
    private static final Config instance;
    @NotNull
    private static final List<FieldWrapper> wrappers;
    @NotNull
    private static final IConfig config;
    public static final ConfigHandler INSTANCE;

    @NotNull
    public final Config getInstance() {
        return instance;
    }

    @NotNull
    public final List<FieldWrapper> getWrappers() {
        return wrappers;
    }

    @NotNull
    public final IConfig getConfig() {
        return config;
    }

    public final void save() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public final void load() {
        config.load();
    }

    public final void read() {
        for (FieldWrapper fw : wrappers) {
            try {
                fw.read(this);
            }
            catch (IllegalAccessException e) {
                Throwable throwable = e;
                Throwable throwable2 = throwable;
                if (throwable2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                }
                throwable2.printStackTrace();
            }
        }
    }

    public final void loadFields() {
        Class<?> clazz = instance.getClass();
        Field[] fields = clazz.getDeclaredFields();
        wrappers.clear();
        for (int i = 0; i < fields.length; ++i) {
            FieldWrapper fieldWrapper;
            Field f = fields[i];
            if (!f.isAnnotationPresent(ConfigValue.class)) continue;
            f.setAccessible(true);
            ConfigValue annotation = f.getAnnotation(ConfigValue.class);
            Object object = f.getType();
            if (Intrinsics.areEqual(object, Integer.TYPE)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new IntegerFieldWrapper(field, configValue);
            } else if (Intrinsics.areEqual(object, Double.TYPE)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new DoubleFieldWrapper(field, configValue);
            } else if (Intrinsics.areEqual(object, Boolean.TYPE)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new BooleanFieldWrapper(field, configValue);
            } else if (Intrinsics.areEqual(object, String.class)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new StringFieldWrapper(field, configValue);
            } else if (Intrinsics.areEqual(object, Float.TYPE)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new FloatFieldWrapper(field, configValue);
            } else if (Intrinsics.areEqual(object, OreConfig.class)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new OreConfigFieldWrapper(field, configValue);
            } else if (Intrinsics.areEqual(object, GaussOreConfig.class)) {
                Field field = f;
                Intrinsics.checkExpressionValueIsNotNull(field, "f");
                ConfigValue configValue = annotation;
                Intrinsics.checkExpressionValueIsNotNull(configValue, "annotation");
                fieldWrapper = new GaussOreConfigFieldWrapper(field, configValue);
            } else {
                fieldWrapper = null;
            }
            if (fieldWrapper == null) continue;
            object = fieldWrapper;
            FieldWrapper it = (FieldWrapper)object;
            Collection collection = wrappers;
            collection.add(it);
        }
    }

    private ConfigHandler() {
        INSTANCE = this;
        instance = Config.INSTANCE;
        wrappers = CollectionsKt.mutableListOf(new FieldWrapper[0]);
        config = new ForgeConfiguration(Magneticraft.INSTANCE.getConfigFile());
        this.loadFields();
    }

    static {
        new ConfigHandler();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "type", "Lcom/cout970/magneticraft/config/ConfigValueType;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;Lcom/cout970/magneticraft/config/ConfigValueType;)V", "getAnnotation", "()Lcom/cout970/magneticraft/config/ConfigValue;", "getField", "()Ljava/lang/reflect/Field;", "getType", "()Lcom/cout970/magneticraft/config/ConfigValueType;", "getKey", "", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static abstract class FieldWrapper {
        @NotNull
        private final Field field;
        @NotNull
        private final ConfigValue annotation;
        @NotNull
        private final ConfigValueType type;

        @NotNull
        public final String getKey() {
            if (Intrinsics.areEqual(this.annotation.key(), "")) {
                String string = this.field.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "field.name");
                return string;
            }
            return this.annotation.key();
        }

        public abstract void read(@NotNull ConfigHandler var1);

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @NotNull
        public final ConfigValue getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public final ConfigValueType getType() {
            return this.type;
        }

        public FieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation, @NotNull ConfigValueType type) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            Intrinsics.checkParameterIsNotNull((Object)type, "type");
            this.field = field;
            this.annotation = annotation;
            this.type = type;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$IntegerFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class IntegerFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            int value = handler.getConfig().getInteger(this.getAnnotation().category(), this.getKey(), this.getField().getInt(handler.getInstance()), this.getAnnotation().comment());
            this.getField().set(handler.getInstance(), value);
        }

        public IntegerFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.INT);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$DoubleFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class DoubleFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            double value = handler.getConfig().getDouble(this.getAnnotation().category(), this.getKey(), this.getField().getDouble(handler.getInstance()), this.getAnnotation().comment());
            this.getField().set(handler.getInstance(), value);
        }

        public DoubleFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.DOUBLE);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$FloatFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class FloatFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            double value = handler.getConfig().getDouble(this.getAnnotation().category(), this.getKey(), this.getField().getFloat(handler.getInstance()), this.getAnnotation().comment());
            this.getField().set(handler.getInstance(), Float.valueOf((float)value));
        }

        public FloatFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.DOUBLE);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$BooleanFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class BooleanFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            boolean value = handler.getConfig().getBoolean(this.getAnnotation().category(), this.getKey(), this.getField().getBoolean(handler.getInstance()), this.getAnnotation().comment());
            this.getField().set(handler.getInstance(), value);
        }

        public BooleanFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.BOOLEAN);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$StringFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class StringFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            Object object = this.getField().get(handler.getInstance());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String value = handler.getConfig().getString(this.getAnnotation().category(), this.getKey(), (String)object, this.getAnnotation().comment());
            this.getField().set(handler.getInstance(), value);
        }

        public StringFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.STRING);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$OreConfigFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class OreConfigFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            String category = this.getAnnotation().category() + "." + StringsKt.replace$default(this.getKey(), "Ore", "", false, 4, null);
            Object object = this.getField().get(handler.getInstance());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.OreConfig");
            }
            boolean active = handler.getConfig().getBoolean(category, "active", ((OreConfig)object).getActive(), "If " + this.getAnnotation().comment() + " should be generated or not");
            Object object2 = this.getField().get(handler.getInstance());
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.OreConfig");
            }
            int chunk = handler.getConfig().getInteger(category, "chunkAmount", ((OreConfig)object2).getChunkAmount(), "Amount of " + this.getAnnotation().comment() + " per chunk");
            Object object3 = this.getField().get(handler.getInstance());
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.OreConfig");
            }
            int vein = handler.getConfig().getInteger(category, "veinAmount", ((OreConfig)object3).getVeinAmount(), "Amount of " + this.getAnnotation().comment() + " per vein");
            Object object4 = this.getField().get(handler.getInstance());
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.OreConfig");
            }
            int max = handler.getConfig().getInteger(category, "maxLevel", ((OreConfig)object4).getMaxLevel(), "Max level to generate the ore");
            Object object5 = this.getField().get(handler.getInstance());
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.OreConfig");
            }
            int min = handler.getConfig().getInteger(category, "minLevel", ((OreConfig)object5).getMinLevel(), "Min level to generate the ore");
            this.getField().set(handler.getInstance(), new OreConfig(chunk, vein, max, min, active));
        }

        public OreConfigFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.ORE);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/config/ConfigHandler$GaussOreConfigFieldWrapper;", "Lcom/cout970/magneticraft/config/ConfigHandler$FieldWrapper;", "field", "Ljava/lang/reflect/Field;", "annotation", "Lcom/cout970/magneticraft/config/ConfigValue;", "(Ljava/lang/reflect/Field;Lcom/cout970/magneticraft/config/ConfigValue;)V", "read", "", "handler", "Lcom/cout970/magneticraft/config/ConfigHandler;", "magneticraft-compileKotlin"})
    public static final class GaussOreConfigFieldWrapper
    extends FieldWrapper {
        @Override
        public void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull(handler, "handler");
            String category = this.getAnnotation().category() + "." + StringsKt.replace$default(this.getKey(), "Ore", "", false, 4, null);
            Object object = this.getField().get(handler.getInstance());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            boolean active = handler.getConfig().getBoolean(category, "active", ((GaussOreConfig)object).getActive(), "If " + this.getAnnotation().comment() + " should be generated or not");
            Object object2 = this.getField().get(handler.getInstance());
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            int chunk = handler.getConfig().getInteger(category, "chunkAmount", ((GaussOreConfig)object2).getChunkAmount(), "Amount of " + this.getAnnotation().comment() + " per chunk");
            Object object3 = this.getField().get(handler.getInstance());
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            int vein = handler.getConfig().getInteger(category, "veinAmount", ((GaussOreConfig)object3).getVeinAmount(), "Amount of " + this.getAnnotation().comment() + " per vein");
            Object object4 = this.getField().get(handler.getInstance());
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            int maxY = handler.getConfig().getInteger(category, "maxLevel", ((GaussOreConfig)object4).getMaxLevel(), "Max level to generate the ore");
            Object object5 = this.getField().get(handler.getInstance());
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            int minY = handler.getConfig().getInteger(category, "minLevel", ((GaussOreConfig)object5).getMinLevel(), "Min level to generate the ore");
            Object object6 = this.getField().get(handler.getInstance());
            if (object6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            int minVeins = handler.getConfig().getInteger(category, "minAmount", ((GaussOreConfig)object6).getMinAmountPerChunk(), "Min amount of veins of ore per chunk");
            Object object7 = this.getField().get(handler.getInstance());
            if (object7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            int maxVeins = handler.getConfig().getInteger(category, "maxAmount", ((GaussOreConfig)object7).getMaxAmountPerChunk(), "Max amount of veins of ore per chunk");
            Object object8 = this.getField().get(handler.getInstance());
            if (object8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.config.GaussOreConfig");
            }
            float deviation = (float)handler.getConfig().getDouble(category, "maxAmount", ((GaussOreConfig)object8).getDeviation(), "Standard deviation of the amount of veins per chunk");
            this.getField().set(handler.getInstance(), new GaussOreConfig(minVeins, maxVeins, deviation, chunk, vein, maxY, minY, active));
        }

        public GaussOreConfigFieldWrapper(@NotNull Field field, @NotNull ConfigValue annotation) {
            Intrinsics.checkParameterIsNotNull(field, "field");
            Intrinsics.checkParameterIsNotNull(annotation, "annotation");
            super(field, annotation, ConfigValueType.ORE);
        }
    }
}

