/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.gui.client.components;

import com.cout970.magneticraft.gui.client.IComponent;
import com.cout970.magneticraft.gui.client.IGui;
import com.cout970.magneticraft.gui.client.components.CompVerticalBarKt;
import com.cout970.magneticraft.util.fluid.Tank;
import com.cout970.magneticraft.util.misc.Box;
import com.cout970.magneticraft.util.vector.Vec2d;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/cout970/magneticraft/gui/client/components/CompFluidBar;", "Lcom/cout970/magneticraft/gui/client/IComponent;", "pos", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "tank", "Lcom/cout970/magneticraft/util/fluid/Tank;", "(Lcom/cout970/magneticraft/util/vector/Vec2d;Lcom/cout970/magneticraft/util/fluid/Tank;)V", "box", "Lcom/cout970/magneticraft/util/misc/Box;", "getBox", "()Lcom/cout970/magneticraft/util/misc/Box;", "gui", "Lcom/cout970/magneticraft/gui/client/IGui;", "getGui", "()Lcom/cout970/magneticraft/gui/client/IGui;", "setGui", "(Lcom/cout970/magneticraft/gui/client/IGui;)V", "getPos", "()Lcom/cout970/magneticraft/util/vector/Vec2d;", "getTank", "()Lcom/cout970/magneticraft/util/fluid/Tank;", "drawFirstLayer", "", "mouse", "partialTicks", "", "drawSecondLayer", "magneticraft-compileKotlin"})
public final class CompFluidBar
implements IComponent {
    @NotNull
    private final Box box;
    @NotNull
    public IGui gui;
    @NotNull
    private final Vec2d pos;
    @NotNull
    private final Tank tank;

    @Override
    @NotNull
    public Box getBox() {
        return this.box;
    }

    @Override
    @NotNull
    public IGui getGui() {
        IGui iGui = this.gui;
        if (iGui == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gui");
        }
        return iGui;
    }

    @Override
    public void setGui(@NotNull IGui iGui) {
        Intrinsics.checkParameterIsNotNull(iGui, "<set-?>");
        this.gui = iGui;
    }

    @Override
    public void drawFirstLayer(@NotNull Vec2d mouse, float partialTicks) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        if (this.tank.getClientFluidAmount() > 0) {
            IGui iGui = this.getGui();
            IGui $receiver = iGui;
            Fluid fluid = FluidRegistry.getFluid((String)this.tank.getClientFluidName());
            if (fluid != null) {
                int level = this.tank.getClientFluidAmount() * 48 / this.tank.getCapacity();
                TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
                if (texture != null) {
                    ResourceLocation resourceLocation = TextureMap.field_110575_b;
                    Intrinsics.checkExpressionValueIsNotNull(resourceLocation, "TextureMap.LOCATION_BLOCKS_TEXTURE");
                    $receiver.bindTexture(resourceLocation);
                    GlStateManager.func_179147_l();
                    $receiver.drawTexture(new Box(new Vec2d(this.getBox().getPos().getX(), this.getBox().getPos().getY() + (double)48 - (double)level), new Vec2d((Number)this.getBox().getSize().getX(), (Number)level)), texture);
                    GlStateManager.func_179084_k();
                    $receiver.bindTexture(CompVerticalBarKt.getBAR_TEXTURES());
                    $receiver.drawScaledTexture(new Box(this.getBox().getPos(), this.getBox().getSize()), new Vec2d((Number)59, (Number)0), new Vec2d((Number)64, (Number)64));
                }
            }
        }
    }

    @Override
    public void drawSecondLayer(@NotNull Vec2d mouse) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        if (this.getBox().contains(mouse)) {
            CharSequence charSequence = this.tank.getClientFluidName();
            List<String> list = charSequence == null || charSequence.length() == 0 ? CollectionsKt.listOf("Fluid: Empty") : CollectionsKt.listOf(new String[]{"Fluid: " + this.tank.getClientFluidName(), "Amount: " + this.tank.getClientFluidAmount()});
            this.getGui().drawHoveringText(list, mouse);
        }
    }

    @NotNull
    public final Vec2d getPos() {
        return this.pos;
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    public CompFluidBar(@NotNull Vec2d pos, @NotNull Tank tank) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull((Object)tank, "tank");
        this.pos = pos;
        this.tank = tank;
        this.box = new Box(Vec2d.copy$default(this.pos, 0.0, this.pos.getY() - (double)48, 1, null), new Vec2d((Number)5, (Number)48));
    }

    @Override
    public boolean onMouseClick(@NotNull Vec2d mouse, int mouseButton) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        return IComponent.DefaultImpls.onMouseClick(this, mouse, mouseButton);
    }

    @Override
    public boolean onMouseClickMove(@NotNull Vec2d mouse, int clickedMouseButton, long timeSinceLastClick) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        return IComponent.DefaultImpls.onMouseClickMove(this, mouse, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public void onMouseReleased(@NotNull Vec2d mouse, int state) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        IComponent.DefaultImpls.onMouseReleased(this, mouse, state);
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        return IComponent.DefaultImpls.onKeyTyped(this, typedChar, keyCode);
    }

    @Override
    public boolean isMouseInside(@NotNull Vec2d mouse) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        return IComponent.DefaultImpls.isMouseInside(this, mouse);
    }

    @Override
    public void onGuiClosed() {
        IComponent.DefaultImpls.onGuiClosed(this);
    }
}

