/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.gui.client.components;

import com.cout970.magneticraft.gui.client.IComponent;
import com.cout970.magneticraft.gui.client.IGui;
import com.cout970.magneticraft.gui.client.components.CompVerticalBarKt;
import com.cout970.magneticraft.gui.client.components.IBarProvider;
import com.cout970.magneticraft.util.misc.Box;
import com.cout970.magneticraft.util.vector.Vec2d;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\fJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lcom/cout970/magneticraft/gui/client/components/CompVerticalBar;", "Lcom/cout970/magneticraft/gui/client/IComponent;", "provider", "Lcom/cout970/magneticraft/gui/client/components/IBarProvider;", "index", "", "pos", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "tooltip", "Lkotlin/Function0;", "", "", "(Lcom/cout970/magneticraft/gui/client/components/IBarProvider;ILcom/cout970/magneticraft/util/vector/Vec2d;Lkotlin/jvm/functions/Function0;)V", "box", "Lcom/cout970/magneticraft/util/misc/Box;", "getBox", "()Lcom/cout970/magneticraft/util/misc/Box;", "gui", "Lcom/cout970/magneticraft/gui/client/IGui;", "getGui", "()Lcom/cout970/magneticraft/gui/client/IGui;", "setGui", "(Lcom/cout970/magneticraft/gui/client/IGui;)V", "getIndex", "()I", "getPos", "()Lcom/cout970/magneticraft/util/vector/Vec2d;", "getProvider", "()Lcom/cout970/magneticraft/gui/client/components/IBarProvider;", "size", "getSize", "getTooltip", "()Lkotlin/jvm/functions/Function0;", "drawFirstLayer", "", "mouse", "partialTicks", "", "drawSecondLayer", "magneticraft-compileKotlin"})
public class CompVerticalBar
implements IComponent {
    @NotNull
    private final Vec2d size;
    @NotNull
    private final Box box;
    @NotNull
    public IGui gui;
    @NotNull
    private final IBarProvider provider;
    private final int index;
    @NotNull
    private final Vec2d pos;
    @NotNull
    private final Function0<List<String>> tooltip;

    @NotNull
    public final Vec2d getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Box getBox() {
        return this.box;
    }

    @Override
    @NotNull
    public IGui getGui() {
        IGui iGui = this.gui;
        if (iGui == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gui");
        }
        return iGui;
    }

    @Override
    public void setGui(@NotNull IGui iGui) {
        Intrinsics.checkParameterIsNotNull(iGui, "<set-?>");
        this.gui = iGui;
    }

    @Override
    public void drawFirstLayer(@NotNull Vec2d mouse, float partialTicks) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        IGui iGui = this.getGui();
        IGui $receiver = iGui;
        $receiver.bindTexture(CompVerticalBarKt.getBAR_TEXTURES());
        int level = (int)(this.provider.getLevel() * (float)48);
        $receiver.drawScaledTexture(new Vec2d((Number)this.pos.getX(), (Number)(this.pos.getYi() - level)), new Vec2d((Number)5, (Number)level), new Vec2d((Number)(this.index * 5), (Number)(48 - level)), new Vec2d((Number)64, (Number)64));
    }

    @Override
    public void drawSecondLayer(@NotNull Vec2d mouse) {
        List<String> text;
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        if (this.getBox().contains(mouse) && !(text = this.tooltip.invoke()).isEmpty()) {
            this.getGui().drawHoveringText(text, mouse);
        }
    }

    @NotNull
    public final IBarProvider getProvider() {
        return this.provider;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final Vec2d getPos() {
        return this.pos;
    }

    @NotNull
    public final Function0<List<String>> getTooltip() {
        return this.tooltip;
    }

    public CompVerticalBar(@NotNull IBarProvider provider, int index, @NotNull Vec2d pos, @NotNull Function0<? extends List<String>> tooltip) {
        Intrinsics.checkParameterIsNotNull(provider, "provider");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        this.provider = provider;
        this.index = index;
        this.pos = pos;
        this.tooltip = tooltip;
        this.size = new Vec2d((Number)5, (Number)48);
        this.box = new Box(Vec2d.copy$default(this.pos, 0.0, this.pos.getY() - this.size.getY(), 1, null), this.size);
    }

    public /* synthetic */ CompVerticalBar(IBarProvider iBarProvider, int n, Vec2d vec2d, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(iBarProvider, n, vec2d, function0);
    }

    @Override
    public boolean onMouseClick(@NotNull Vec2d mouse, int mouseButton) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        return IComponent.DefaultImpls.onMouseClick(this, mouse, mouseButton);
    }

    @Override
    public boolean onMouseClickMove(@NotNull Vec2d mouse, int clickedMouseButton, long timeSinceLastClick) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        return IComponent.DefaultImpls.onMouseClickMove(this, mouse, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public void onMouseReleased(@NotNull Vec2d mouse, int state) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        IComponent.DefaultImpls.onMouseReleased(this, mouse, state);
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        return IComponent.DefaultImpls.onKeyTyped(this, typedChar, keyCode);
    }

    @Override
    public boolean isMouseInside(@NotNull Vec2d mouse) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        return IComponent.DefaultImpls.isMouseInside(this, mouse);
    }

    @Override
    public void onGuiClosed() {
        IComponent.DefaultImpls.onGuiClosed(this);
    }
}

