/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.gui.client.components;

import com.cout970.magneticraft.gui.client.IGui;
import com.cout970.magneticraft.gui.client.components.CompVerticalBar;
import com.cout970.magneticraft.gui.client.components.CompVerticalBarKt;
import com.cout970.magneticraft.gui.client.components.EmptyBarProvider;
import com.cout970.magneticraft.gui.client.components.IBarProvider;
import com.cout970.magneticraft.util.vector.Vec2d;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/cout970/magneticraft/gui/client/components/TransferBar;", "Lcom/cout970/magneticraft/gui/client/components/CompVerticalBar;", "Lcom/cout970/magneticraft/gui/client/components/IBarProvider;", "value", "Lkotlin/Function0;", "", "min", "base", "max", "pos", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/cout970/magneticraft/util/vector/Vec2d;)V", "getBase", "()Lkotlin/jvm/functions/Function0;", "getMax", "getMin", "getValue", "drawFirstLayer", "", "mouse", "partialTicks", "", "drawSecondLayer", "getLevel", "magneticraft-compileKotlin"})
public final class TransferBar
extends CompVerticalBar
implements IBarProvider {
    @NotNull
    private final Function0<Double> value;
    @NotNull
    private final Function0<Double> min;
    @NotNull
    private final Function0<Double> base;
    @NotNull
    private final Function0<Double> max;

    @Override
    public void drawFirstLayer(@NotNull Vec2d mouse, float partialTicks) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        IGui iGui = this.getGui();
        IGui $receiver = iGui;
        $receiver.bindTexture(CompVerticalBarKt.getBAR_TEXTURES());
        int level = Math.round(this.getLevel() * (float)24);
        if (level > 0) {
            $receiver.drawScaledTexture(new Vec2d((Number)this.getPos().getX(), (Number)(this.getPos().getYi() - level - 24)), new Vec2d((Number)5, (Number)level), new Vec2d((Number)(this.getIndex() * 5), (Number)(24 - level)), new Vec2d((Number)64, (Number)64));
        } else if (level < 0) {
            level = -level;
            $receiver.drawScaledTexture(new Vec2d((Number)this.getPos().getX(), (Number)(this.getPos().getYi() - 23)), new Vec2d((Number)5, (Number)(level - 1)), new Vec2d((Number)(this.getIndex() * 5), (Number)(49 - level)), new Vec2d((Number)64, (Number)64));
        }
    }

    @Override
    public void drawSecondLayer(@NotNull Vec2d mouse) {
        Intrinsics.checkParameterIsNotNull(mouse, "mouse");
        if (this.getBox().contains(mouse)) {
            String string;
            if (((Number)this.value.invoke()).doubleValue() > 0.0) {
                string = TextFormatting.DARK_GREEN.toString() + "+";
            } else {
                String string2 = ((Number)this.value.invoke()).doubleValue() < 0.0 ? TextFormatting.DARK_RED.toString() : TextFormatting.WHITE.toString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull(string2, "if (value.invoke() < 0) \u2026.toString()\n            }");
            }
            String color = string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%s%.2fW";
            Object[] objectArray = new Object[]{color, this.value.invoke()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string4, "java.lang.String.format(format, *args)");
            List<String> list = CollectionsKt.listOf(string4);
            this.getGui().drawHoveringText(list, mouse);
        }
    }

    @Override
    public float getLevel() {
        if (((Number)this.value.invoke()).doubleValue() < ((Number)this.min.invoke()).doubleValue()) {
            return -1.0f;
        }
        if (((Number)this.value.invoke()).doubleValue() > ((Number)this.max.invoke()).doubleValue()) {
            return 1.0f;
        }
        if (((Number)this.value.invoke()).doubleValue() < ((Number)this.base.invoke()).doubleValue()) {
            return (float)-1 + (float)((((Number)this.value.invoke()).doubleValue() - ((Number)this.min.invoke()).doubleValue()) / (((Number)this.base.invoke()).doubleValue() - ((Number)this.min.invoke()).doubleValue()));
        }
        return (float)((((Number)this.value.invoke()).doubleValue() - ((Number)this.base.invoke()).doubleValue()) / (((Number)this.max.invoke()).doubleValue() - ((Number)this.base.invoke()).doubleValue()));
    }

    @NotNull
    public final Function0<Double> getValue() {
        return this.value;
    }

    @NotNull
    public final Function0<Double> getMin() {
        return this.min;
    }

    @NotNull
    public final Function0<Double> getBase() {
        return this.base;
    }

    @NotNull
    public final Function0<Double> getMax() {
        return this.max;
    }

    public TransferBar(@NotNull Function0<Double> value, @NotNull Function0<Double> min, @NotNull Function0<Double> base, @NotNull Function0<Double> max, @NotNull Vec2d pos) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(min, "min");
        Intrinsics.checkParameterIsNotNull(base, "base");
        Intrinsics.checkParameterIsNotNull(max, "max");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        super(EmptyBarProvider.INSTANCE, 4, pos, null, 8, null);
        this.value = value;
        this.min = min;
        this.base = base;
        this.max = max;
    }
}

