/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.guide.components;

import coffee.cypher.mcextlib.extensions.strings.StringsKt;
import com.cout970.magneticraft.gui.client.guide.GuiGuideBook;
import com.cout970.magneticraft.gui.client.guide.GuiGuideBookKt;
import com.cout970.magneticraft.gui.client.guide.GuiPageComponent;
import com.cout970.magneticraft.guide.EntriesKt;
import com.cout970.magneticraft.guide.LinkInfo;
import com.cout970.magneticraft.guide.Page;
import com.cout970.magneticraft.guide.components.PageComponent;
import com.cout970.magneticraft.guide.components.TextKt;
import com.cout970.magneticraft.util.vector.Vec2d;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/cout970/magneticraft/guide/components/Text;", "Lcom/cout970/magneticraft/guide/components/PageComponent;", "position", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "size", "text", "", "(Lcom/cout970/magneticraft/util/vector/Vec2d;Lcom/cout970/magneticraft/util/vector/Vec2d;Ljava/lang/String;)V", "getSize", "()Lcom/cout970/magneticraft/util/vector/Vec2d;", "words", "", "Lkotlin/Pair;", "Lcom/cout970/magneticraft/guide/LinkInfo;", "getWords", "()Ljava/util/List;", "toGuiComponent", "Lcom/cout970/magneticraft/gui/client/guide/GuiPageComponent;", "parent", "Lcom/cout970/magneticraft/guide/Page$Gui;", "Lcom/cout970/magneticraft/guide/Page;", "TextBox", "TextComponentGui", "magneticraft-compileKotlin"})
public final class Text
extends PageComponent {
    @NotNull
    private final List<Pair<String, LinkInfo>> words;
    @NotNull
    private final Vec2d size;

    @NotNull
    public final List<Pair<String, LinkInfo>> getWords() {
        return this.words;
    }

    @Override
    @NotNull
    public GuiPageComponent toGuiComponent(@NotNull Page.Gui parent) {
        Intrinsics.checkParameterIsNotNull(parent, "parent");
        return new TextComponentGui(parent);
    }

    @Override
    @NotNull
    public Vec2d getSize() {
        return this.size;
    }

    public Text(@NotNull Vec2d position, @NotNull Vec2d size, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(size, "size");
        Intrinsics.checkParameterIsNotNull(text, "text");
        super(position);
        this.size = size;
        this.words = TextKt.parseText(text);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0017\u001a\u00020\u000fJ\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/cout970/magneticraft/guide/components/Text$TextComponentGui;", "Lcom/cout970/magneticraft/guide/components/PageComponent$Gui;", "Lcom/cout970/magneticraft/guide/components/PageComponent;", "parent", "Lcom/cout970/magneticraft/guide/Page$Gui;", "Lcom/cout970/magneticraft/guide/Page;", "(Lcom/cout970/magneticraft/guide/components/Text;Lcom/cout970/magneticraft/guide/Page$Gui;)V", "boxes", "", "Lcom/cout970/magneticraft/guide/components/Text$TextBox;", "getBoxes", "()Ljava/util/List;", "setBoxes", "(Ljava/util/List;)V", "draw", "", "mouse", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "time", "", "initGui", "onLeftClick", "", "placeBoxes", "postDraw", "magneticraft-compileKotlin"})
    private final class TextComponentGui
    extends PageComponent.Gui {
        @NotNull
        public List<TextBox> boxes;

        @NotNull
        public final List<TextBox> getBoxes() {
            List<TextBox> list = this.boxes;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("boxes");
            }
            return list;
        }

        public final void setBoxes(@NotNull List<TextBox> list) {
            Intrinsics.checkParameterIsNotNull(list, "<set-?>");
            this.boxes = list;
        }

        @Override
        public void initGui() {
            super.initGui();
            this.placeBoxes();
        }

        public final void placeBoxes() {
            int x = 0;
            int y = 0;
            List<TextBox> boxList = CollectionsKt.mutableListOf(new TextBox[0]);
            int space = this.getParent().getGui().getCharWidth(' ');
            for (Pair<String, LinkInfo> pair : Text.this.getWords()) {
                TextBox textBox;
                Collection collection;
                String word = pair.component1();
                LinkInfo link = pair.component2();
                int width = this.getParent().getGui().getStringWidth(word);
                if ((double)width > this.getSize().getX()) {
                    throw (Throwable)new IllegalStateException("Word " + word + " is larger than text box. Increase text box width or change the word.");
                }
                if ((double)(x + width) > this.getSize().getX()) {
                    x = 0;
                    if ((double)(y += GuiGuideBookKt.getFONT_HEIGHT() + 1) > this.getSize().getY()) {
                        throw (Throwable)new IllegalStateException("Text is larger than the text box.");
                    }
                } else {
                    collection = boxList;
                    if (!collection.isEmpty() && Intrinsics.areEqual(CollectionsKt.last(boxList).getLink(), link)) {
                        CollectionsKt.last(boxList).setNextLink(true);
                    }
                }
                if ((double)(x + space) > this.getSize().getX()) {
                    collection = boxList;
                    textBox = new TextBox(this, new Vec2d((Number)x, (Number)y), word, false, link);
                    collection.add(textBox);
                } else {
                    collection = boxList;
                    textBox = new TextBox(this, new Vec2d((Number)x, (Number)y), word, true, link);
                    collection.add(textBox);
                    x += space;
                }
                x += width;
            }
            this.boxes = boxList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void draw(@NotNull Vec2d mouse, double time) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(mouse, "mouse");
            List<TextBox> list = this.boxes;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("boxes");
            }
            Iterable iterable = list;
            for (Object element$iv : $receiver$iv) {
                TextBox it = (TextBox)element$iv;
                it.draw(mouse);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void postDraw(@NotNull Vec2d mouse, double time) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(mouse, "mouse");
            List<TextBox> list = this.boxes;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("boxes");
            }
            Iterable iterable = list;
            for (Object element$iv : $receiver$iv) {
                TextBox it = (TextBox)element$iv;
                it.postDraw(mouse);
            }
        }

        @Override
        public boolean onLeftClick(@NotNull Vec2d mouse) {
            TextBox box;
            Object v1;
            block4: {
                Intrinsics.checkParameterIsNotNull(mouse, "mouse");
                List<TextBox> list = this.boxes;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("boxes");
                }
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    TextBox it = (TextBox)element$iv;
                    if (!(it.isInside(mouse) && it.getLink() != null)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            if ((box = (TextBox)v1) == null) {
                return false;
            }
            if (box.getLink() == null) {
                return false;
            }
            this.getParent().getGui().field_146297_k.func_147108_a((GuiScreen)new GuiGuideBook(box.getLink().getEntryTarget()));
            return true;
        }

        public TextComponentGui(Page.Gui parent) {
            Intrinsics.checkParameterIsNotNull(parent, "parent");
            super(parent);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B5\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0018\u001a\u00060\u0019R\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010 \u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006+"}, d2={"Lcom/cout970/magneticraft/guide/components/Text$TextBox;", "", "parent", "Lcom/cout970/magneticraft/guide/components/PageComponent$Gui;", "Lcom/cout970/magneticraft/guide/components/PageComponent;", "position", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "text", "", "space", "", "link", "Lcom/cout970/magneticraft/guide/LinkInfo;", "(Lcom/cout970/magneticraft/guide/components/PageComponent$Gui;Lcom/cout970/magneticraft/util/vector/Vec2d;Ljava/lang/String;ZLcom/cout970/magneticraft/guide/LinkInfo;)V", "drawPos", "getDrawPos", "()Lcom/cout970/magneticraft/util/vector/Vec2d;", "getLink", "()Lcom/cout970/magneticraft/guide/LinkInfo;", "nextLink", "getNextLink", "()Z", "setNextLink", "(Z)V", "page", "Lcom/cout970/magneticraft/guide/Page$Gui;", "Lcom/cout970/magneticraft/guide/Page;", "getPage", "()Lcom/cout970/magneticraft/guide/Page$Gui;", "getParent", "()Lcom/cout970/magneticraft/guide/components/PageComponent$Gui;", "getPosition", "size", "getSize", "getSpace", "getText", "()Ljava/lang/String;", "draw", "", "mouse", "isInside", "pos", "postDraw", "magneticraft-compileKotlin"})
    private static final class TextBox {
        @NotNull
        private final Page.Gui page;
        @NotNull
        private final Vec2d size;
        private boolean nextLink;
        @NotNull
        private final PageComponent.Gui parent;
        @NotNull
        private final Vec2d position;
        @NotNull
        private final String text;
        private final boolean space;
        @Nullable
        private final LinkInfo link;

        @NotNull
        public final Page.Gui getPage() {
            return this.page;
        }

        @NotNull
        public final Vec2d getSize() {
            return this.size;
        }

        public final boolean getNextLink() {
            return this.nextLink;
        }

        public final void setNextLink(boolean bl) {
            this.nextLink = bl;
        }

        @NotNull
        public final Vec2d getDrawPos() {
            return this.parent.getDrawPos().plus(this.position);
        }

        public final boolean isInside(@NotNull Vec2d pos) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            return this.getDrawPos().to(this.getDrawPos().plus(this.size)).contains(pos);
        }

        public final void draw(@NotNull Vec2d mouse) {
            String prefix;
            Intrinsics.checkParameterIsNotNull(mouse, "mouse");
            String string = this.link == null ? "\u00a7r" : (prefix = this.isInside(mouse) ? "\u00a79\u00a7n" : "\u00a7r\u00a7n");
            String spaceFormat = this.space ? (this.nextLink ? " " : "\u00a7r ") : "";
            this.page.getGui().drawString(this.getDrawPos(), prefix + this.text + spaceFormat);
        }

        public final void postDraw(@NotNull Vec2d mouse) {
            Intrinsics.checkParameterIsNotNull(mouse, "mouse");
            if (this.link != null && this.isInside(mouse)) {
                this.page.getGui().drawHoveringText(CollectionsKt.listOf(I18n.func_135052_a((String)(EntriesKt.GUIDE_LANG + ".link.text"), (Object[])new Object[]{StringsKt.i18n(this.link.getEntry()), this.link.getPage() + 1})), mouse);
            }
        }

        @NotNull
        public final PageComponent.Gui getParent() {
            return this.parent;
        }

        @NotNull
        public final Vec2d getPosition() {
            return this.position;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getSpace() {
            return this.space;
        }

        @Nullable
        public final LinkInfo getLink() {
            return this.link;
        }

        public TextBox(@NotNull PageComponent.Gui parent, @NotNull Vec2d position, @NotNull String text, boolean space, @Nullable LinkInfo link) {
            Intrinsics.checkParameterIsNotNull(parent, "parent");
            Intrinsics.checkParameterIsNotNull(position, "position");
            Intrinsics.checkParameterIsNotNull(text, "text");
            this.parent = parent;
            this.position = position;
            this.text = text;
            this.space = space;
            this.link = link;
            this.page = this.parent.getParent();
            this.size = new Vec2d((Number)this.page.getGui().getStringWidth(this.text), (Number)GuiGuideBookKt.getFONT_HEIGHT());
        }

        public /* synthetic */ TextBox(PageComponent.Gui gui, Vec2d vec2d, String string, boolean bl, LinkInfo linkInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                linkInfo = null;
            }
            this(gui, vec2d, string, bl, linkInfo);
        }
    }
}

