/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.integration.tesla;

import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.config.Config;
import com.cout970.magneticraft.util.EletricityKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/cout970/magneticraft/integration/tesla/TeslaNodeWrapper;", "Lnet/darkhax/tesla/api/ITeslaHolder;", "Lnet/darkhax/tesla/api/ITeslaProducer;", "Lnet/darkhax/tesla/api/ITeslaConsumer;", "node", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;)V", "getNode", "()Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getCapacity", "", "getStoredPower", "givePower", "power", "simulated", "", "takePower", "magneticraft-compileKotlin"})
public final class TeslaNodeWrapper
implements ITeslaHolder,
ITeslaProducer,
ITeslaConsumer {
    @NotNull
    private final IElectricNode node;

    public long getCapacity() {
        return (long)(Config.INSTANCE.getWattsToTesla() * this.node.getCapacity() * EletricityKt.getTIER_1_MAX_VOLTAGE() * EletricityKt.getTIER_1_MAX_VOLTAGE() / (double)2);
    }

    public long getStoredPower() {
        return (long)(Config.INSTANCE.getWattsToTesla() * this.node.getCapacity() * this.node.getVoltage() * this.node.getVoltage() / (double)2);
    }

    public long takePower(long power, boolean simulated) {
        return (long)Math.ceil(this.node.applyPower(-((double)power) / Config.INSTANCE.getWattsToTesla(), simulated));
    }

    public long givePower(long power, boolean simulated) {
        double give = (double)power / Config.INSTANCE.getWattsToTesla();
        if (give + (double)this.getStoredPower() >= (double)this.getCapacity()) {
            give = (double)this.getCapacity() - (double)this.getStoredPower();
        }
        return (long)Math.ceil(this.node.applyPower(give, simulated));
    }

    @NotNull
    public final IElectricNode getNode() {
        return this.node;
    }

    public TeslaNodeWrapper(@NotNull IElectricNode node2) {
        Intrinsics.checkParameterIsNotNull(node2, "node");
        this.node = node2;
    }
}

