/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.item;

import com.cout970.magneticraft.api.energy.IManualConnectionHandler;
import com.cout970.magneticraft.item.ItemBase;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.util.NamedBinaryTagKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016JV\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/cout970/magneticraft/item/ItemCoilOfWire;", "Lcom/cout970/magneticraft/item/ItemBase;", "()V", "POSITION_KEY", "", "getPOSITION_KEY", "()Ljava/lang/String;", "getItemStackDisplayName", "stack", "Lnet/minecraft/item/ItemStack;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "magneticraft-compileKotlin"})
public final class ItemCoilOfWire
extends ItemBase {
    @NotNull
    private static final String POSITION_KEY = "Position";
    public static final ItemCoilOfWire INSTANCE;

    @NotNull
    public final String getPOSITION_KEY() {
        return POSITION_KEY;
    }

    @NotNull
    public String func_77653_i(@Nullable ItemStack stack) {
        String name = super.func_77653_i(stack);
        ItemStack itemStack = stack;
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        if (NamedBinaryTagKt.hasKey(itemStack, POSITION_KEY)) {
            BlockPos basePos = NamedBinaryTagKt.getBlockPos(stack, POSITION_KEY);
            return name + (" [" + TextFormatting.AQUA + "Position: " + basePos.func_177958_n() + ", " + basePos.func_177956_o() + ", " + basePos.func_177952_p() + "]");
        }
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull(string, "name");
        return string;
    }

    @NotNull
    public EnumActionResult func_180614_a(@Nullable ItemStack stack, @Nullable EntityPlayer playerIn, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumHand hand, @Nullable EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        if (stack == null) {
            return EnumActionResult.PASS;
        }
        IBlockState block = worldIn.func_180495_p(pos);
        Capability<IManualConnectionHandler> capability = CapabilitiesKt.getMANUAL_CONNECTION_HANDLER();
        if (capability == null) {
            Intrinsics.throwNpe();
        }
        Block block2 = block.func_177230_c();
        Intrinsics.checkExpressionValueIsNotNull(block2, "block.block");
        IManualConnectionHandler handler = (IManualConnectionHandler)CapabilitiesKt.fromBlock$default(capability, block2, null, 2, null);
        if (handler != null) {
            EntityPlayer entityPlayer = playerIn;
            if (entityPlayer == null) {
                Intrinsics.throwNpe();
            }
            if (entityPlayer.func_70093_af()) {
                BlockPos basePos = handler.getBasePos(pos, worldIn, playerIn, facing, stack);
                if (basePos != null) {
                    NamedBinaryTagKt.setBlockPos(stack, POSITION_KEY, basePos);
                    return EnumActionResult.SUCCESS;
                }
            } else {
                if (NamedBinaryTagKt.hasKey(stack, POSITION_KEY)) {
                    BlockPos basePos = NamedBinaryTagKt.getBlockPos(stack, POSITION_KEY);
                    if (handler.connectWire(basePos, pos, worldIn, playerIn, facing, stack)) {
                        if (!worldIn.field_72995_K) {
                            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.magneticraft.wire_connect.success", new Object[0]));
                        }
                    } else if (!worldIn.field_72995_K) {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.magneticraft.wire_connect.fail", new Object[0]));
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (!worldIn.field_72995_K) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.magneticraft.wire_connect.no_other_connector", new Object[0]));
                }
            }
        }
        return EnumActionResult.PASS;
    }

    private ItemCoilOfWire() {
        super("coil_of_wire", null, 2, null);
        INSTANCE = this;
        POSITION_KEY = POSITION_KEY;
    }

    static {
        new ItemCoilOfWire();
    }
}

