/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.multiblock;

import com.cout970.magneticraft.multiblock.BlockData;
import com.cout970.magneticraft.multiblock.IMultiblockComponent;
import com.cout970.magneticraft.multiblock.Multiblock;
import com.cout970.magneticraft.multiblock.MultiblockContext;
import com.cout970.magneticraft.multiblock.impl.MultiblockHydraulicPress;
import com.cout970.magneticraft.multiblock.impl.MultiblockSolarPanel;
import com.cout970.magneticraft.util.MultiblockUtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cout970/magneticraft/multiblock/MultiblockManager;", "", "()V", "multiblocks", "", "", "Lcom/cout970/magneticraft/multiblock/Multiblock;", "activateMultiblockStructure", "", "context", "Lcom/cout970/magneticraft/multiblock/MultiblockContext;", "checkMultiblockStructure", "", "Lnet/minecraft/util/text/ITextComponent;", "deactivateMultiblockStructure", "getMultiblock", "name", "registerDefaults", "registerMultiblock", "mb", "magneticraft-compileKotlin"})
public final class MultiblockManager {
    private static final Map<String, Multiblock> multiblocks;
    public static final MultiblockManager INSTANCE;

    public final void registerMultiblock(@NotNull Multiblock mb) {
        Intrinsics.checkParameterIsNotNull(mb, "mb");
        Map<String, Multiblock> map = multiblocks;
        String string = mb.getName();
        Map<String, Multiblock> map2 = map;
        Map<String, Multiblock> map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (map3.containsKey(string)) {
            throw (Throwable)new IllegalArgumentException("Multiblock with name: " + mb.getName() + " is already registered");
        }
        multiblocks.put(mb.getName(), mb);
    }

    @Nullable
    public final Multiblock getMultiblock(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return multiblocks.get(name);
    }

    public final void registerDefaults() {
        this.registerMultiblock(MultiblockHydraulicPress.INSTANCE);
        this.registerMultiblock(MultiblockSolarPanel.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ITextComponent> checkMultiblockStructure(@NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        List<ITextComponent> list = CollectionsKt.mutableListOf(new ITextComponent[0]);
        List<BlockData> data = CollectionsKt.mutableListOf(new BlockData[0]);
        IntRange intRange = RangesKt.until(0, context.getMultiblock().getSize().func_177956_o());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void j;
                int n3;
                IntRange intRange2 = RangesKt.until(0, context.getMultiblock().getSize().func_177958_n());
                int n4 = intRange2.getFirst();
                if (n4 <= (n3 = intRange2.getLast())) {
                    while (true) {
                        void i;
                        int n5;
                        IntRange intRange3 = RangesKt.until(0, context.getMultiblock().getSize().func_177952_p());
                        int n6 = intRange3.getFirst();
                        if (n6 <= (n5 = intRange3.getLast())) {
                            while (true) {
                                void k;
                                BlockPos pos = MultiblockUtilsKt.rotatePoint(context.getFacing(), context.getMultiblock().getCenter(), new BlockPos((int)i, (int)j, (int)k)).func_177973_b((Vec3i)context.getMultiblock().getCenter());
                                IMultiblockComponent comp = MultiblockUtilsKt.get(context.getMultiblock().getScheme(), (int)i, (int)j, (int)k);
                                BlockPos blockPos = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                                List<ITextComponent> res = comp.checkBlock(blockPos, context);
                                BlockPos blockPos2 = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos");
                                data.add(comp.getBlockData(blockPos2, context));
                                Collection collection = res;
                                if (!collection.isEmpty()) {
                                    list.addAll((Collection<ITextComponent>)res);
                                }
                                if (k == n5) break;
                                ++k;
                            }
                        }
                        if (i == n3) break;
                        ++i;
                    }
                }
                if (j == n2) break;
                ++j;
            }
        }
        list.addAll((Collection<ITextComponent>)context.getMultiblock().checkExtraRequirements(data, context));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void activateMultiblockStructure(@NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        List<BlockData> data = CollectionsKt.mutableListOf(new BlockData[0]);
        IntRange intRange = RangesKt.until(0, context.getMultiblock().getSize().func_177956_o());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void j;
                int n3;
                IntRange intRange2 = RangesKt.until(0, context.getMultiblock().getSize().func_177958_n());
                int n4 = intRange2.getFirst();
                if (n4 <= (n3 = intRange2.getLast())) {
                    while (true) {
                        void i;
                        int n5;
                        IntRange intRange3 = RangesKt.until(0, context.getMultiblock().getSize().func_177952_p());
                        int n6 = intRange3.getFirst();
                        if (n6 <= (n5 = intRange3.getLast())) {
                            while (true) {
                                void k;
                                BlockPos pos = MultiblockUtilsKt.rotatePoint(context.getFacing(), context.getMultiblock().getCenter(), new BlockPos((int)i, (int)j, (int)k)).func_177973_b((Vec3i)context.getMultiblock().getCenter());
                                IMultiblockComponent comp = MultiblockUtilsKt.get(context.getMultiblock().getScheme(), (int)i, (int)j, (int)k);
                                BlockPos blockPos = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                                comp.activateBlock(blockPos, context);
                                BlockPos blockPos2 = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos");
                                data.add(comp.getBlockData(blockPos2, context));
                                if (k == n5) break;
                                ++k;
                            }
                        }
                        if (i == n3) break;
                        ++i;
                    }
                }
                if (j == n2) break;
                ++j;
            }
        }
        context.getMultiblock().onActivate(data, context);
    }

    /*
     * WARNING - void declaration
     */
    public final void deactivateMultiblockStructure(@NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        List<BlockData> data = CollectionsKt.mutableListOf(new BlockData[0]);
        IntRange intRange = RangesKt.until(0, context.getMultiblock().getSize().func_177956_o());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void j;
                int n3;
                IntRange intRange2 = RangesKt.until(0, context.getMultiblock().getSize().func_177958_n());
                int n4 = intRange2.getFirst();
                if (n4 <= (n3 = intRange2.getLast())) {
                    while (true) {
                        void i;
                        int n5;
                        IntRange intRange3 = RangesKt.until(0, context.getMultiblock().getSize().func_177952_p());
                        int n6 = intRange3.getFirst();
                        if (n6 <= (n5 = intRange3.getLast())) {
                            while (true) {
                                void k;
                                BlockPos pos = MultiblockUtilsKt.rotatePoint(context.getFacing(), context.getMultiblock().getCenter(), new BlockPos((int)i, (int)j, (int)k)).func_177973_b((Vec3i)context.getMultiblock().getCenter());
                                IMultiblockComponent comp = MultiblockUtilsKt.get(context.getMultiblock().getScheme(), (int)i, (int)j, (int)k);
                                BlockPos blockPos = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                                comp.deactivateBlock(blockPos, context);
                                BlockPos blockPos2 = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos");
                                data.add(comp.getBlockData(blockPos2, context));
                                if (k == n5) break;
                                ++k;
                            }
                        }
                        if (i == n3) break;
                        ++i;
                    }
                }
                if (j == n2) break;
                ++j;
            }
        }
        context.getMultiblock().onDeactivate(data, context);
    }

    private MultiblockManager() {
        INSTANCE = this;
        multiblocks = MapsKt.mutableMapOf(new Pair[0]);
    }

    static {
        new MultiblockManager();
    }
}

