/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.multiblock.components;

import com.cout970.magneticraft.Debug;
import com.cout970.magneticraft.multiblock.BlockData;
import com.cout970.magneticraft.multiblock.IMultiblockComponent;
import com.cout970.magneticraft.multiblock.ITileMultiblock;
import com.cout970.magneticraft.multiblock.Multiblock;
import com.cout970.magneticraft.multiblock.MultiblockContext;
import com.cout970.magneticraft.util.MathKt;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/cout970/magneticraft/multiblock/components/ContextBlockComponent;", "Lcom/cout970/magneticraft/multiblock/IMultiblockComponent;", "getter", "Lkotlin/Function1;", "Lcom/cout970/magneticraft/multiblock/MultiblockContext;", "Lnet/minecraft/block/state/IBlockState;", "stack", "Lnet/minecraft/item/ItemStack;", "replacement", "(Lkotlin/jvm/functions/Function1;Lnet/minecraft/item/ItemStack;Lnet/minecraft/block/state/IBlockState;)V", "getGetter", "()Lkotlin/jvm/functions/Function1;", "getReplacement", "()Lnet/minecraft/block/state/IBlockState;", "getStack", "()Lnet/minecraft/item/ItemStack;", "activateBlock", "", "relativePos", "Lnet/minecraft/util/math/BlockPos;", "context", "checkBlock", "", "Lnet/minecraft/util/text/ITextComponent;", "deactivateBlock", "getBlockData", "Lcom/cout970/magneticraft/multiblock/BlockData;", "getBlueprintBlocks", "multiblock", "Lcom/cout970/magneticraft/multiblock/Multiblock;", "blockPos", "magneticraft-compileKotlin"})
public final class ContextBlockComponent
implements IMultiblockComponent {
    @NotNull
    private final Function1<MultiblockContext, IBlockState> getter;
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final IBlockState replacement;

    @Override
    @NotNull
    public List<ITextComponent> checkBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        IBlockState state = context.getWorld().func_180495_p(pos);
        if (Intrinsics.areEqual(state, this.getter.invoke(context)) ^ true) {
            Object[] objectArray;
            if (Debug.INSTANCE.getDEBUG()) {
                context.getWorld().func_175656_a(pos, this.getter.invoke(context));
            }
            String string = "[%d, %d, %d]";
            Object[] objectArray2 = new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            int n = 0;
            Object[] objectArray3 = objectArray = new Object[3];
            String string2 = "text.magneticraft.multiblock.invalid_block";
            String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
            String string4 = string3;
            objectArray[n] = string4;
            Object[] objectArray4 = objectArray3;
            objectArray3[1] = state.toString();
            objectArray4[2] = this.getter.invoke(context);
            return CollectionsKt.listOf(MinecraftUtilsKt.translate(string2, objectArray4));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BlockData getBlockData(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        IBlockState iBlockState = state = context.getWorld().func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        return new BlockData(iBlockState, pos);
    }

    @Override
    public void activateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        context.getWorld().func_175656_a(pos, this.replacement);
        TileEntity tile = context.getWorld().func_175625_s(pos);
        if (tile instanceof ITileMultiblock) {
            ((ITileMultiblock)tile).setMultiblock(context.getMultiblock());
            ((ITileMultiblock)tile).setMultiblockFacing(context.getFacing());
            ((ITileMultiblock)tile).setCenterPos(relativePos);
            ((ITileMultiblock)tile).onActivate();
        }
    }

    @Override
    public void deactivateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        TileEntity tile = context.getWorld().func_175625_s(pos);
        if (tile instanceof ITileMultiblock) {
            ((ITileMultiblock)tile).onDeactivate();
            ((ITileMultiblock)tile).setMultiblock(null);
            ((ITileMultiblock)tile).setMultiblockFacing(null);
            ((ITileMultiblock)tile).setCenterPos(null);
        }
        context.getWorld().func_175656_a(pos, this.getter.invoke(context));
    }

    @Override
    @NotNull
    public List<ItemStack> getBlueprintBlocks(@NotNull Multiblock multiblock, @NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull(multiblock, "multiblock");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        return CollectionsKt.listOf(this.stack);
    }

    @NotNull
    public final Function1<MultiblockContext, IBlockState> getGetter() {
        return this.getter;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final IBlockState getReplacement() {
        return this.replacement;
    }

    public ContextBlockComponent(@NotNull Function1<? super MultiblockContext, ? extends IBlockState> getter, @NotNull ItemStack stack, @NotNull IBlockState replacement) {
        Intrinsics.checkParameterIsNotNull(getter, "getter");
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        this.getter = getter;
        this.stack = stack;
        this.replacement = replacement;
    }
}

