/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.multiblock.components;

import com.cout970.magneticraft.multiblock.BlockData;
import com.cout970.magneticraft.multiblock.IMultiblockComponent;
import com.cout970.magneticraft.multiblock.ITileMultiblock;
import com.cout970.magneticraft.multiblock.Multiblock;
import com.cout970.magneticraft.multiblock.MultiblockContext;
import com.cout970.magneticraft.util.MathKt;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/cout970/magneticraft/multiblock/components/MainBlockComponent;", "Lcom/cout970/magneticraft/multiblock/IMultiblockComponent;", "block", "Lnet/minecraft/block/Block;", "getter", "Lkotlin/Function3;", "Lcom/cout970/magneticraft/multiblock/MultiblockContext;", "Lnet/minecraft/block/state/IBlockState;", "", "(Lnet/minecraft/block/Block;Lkotlin/jvm/functions/Function3;)V", "getBlock", "()Lnet/minecraft/block/Block;", "getGetter", "()Lkotlin/jvm/functions/Function3;", "activateBlock", "", "relativePos", "Lnet/minecraft/util/math/BlockPos;", "context", "checkBlock", "", "Lnet/minecraft/util/text/ITextComponent;", "deactivateBlock", "getBlockData", "Lcom/cout970/magneticraft/multiblock/BlockData;", "getBlueprintBlocks", "Lnet/minecraft/item/ItemStack;", "multiblock", "Lcom/cout970/magneticraft/multiblock/Multiblock;", "blockPos", "magneticraft-compileKotlin"})
public final class MainBlockComponent
implements IMultiblockComponent {
    @NotNull
    private final Block block;
    @NotNull
    private final Function3<MultiblockContext, IBlockState, Boolean, IBlockState> getter;

    @Override
    @NotNull
    public List<ITextComponent> checkBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        IBlockState state = context.getWorld().func_180495_p(pos);
        if (Intrinsics.areEqual(state.func_177230_c(), this.block) ^ true) {
            Object[] objectArray;
            String string = "[%d, %d, %d]";
            Object[] objectArray2 = new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            int n = 0;
            Object[] objectArray3 = objectArray = new Object[3];
            String string2 = "text.magneticraft.multiblock.invalid_block";
            String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
            String string4 = string3;
            objectArray[n] = string4;
            Object[] objectArray4 = objectArray3;
            Intrinsics.checkExpressionValueIsNotNull(state.func_177230_c().func_149732_F(), "state.block.localizedName");
            String string5 = this.block.func_149732_F();
            Intrinsics.checkExpressionValueIsNotNull(string5, "block.localizedName");
            objectArray4[2] = string5;
            return CollectionsKt.listOf(MinecraftUtilsKt.translate(string2, objectArray4));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BlockData getBlockData(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        IBlockState iBlockState = state = context.getWorld().func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        return new BlockData(iBlockState, pos);
    }

    @Override
    public void activateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        IBlockState state = context.getWorld().func_180495_p(pos);
        World world = context.getWorld();
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        world.func_175656_a(pos, this.getter.invoke(context, iBlockState, true));
        TileEntity tile = context.getWorld().func_175625_s(pos);
        if (tile instanceof ITileMultiblock) {
            ((ITileMultiblock)tile).setMultiblock(context.getMultiblock());
            ((ITileMultiblock)tile).setMultiblockFacing(context.getFacing());
            ((ITileMultiblock)tile).setCenterPos(relativePos);
            ((ITileMultiblock)tile).onActivate();
        }
    }

    @Override
    public void deactivateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull(relativePos, "relativePos");
        Intrinsics.checkParameterIsNotNull(context, "context");
        BlockPos pos = MathKt.plus(context.getCenter(), relativePos);
        IBlockState state = context.getWorld().func_180495_p(pos);
        TileEntity tile = context.getWorld().func_175625_s(pos);
        if (tile instanceof ITileMultiblock) {
            ((ITileMultiblock)tile).onDeactivate();
            ((ITileMultiblock)tile).setMultiblock(null);
            ((ITileMultiblock)tile).setMultiblockFacing(null);
            ((ITileMultiblock)tile).setCenterPos(null);
        }
        World world = context.getWorld();
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        world.func_175656_a(pos, this.getter.invoke(context, iBlockState, false));
    }

    @Override
    @NotNull
    public List<ItemStack> getBlueprintBlocks(@NotNull Multiblock multiblock, @NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull(multiblock, "multiblock");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public final Function3<MultiblockContext, IBlockState, Boolean, IBlockState> getGetter() {
        return this.getter;
    }

    public MainBlockComponent(@NotNull Block block, @NotNull Function3<? super MultiblockContext, ? super IBlockState, ? super Boolean, ? extends IBlockState> getter) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull(getter, "getter");
        this.block = block;
        this.getter = getter;
    }
}

